/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.hive.BucketingType;
import io.trino.tests.hive.HiveProductTest;
import io.trino.tests.hive.TestHiveMetastoreClientFactory;
import io.trino.tests.hive.TransactionalTableType;
import io.trino.tests.hive.util.TableLocationUtils;
import io.trino.tests.hive.util.TemporaryHiveTable;
import io.trino.tests.utils.QueryExecutors;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveTransactionalTable
extends HiveProductTest {
    private static final Logger log = Logger.get(TestHiveTransactionalTable.class);
    private static final int TEST_TIMEOUT = 900000;
    @Inject
    private TestHiveMetastoreClientFactory testHiveMetastoreClientFactory;
    @Inject
    private HdfsClient hdfsClient;

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testReadFullAcid() {
        this.doTestReadFullAcid(false, BucketingType.NONE);
    }

    @Flaky(issue="https://github.com/trinodb/trino/issues/4927", match="Hive table .* is corrupt. Found sub-directory in bucket directory for partition")
    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testReadFullAcidBucketed() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_DEFAULT);
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testReadFullAcidPartitioned() {
        this.doTestReadFullAcid(true, BucketingType.NONE);
    }

    @Test(groups={"hive_transactional", "storage_formats"}, timeOut=900000L)
    public void testReadFullAcidPartitionedBucketed() {
        this.doTestReadFullAcid(true, BucketingType.BUCKETED_DEFAULT);
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    @Flaky(issue="https://github.com/trinodb/trino/issues/4927", match="Hive table .* is corrupt. Found sub-directory in bucket directory for partition")
    public void testReadFullAcidBucketedV1() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_V1);
    }

    @Flaky(issue="https://github.com/trinodb/trino/issues/4927", match="Hive table .* is corrupt. Found sub-directory in bucket directory for partition")
    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testReadFullAcidBucketedV2() {
        this.doTestReadFullAcid(false, BucketingType.BUCKETED_V2);
    }

    private void doTestReadFullAcid(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName("read_full_acid", isPartitioned, bucketingType));){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " VALUES (21, 1)", new QueryExecutor.QueryParam[0]);
            String selectFromOnePartitionsSql = "SELECT col, fcol FROM " + tableName + " ORDER BY col";
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (22, 2)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1 ORDER BY col"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (24, 4)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " where fcol=4", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1 ORDER BY col"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (20, 3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE col=20"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3})});
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MINOR, tableName, hivePartitionString, Duration.valueOf((String)"6m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " WHERE fcol=2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE col=20"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3})});
            String predicate = "fcol = 1" + (isPartitioned ? " AND part_col = 2 " : "");
            QueryExecutors.onHive().executeQuery("UPDATE " + tableName + " SET col = 23 WHERE " + predicate, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE col=20"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3})});
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MAJOR, tableName, hivePartitionString, Duration.valueOf((String)"6m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
        }
    }

    @Test(groups={"hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    @Flaky(issue="https://github.com/trinodb/trino/issues/4927", match="Hive table .* is corrupt. Found sub-directory in bucket directory for partition")
    public void testReadInsertOnly(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName("insert_only", isPartitioned, bucketingType));){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("col", 4) + " STORED AS ORC " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.INSERT_ONLY, bucketingType), new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            String predicate = isPartitioned ? " WHERE part_col = 2 " : "";
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " SELECT 1", new QueryExecutor.QueryParam[0]);
            String selectFromOnePartitionsSql = "SELECT col FROM " + tableName + predicate + " ORDER BY COL";
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " SELECT 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + " WHERE col=2"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MINOR, tableName, hivePartitionString, Duration.valueOf((String)"6m"));
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + " WHERE col=2"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryExecutors.onHive().executeQuery("INSERT OVERWRITE TABLE " + tableName + hivePartitionString + " SELECT 3", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
            if (this.getHiveVersionMajor() >= 4) {
                QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " SELECT 4", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MAJOR, tableName, hivePartitionString, Duration.valueOf((String)"6m"));
                QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3}), QueryAssert.Row.row((Object[])new Object[]{4})});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    @Flaky(issue="https://github.com/trinodb/trino/issues/4927", match="Hive table .* is corrupt. Found sub-directory in bucket directory for partition")
    public void testReadFullAcidWithOriginalFiles(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Trino Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_full_acid_acid_converted_table_read";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
        try {
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (21, 1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (22, 2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (20, 3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " WHERE fcol = 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            QueryExecutors.onHive().executeQuery("UPDATE " + tableName + " SET col = 23 WHERE fcol = 1" + (isPartitioned ? " AND part_col = 2 " : ""), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{23, 1})});
        }
        finally {
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    public void testUpdateFullAcidWithOriginalFilesPrestoInserting(boolean isPartitioned, BucketingType bucketingType) {
        this.withTemporaryTable("trino_update_full_acid_acid_converted_table_read", true, isPartitioned, bucketingType, tableName -> {
            QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
            Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (21, 1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (22, 2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol = 1"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{21, 1})});
            if (isPartitioned) {
                QueryExecutor.query((String)("INSERT INTO " + tableName + "(col, fcol, part_col) VALUES (20, 4, 2)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            } else {
                QueryExecutor.query((String)("INSERT INTO " + tableName + "(col, fcol) VALUES (20, 4)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            }
            if (isPartitioned) {
                QueryExecutor.query((String)("INSERT INTO " + tableName + "(col, fcol, part_col) VALUES (20, 3, 2)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            } else {
                QueryExecutor.query((String)("INSERT INTO " + tableName + "(col, fcol) VALUES (20, 3)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            }
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{20, 4}), QueryAssert.Row.row((Object[])new Object[]{21, 1}), QueryAssert.Row.row((Object[])new Object[]{22, 2})});
            QueryExecutors.onHive().executeQuery("DELETE FROM " + tableName + " WHERE fcol = 2", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{20, 3}), QueryAssert.Row.row((Object[])new Object[]{20, 4}), QueryAssert.Row.row((Object[])new Object[]{21, 1})});
        });
    }

    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    public void testUpdateFullAcidWithOriginalFilesPrestoInsertingAndDeleting(boolean isPartitioned, BucketingType bucketingType) {
        this.withTemporaryTable("trino_update_full_acid_acid_converted_table_read", true, isPartitioned, bucketingType, tableName -> {
            QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
            Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT, fcol INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("fcol", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (10, 100), (11, 110), (12, 120), (13, 130), (14, 140)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (15, 150), (16, 160), (17, 170), (18, 180), (19, 190)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.ACID, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE col < 12"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 100}), QueryAssert.Row.row((Object[])new Object[]{11, 110})});
            String fields = isPartitioned ? "(col, fcol, part_col)" : "(col, fcol)";
            QueryExecutor.query((String)String.format("INSERT INTO %s %s VALUES %s", tableName, fields, this.makeValues(30, 5, 2, isPartitioned, 3)), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)String.format("INSERT INTO %s %s VALUES %s", tableName, fields, this.makeValues(40, 5, 2, isPartitioned, 3)), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)("DELETE FROM " + tableName + " WHERE col IN (11, 12)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)("DELETE FROM " + tableName + " WHERE col IN (16, 17)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE fcol >= 100"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 100}), QueryAssert.Row.row((Object[])new Object[]{13, 130}), QueryAssert.Row.row((Object[])new Object[]{14, 140}), QueryAssert.Row.row((Object[])new Object[]{15, 150}), QueryAssert.Row.row((Object[])new Object[]{18, 180}), QueryAssert.Row.row((Object[])new Object[]{19, 190})});
            QueryExecutor.query((String)("DELETE FROM " + tableName + " WHERE col = 18 OR col = 14 OR (fcol = 2 AND (col / 2) * 2 = col)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT col, fcol FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 100}), QueryAssert.Row.row((Object[])new Object[]{13, 130}), QueryAssert.Row.row((Object[])new Object[]{15, 150}), QueryAssert.Row.row((Object[])new Object[]{19, 190}), QueryAssert.Row.row((Object[])new Object[]{31, 2}), QueryAssert.Row.row((Object[])new Object[]{33, 2}), QueryAssert.Row.row((Object[])new Object[]{41, 2}), QueryAssert.Row.row((Object[])new Object[]{43, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{10, 100}), QueryAssert.Row.row((Object[])new Object[]{13, 130}), QueryAssert.Row.row((Object[])new Object[]{15, 150}), QueryAssert.Row.row((Object[])new Object[]{19, 190}), QueryAssert.Row.row((Object[])new Object[]{31, 2}), QueryAssert.Row.row((Object[])new Object[]{33, 2}), QueryAssert.Row.row((Object[])new Object[]{41, 2}), QueryAssert.Row.row((Object[])new Object[]{43, 2})});
        });
    }

    String makeValues(int colStart, int colCount, int fcol, boolean isPartitioned, int partCol) {
        return IntStream.range(colStart, colStart + colCount - 1).boxed().map(n -> isPartitioned ? String.format("(%s, %s, %s)", n, fcol, partCol) : String.format("(%s, %s)", n, fcol)).collect(Collectors.joining(", "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"storage_formats", "hive_transactional"}, dataProvider="partitioningAndBucketingTypeDataProvider", timeOut=900000L)
    @Flaky(issue="https://github.com/trinodb/trino/issues/4927", match="Hive table .* is corrupt. Found sub-directory in bucket directory for partition")
    public void testReadInsertOnlyWithOriginalFiles(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Trino Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_insert_only_acid_converted_table_read";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        Verify.verify((boolean)bucketingType.getHiveTableProperties().isEmpty());
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT) " + (isPartitioned ? "PARTITIONED BY (part_col INT) " : "") + bucketingType.getHiveClustering("col", 4) + " STORED AS ORC TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
        try {
            String hivePartitionString = isPartitioned ? " PARTITION (part_col=2) " : "";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (2)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("ALTER TABLE " + tableName + " SET " + TestHiveTransactionalTable.hiveTableProperties(TransactionalTableType.INSERT_ONLY, bucketingType), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + (isPartitioned ? " WHERE part_col = 2 " : " ORDER BY col")), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + hivePartitionString + " VALUES (3)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col FROM " + tableName + (isPartitioned ? " WHERE part_col = 2 " : " ORDER BY col")), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{3})});
        }
        finally {
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"hive_transactional"})
    public void testFailAcidBeforeHive3() {
        if (this.getHiveVersionMajor() >= 3) {
            throw new SkipException("This tests behavior of ACID table before Hive 3 ");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable("test_fail_acid_before_hive3_" + TemporaryHiveTable.randomTableSuffix());){
            String tableName = table.getName();
            QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + "(a bigint) CLUSTERED BY(a) INTO 4 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage("Failed to open transaction. Transactional tables support requires Hive metastore version at least 3.0");
        }
    }

    @DataProvider
    public Object[][] partitioningAndBucketingTypeDataProvider() {
        return new Object[][]{{false, BucketingType.NONE}, {false, BucketingType.BUCKETED_DEFAULT}, {true, BucketingType.NONE}, {true, BucketingType.BUCKETED_DEFAULT}};
    }

    @Test(groups={"hive_transactional"}, dataProvider="testCreateAcidTableDataProvider")
    public void testCtasAcidTable(boolean isPartitioned, BucketingType bucketingType) {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(String.format("ctas_transactional_%s", TemporaryHiveTable.randomTableSuffix()));){
            String tableName = table.getName();
            QueryExecutor.query((String)("CREATE TABLE " + tableName + " " + TestHiveTransactionalTable.prestoTableProperties(TransactionalTableType.ACID, isPartitioned, bucketingType) + " AS SELECT * FROM (VALUES (21, 1, 1), (22, 1, 2), (23, 2, 2)) t(col, fcol, partcol)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT col, fcol FROM " + tableName + " WHERE partcol = 2 ORDER BY col"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{22, 1}), QueryAssert.Row.row((Object[])new Object[]{23, 2})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT col, fcol FROM " + tableName + " WHERE partcol = 2 ORDER BY col", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{22, 1}), QueryAssert.Row.row((Object[])new Object[]{23, 2})});
        }
    }

    @Test(groups={"hive_transactional"}, dataProvider="testCreateAcidTableDataProvider")
    public void testCreateAcidTable(boolean isPartitioned, BucketingType bucketingType) {
        this.withTemporaryTable("create_transactional", true, isPartitioned, bucketingType, tableName -> {
            QueryExecutor.query((String)("CREATE TABLE " + tableName + " (col INTEGER, fcol INTEGER, partcol INTEGER)" + TestHiveTransactionalTable.prestoTableProperties(TransactionalTableType.ACID, isPartitioned, bucketingType)), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (1, 2, 3)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 2, 3})});
        });
    }

    @Test(groups={"hive_transactional"})
    public void testSimpleUnpartitionedTransactionalInsert() {
        this.withTemporaryTable("unpartitioned_transactional_insert", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (11, 100), (12, 200), (13, 300)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{11, 100L}), QueryAssert.Row.row((Object[])new Object[]{12, 200L}), QueryAssert.Row.row((Object[])new Object[]{13, 300L}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (14, 400), (15, 500), (16, 600)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{11, 100L}), QueryAssert.Row.row((Object[])new Object[]{12, 200L}), QueryAssert.Row.row((Object[])new Object[]{13, 300L}), QueryAssert.Row.row((Object[])new Object[]{14, 400L}), QueryAssert.Row.row((Object[])new Object[]{15, 500L}), QueryAssert.Row.row((Object[])new Object[]{16, 600L}));
        });
    }

    @Test(groups={"hive_transactional"})
    public void testTransactionalPartitionInsert() {
        this.withTemporaryTable("transactional_partition_insert", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true, partitioned_by = ARRAY['column2'])", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (column2, column1) VALUES %s, %s", tableName, this.makeInsertValues(1, 1, 20), this.makeInsertValues(2, 1, 20)), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT COUNT(*) FROM %s", tableName), "column1 > 10", QueryAssert.Row.row((Object[])new Object[]{20}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (column2, column1) VALUES %s, %s", tableName, this.makeInsertValues(1, 21, 30), this.makeInsertValues(2, 21, 30)), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT COUNT(*) FROM %s", tableName), "column1 > 15 AND column1 <= 25", QueryAssert.Row.row((Object[])new Object[]{20}));
            QueryExecutors.onHive().executeQuery(String.format("DELETE FROM %s WHERE column1 > 15 AND column1 <= 25", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT COUNT(*) FROM %s", tableName), "column1 > 15 AND column1 <= 25", QueryAssert.Row.row((Object[])new Object[]{0}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (column2, column1) VALUES %s, %s", tableName, this.makeInsertValues(1, 20, 23), this.makeInsertValues(2, 20, 23)), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT COUNT(*) FROM %s", tableName), "column1 > 15 AND column1 <= 25", QueryAssert.Row.row((Object[])new Object[]{8}));
        });
    }

    @Test(groups={"hive_transactional"})
    public void testTransactionalBucketedPartitionedInsert() {
        this.testTransactionalBucketedPartitioned(false);
    }

    @Test(groups={"hive_transactional"})
    public void testTransactionalBucketedPartitionedInsertOnly() {
        this.testTransactionalBucketedPartitioned(true);
    }

    private void testTransactionalBucketedPartitioned(boolean insertOnly) {
        this.withTemporaryTable("bucketed_partitioned_insert_only", true, true, BucketingType.BUCKETED_V2, tableName -> {
            String insertOnlyProperty = insertOnly ? ", 'transactional_properties'='insert_only'" : "";
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (purchase STRING) PARTITIONED BY (customer STRING) CLUSTERED BY (purchase) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional' = 'true'%s)", tableName, insertOnlyProperty), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Fred', 'cards'), ('Fred', 'cereal'), ('Fred', 'limes'), ('Fred', 'chips'), ('Ann', 'cards'), ('Ann', 'cereal'), ('Ann', 'lemons'), ('Ann', 'chips'), ('Lou', 'cards'), ('Lou', 'cereal'), ('Lou', 'lemons'), ('Lou', 'chips')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT customer FROM %s", tableName), "purchase = 'lemons'", QueryAssert.Row.row((Object[])new Object[]{"Ann"}), QueryAssert.Row.row((Object[])new Object[]{"Lou"}));
            this.verifySelectForPrestoAndHive(String.format("SELECT purchase FROM %s", tableName), "customer = 'Fred'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"limes"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Ernie', 'cards'), ('Ernie', 'cereal'), ('Debby', 'corn'), ('Debby', 'chips'), ('Joe', 'corn'), ('Joe', 'lemons'), ('Joe', 'candy')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT customer FROM %s", tableName), "purchase = 'corn'", QueryAssert.Row.row((Object[])new Object[]{"Debby"}), QueryAssert.Row.row((Object[])new Object[]{"Joe"}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testTransactionalUnpartitionedDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("unpartitioned_delete", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INTEGER, column2 BIGINT) WITH (format = 'ORC', transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column1, column2) VALUES (1, 100), (2, 200), (3, 300), (4, 400), (5, 500)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column2 = 100", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{2, 200}), QueryAssert.Row.row((Object[])new Object[]{3, 300}), QueryAssert.Row.row((Object[])new Object[]{4, 400}), QueryAssert.Row.row((Object[])new Object[]{5, 500}));
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (6, 600), (7, 700)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column1 = 4", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{2, 200}), QueryAssert.Row.row((Object[])new Object[]{3, 300}), QueryAssert.Row.row((Object[])new Object[]{5, 500}), QueryAssert.Row.row((Object[])new Object[]{6, 600}), QueryAssert.Row.row((Object[])new Object[]{7, 700}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column1 <= 3 OR column1 = 6", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{5, 500}), QueryAssert.Row.row((Object[])new Object[]{7, 700}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testMultiDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("unpartitioned_multi_delete", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (1, 100), (2, 200), (3, 300), (4, 400), (5, 500)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (6, 600), (7, 700), (8, 800), (9, 900), (10, 1000)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column1 = 9", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column1 = 2 OR column1 = 3", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100}), QueryAssert.Row.row((Object[])new Object[]{4, 400}), QueryAssert.Row.row((Object[])new Object[]{5, 500}), QueryAssert.Row.row((Object[])new Object[]{6, 600}), QueryAssert.Row.row((Object[])new Object[]{7, 700}), QueryAssert.Row.row((Object[])new Object[]{8, 800}), QueryAssert.Row.row((Object[])new Object[]{10, 1000}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testTransactionalMetadataDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("metadata_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true, partitioned_by = ARRAY['column2'])", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column2, column1) VALUES %s, %s", tableName, this.makeInsertValues(1, 1, 20), this.makeInsertValues(2, 1, 20)), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column2 = 1", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "column2 = 1", QueryAssert.Row.row((Object[])new Object[]{0}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testNonTransactionalMetadataDelete() {
        this.withTemporaryTable("non_transactional_metadata_delete", false, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column2 BIGINT, column1 INT) WITH (partitioned_by = ARRAY['column1'])", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(HiveOrPresto.PRESTO, String.format("INSERT INTO %s (column1, column2) VALUES %s, %s", tableName, this.makeInsertValues(1, 1, 10), this.makeInsertValues(2, 1, 10)), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(HiveOrPresto.PRESTO, String.format("INSERT INTO %s (column1, column2) VALUES %s, %s", tableName, this.makeInsertValues(1, 11, 20), this.makeInsertValues(2, 11, 20)), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(HiveOrPresto.PRESTO, String.format("DELETE FROM %s WHERE column1 = 1", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "column1 = 1", QueryAssert.Row.row((Object[])new Object[]{0}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testUnpartitionedDeleteAll(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("unpartitioned_delete_all", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (1, 100), (2, 200), (3, 300), (4, 400), (5, 500)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, "DELETE FROM " + tableName, new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{0}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testMultiColumnDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("multi_column_delete", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (1, 100), (2, 200), (3, 300), (4, 400), (5, 500)", tableName), new QueryExecutor.QueryParam[0]);
            String where = " WHERE column1 >= 2 AND column2 <= 400";
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s %s", tableName, where), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "column1 IN (1, 5)", QueryAssert.Row.row((Object[])new Object[]{1, 100}), QueryAssert.Row.row((Object[])new Object[]{5, 500}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testPartitionAndRowsDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("partition_and_rows_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery("CREATE TABLE " + tableName + " (column2 BIGINT, column1 INT) WITH (transactional = true, partitioned_by = ARRAY['column1'])", new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column1, column2) VALUES (1, 100), (1, 200), (2, 300), (2, 400), (2, 500)", tableName), new QueryExecutor.QueryParam[0]);
            String where = " WHERE column1 = 2 OR column2 = 200";
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s %s", tableName, where), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT column1, column2 FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testPartitionedInsertAndRowLevelDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("partitioned_row_level_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column2 INT, column1 BIGINT) WITH (transactional = true, partitioned_by = ARRAY['column1'])", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column1, column2) VALUES %s, %s", tableName, this.makeInsertValues(1, 1, 20), this.makeInsertValues(2, 1, 20)), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (column1, column2) VALUES %s, %s", tableName, this.makeInsertValues(1, 21, 40), this.makeInsertValues(2, 21, 40)), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "column2 > 10 AND column2 <= 30", QueryAssert.Row.row((Object[])new Object[]{40}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE column2 > 10 AND column2 <= 30", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "column2 > 10 AND column2 <= 30", QueryAssert.Row.row((Object[])new Object[]{0}));
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{40}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testBucketedPartitionedDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("bucketed_partitioned_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (purchase STRING) PARTITIONED BY (customer STRING) CLUSTERED BY (purchase) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional' = 'true')", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Fred', 'cards'), ('Fred', 'cereal'), ('Fred', 'limes'), ('Fred', 'chips'), ('Ann', 'cards'), ('Ann', 'cereal'), ('Ann', 'lemons'), ('Ann', 'chips'), ('Lou', 'cards'), ('Lou', 'cereal'), ('Lou', 'lemons'), ('Lou', 'chips')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT customer FROM %s", tableName), "purchase = 'lemons'", QueryAssert.Row.row((Object[])new Object[]{"Ann"}), QueryAssert.Row.row((Object[])new Object[]{"Lou"}));
            this.verifySelectForPrestoAndHive(String.format("SELECT purchase FROM %s", tableName), "customer = 'Fred'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"limes"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Ernie', 'cards'), ('Ernie', 'cereal'), ('Debby', 'corn'), ('Debby', 'chips'), ('Joe', 'corn'), ('Joe', 'lemons'), ('Joe', 'candy')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT customer FROM " + tableName, "purchase = 'corn'", QueryAssert.Row.row((Object[])new Object[]{"Debby"}), QueryAssert.Row.row((Object[])new Object[]{"Joe"}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE purchase = 'lemons'", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT purchase FROM " + tableName, "customer = 'Ann'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE purchase like('c%%')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT customer, purchase FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{"Fred", "limes"}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testDeleteAllRowsInPartition() {
        this.withTemporaryTable("bucketed_partitioned_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (purchase STRING) PARTITIONED BY (customer STRING) STORED AS ORC TBLPROPERTIES ('transactional' = 'true')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES ('Fred', 'cards'), ('Fred', 'cereal'), ('Ann', 'lemons'), ('Ann', 'chips')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to delete");
            QueryExecutors.onPresto().executeQuery(String.format("DELETE FROM %s WHERE customer = 'Fred'", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to verify");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"lemons", "Ann"}), QueryAssert.Row.row((Object[])new Object[]{"chips", "Ann"}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testBucketedUnpartitionedDelete(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("bucketed_unpartitioned_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (customer STRING, purchase STRING) CLUSTERED BY (purchase) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional' = 'true')", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Fred', 'cards'), ('Fred', 'cereal'), ('Fred', 'limes'), ('Fred', 'chips'), ('Ann', 'cards'), ('Ann', 'cereal'), ('Ann', 'lemons'), ('Ann', 'chips'), ('Lou', 'cards'), ('Lou', 'cereal'), ('Lou', 'lemons'), ('Lou', 'chips')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive(String.format("SELECT customer FROM %s", tableName), "purchase = 'lemons'", QueryAssert.Row.row((Object[])new Object[]{"Ann"}), QueryAssert.Row.row((Object[])new Object[]{"Lou"}));
            this.verifySelectForPrestoAndHive(String.format("SELECT purchase FROM %s", tableName), "customer = 'Fred'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"limes"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s (customer, purchase) VALUES", tableName) + " ('Ernie', 'cards'), ('Ernie', 'cereal'), ('Debby', 'corn'), ('Debby', 'chips'), ('Joe', 'corn'), ('Joe', 'lemons'), ('Joe', 'candy')", new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT customer FROM " + tableName, "purchase = 'corn'", QueryAssert.Row.row((Object[])new Object[]{"Debby"}), QueryAssert.Row.row((Object[])new Object[]{"Joe"}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE purchase = 'lemons'", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT purchase FROM " + tableName, "customer = 'Ann'", QueryAssert.Row.row((Object[])new Object[]{"cards"}), QueryAssert.Row.row((Object[])new Object[]{"cereal"}), QueryAssert.Row.row((Object[])new Object[]{"chips"}));
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE purchase like('c%%')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT customer, purchase FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{"Fred", "limes"}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="inserterAndDeleterProvider", timeOut=900000L)
    public void testCorrectSelectCountStar(HiveOrPresto inserter, HiveOrPresto deleter) {
        this.withTemporaryTable("select_count_star_delete", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (col1 INT, col2 BIGINT) PARTITIONED BY (col3 STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter, String.format("INSERT INTO %s VALUES (1, 100, 'a'), (2, 200, 'b'), (3, 300, 'c'), (4, 400, 'a'), (5, 500, 'b'), (6, 600, 'c')", tableName), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(deleter, String.format("DELETE FROM %s WHERE col2 = 200", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT COUNT(*) FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{5}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="insertersProvider", timeOut=900000L)
    public void testInsertOnlyMultipleWriters(boolean bucketed, HiveOrPresto inserter1, HiveOrPresto inserter2) {
        log.info("testInsertOnlyMultipleWriters bucketed %s, inserter1 %s, inserter2 %s", new Object[]{bucketed, inserter1, inserter2});
        this.withTemporaryTable("insert_only_partitioned", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (col1 INT, col2 BIGINT) PARTITIONED BY (col3 STRING) %s STORED AS ORC TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')", tableName, bucketed ? "CLUSTERED BY (col2) INTO 3 BUCKETS" : ""), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.execute(inserter1, String.format("INSERT INTO %s VALUES (1, 100, 'a'), (2, 200, 'b')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100, "a"}), QueryAssert.Row.row((Object[])new Object[]{2, 200, "b"}));
            TestHiveTransactionalTable.execute(inserter2, String.format("INSERT INTO %s VALUES (3, 300, 'c'), (4, 400, 'a')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100, "a"}), QueryAssert.Row.row((Object[])new Object[]{2, 200, "b"}), QueryAssert.Row.row((Object[])new Object[]{3, 300, "c"}), QueryAssert.Row.row((Object[])new Object[]{4, 400, "a"}));
            TestHiveTransactionalTable.execute(inserter1, String.format("INSERT INTO %s VALUES (5, 500, 'b'), (6, 600, 'c')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100, "a"}), QueryAssert.Row.row((Object[])new Object[]{2, 200, "b"}), QueryAssert.Row.row((Object[])new Object[]{3, 300, "c"}), QueryAssert.Row.row((Object[])new Object[]{4, 400, "a"}), QueryAssert.Row.row((Object[])new Object[]{5, 500, "b"}), QueryAssert.Row.row((Object[])new Object[]{6, 600, "c"}));
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "col2 > 300", QueryAssert.Row.row((Object[])new Object[]{4, 400, "a"}), QueryAssert.Row.row((Object[])new Object[]{5, 500, "b"}), QueryAssert.Row.row((Object[])new Object[]{6, 600, "c"}));
            TestHiveTransactionalTable.execute(inserter2, String.format("INSERT INTO %s VALUES (7, 700, 'b'), (8, 800, 'c')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 100, "a"}), QueryAssert.Row.row((Object[])new Object[]{2, 200, "b"}), QueryAssert.Row.row((Object[])new Object[]{3, 300, "c"}), QueryAssert.Row.row((Object[])new Object[]{4, 400, "a"}), QueryAssert.Row.row((Object[])new Object[]{5, 500, "b"}), QueryAssert.Row.row((Object[])new Object[]{6, 600, "c"}), QueryAssert.Row.row((Object[])new Object[]{7, 700, "b"}), QueryAssert.Row.row((Object[])new Object[]{8, 800, "c"}));
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "col3 = 'c'", QueryAssert.Row.row((Object[])new Object[]{3, 300, "c"}), QueryAssert.Row.row((Object[])new Object[]{6, 600, "c"}), QueryAssert.Row.row((Object[])new Object[]{8, 800, "c"}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="transactionModeProvider")
    public void testColumnRenamesOrcPartitioned(boolean transactional) {
        this.ensureSchemaEvolutionSupported();
        this.withTemporaryTable("test_column_renames_partitioned", transactional, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (id BIGINT, old_name VARCHAR, age INT, old_state VARCHAR) WITH (format = 'ORC', transactional = %s, partitioned_by = ARRAY['old_state'])", tableName, transactional), new QueryExecutor.QueryParam[0]);
            this.testOrcColumnRenames((String)tableName);
            log.info("About to rename partition column old_state to new_state");
            QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN old_state TO new_state", tableName), new QueryExecutor.QueryParam[0])).failsWithMessage("Renaming partition columns is not supported");
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="transactionModeProvider")
    public void testColumnRenamesOrcNotPartitioned(boolean transactional) {
        this.ensureSchemaEvolutionSupported();
        this.withTemporaryTable("test_orc_column_renames_not_partitioned", transactional, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (id BIGINT, old_name VARCHAR, age INT, old_state VARCHAR) WITH (format = 'ORC', transactional = %s)", tableName, transactional), new QueryExecutor.QueryParam[0]);
            this.testOrcColumnRenames((String)tableName);
        });
    }

    private void testOrcColumnRenames(String tableName) {
        QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (111, 'Katy', 57, 'CA'), (222, 'Joe', 72, 'WA')", tableName), new QueryExecutor.QueryParam[0]);
        this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}));
        QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN old_name TO new_name", tableName), new QueryExecutor.QueryParam[0]);
        log.info("This shows that Presto and Hive can still query old data after a single rename");
        this.verifySelectForPrestoAndHive("SELECT age FROM " + tableName, "new_name = 'Katy'", QueryAssert.Row.row((Object[])new Object[]{57}));
        QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES(333, 'Joan', 23, 'OR')", tableName), new QueryExecutor.QueryParam[0]);
        this.verifySelectForPrestoAndHive("SELECT age FROM " + tableName, "new_name != 'Joe'", QueryAssert.Row.row((Object[])new Object[]{57}), QueryAssert.Row.row((Object[])new Object[]{23}));
        QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN new_name TO newer_name", tableName), new QueryExecutor.QueryParam[0]);
        log.info("This shows that Presto and Hive can still query old data after a double rename");
        this.verifySelectForPrestoAndHive("SELECT age FROM " + tableName, "newer_name = 'Katy'", QueryAssert.Row.row((Object[])new Object[]{57}));
        QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN newer_name TO old_name", tableName), new QueryExecutor.QueryParam[0]);
        log.info("This shows that Presto and Hive can still query old data after a rename back to the original name");
        this.verifySelectForPrestoAndHive("SELECT age FROM " + tableName, "old_name = 'Katy'", QueryAssert.Row.row((Object[])new Object[]{57}));
        this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}), QueryAssert.Row.row((Object[])new Object[]{333, "Joan", 23, "OR"}));
    }

    @Test(groups={"hive_transactional"}, dataProvider="transactionModeProvider")
    public void testOrcColumnSwap(boolean transactional) {
        this.ensureSchemaEvolutionSupported();
        this.withTemporaryTable("test_orc_column_renames", transactional, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (name VARCHAR, state VARCHAR) WITH (format = 'ORC', transactional = %s)", tableName, transactional), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES ('Katy', 'CA'), ('Joe', 'WA')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{"Katy", "CA"}), QueryAssert.Row.row((Object[])new Object[]{"Joe", "WA"}));
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN name TO new_name", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN state TO name", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN new_name TO state", tableName), new QueryExecutor.QueryParam[0]);
            log.info("This shows that Presto and Hive can still query old data, but because of the renames, columns are swapped!");
            this.verifySelectForPrestoAndHive("SELECT state, name FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Katy", "CA"}), QueryAssert.Row.row((Object[])new Object[]{"Joe", "WA"}));
        });
    }

    @Test(groups={"hive_transactional"})
    public void testBehaviorOnParquetColumnRenames() {
        this.ensureSchemaEvolutionSupported();
        this.withTemporaryTable("test_parquet_column_renames", false, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (id BIGINT, old_name VARCHAR, age INT, old_state VARCHAR) WITH (format = 'PARQUET', transactional = false)", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (111, 'Katy', 57, 'CA'), (222, 'Joe', 72, 'WA')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}));
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN old_name TO new_name", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (333, 'Fineas', 31, 'OR')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("This shows that Hive and Trino do not see old data after a rename");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{111, null, 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, null, 72, "WA"}), QueryAssert.Row.row((Object[])new Object[]{333, "Fineas", 31, "OR"}));
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN new_name TO old_name", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (444, 'Gladys', 47, 'WA')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("This shows that Presto and Hive both see data in old data files after renaming back to the original column name");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}), QueryAssert.Row.row((Object[])new Object[]{333, null, 31, "OR"}), QueryAssert.Row.row((Object[])new Object[]{444, "Gladys", 47, "WA"}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="transactionModeProvider")
    public void testOrcColumnDropAdd(boolean transactional) {
        this.ensureSchemaEvolutionSupported();
        this.withTemporaryTable("test_orc_add_drop", transactional, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (id BIGINT, old_name VARCHAR, age INT, old_state VARCHAR) WITH (transactional = %s)", tableName, transactional), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (111, 'Katy', 57, 'CA'), (222, 'Joe', 72, 'WA')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}));
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s DROP COLUMN old_state", tableName), new QueryExecutor.QueryParam[0]);
            log.info("This shows that neither Presto nor Hive see the old data after a column is dropped");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (333, 'Kelly', 45)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72}), QueryAssert.Row.row((Object[])new Object[]{333, "Kelly", 45}));
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s ADD COLUMN new_state VARCHAR", tableName), new QueryExecutor.QueryParam[0]);
            log.info("This shows that for ORC, Presto and Hive both see data inserted into a dropped column when a column of the same type but different name is added");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}), QueryAssert.Row.row((Object[])new Object[]{333, "Kelly", 45, null}));
        });
    }

    @Test(groups={"hive_transactional"}, dataProvider="transactionModeProvider")
    public void testOrcColumnTypeChange(boolean transactional) {
        this.ensureSchemaEvolutionSupported();
        this.withTemporaryTable("test_orc_column_type_change", transactional, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (id INT, old_name VARCHAR, age TINYINT, old_state VARCHAR) WITH (transactional = %s)", tableName, transactional), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (111, 'Katy', 57, 'CA'), (222, 'Joe', 72, 'WA')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}));
            QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s CHANGE COLUMN age age INT", tableName), new QueryExecutor.QueryParam[0]);
            log.info("This shows that Hive see the old data after a column is widened");
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"})});
            log.info("This shows that Trino gets an exception trying to widen the type");
            QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).failsWithMessageMatching(".*Malformed ORC file. Cannot read SQL type 'integer' from ORC stream '.*.age' of type BYTE with attributes.*");
        });
    }

    @Test(groups={"hive_transactional"})
    public void testParquetColumnDropAdd() {
        this.ensureSchemaEvolutionSupported();
        this.withTemporaryTable("test_parquet_add_drop", false, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (id BIGINT, old_name VARCHAR, age INT, state VARCHAR) WITH (format = 'PARQUET')", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (111, 'Katy', 57, 'CA'), (222, 'Joe', 72, 'WA')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}));
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s DROP COLUMN state", tableName), new QueryExecutor.QueryParam[0]);
            log.info("This shows that neither Presto nor Hive see the old data after a column is dropped");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (333, 'Kelly', 45)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72}), QueryAssert.Row.row((Object[])new Object[]{333, "Kelly", 45}));
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s ADD COLUMN state VARCHAR", tableName), new QueryExecutor.QueryParam[0]);
            log.info("This shows that for Parquet, Presto and Hive both see data inserted into a dropped column when a column of the same name and type is added");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, "CA"}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, "WA"}), QueryAssert.Row.row((Object[])new Object[]{333, "Kelly", 45, null}));
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s DROP COLUMN state", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("ALTER TABLE %s ADD COLUMN new_state VARCHAR", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{111, "Katy", 57, null}), QueryAssert.Row.row((Object[])new Object[]{222, "Joe", 72, null}), QueryAssert.Row.row((Object[])new Object[]{333, "Kelly", 45, null}));
        });
    }

    @DataProvider
    public Object[][] transactionModeProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateFailNonTransactional() {
        this.withTemporaryTable("update_fail_nontransactional", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES ('Fred', 'cards')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to fail update");
            QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET purchase = 'bread' WHERE customer = 'Fred'", tableName), new QueryExecutor.QueryParam[0])).failsWithMessage("Hive update is only supported for transactional tables");
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateFailUpdatePartitionKey() {
        this.withTemporaryTable("fail_update_partition_key", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 INT, col2 VARCHAR, col3 BIGINT) WITH (transactional = true, partitioned_by = ARRAY['col3'])", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3) VALUES (17, 'S1', 7)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to fail update");
            QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col3 = 17 WHERE col3 = 7", tableName), new QueryExecutor.QueryParam[0])).failsWithMessage("Updating Hive table partition columns is not supported");
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateFailUpdateBucketColumn() {
        this.withTemporaryTable("fail_update_bucket_column", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (customer STRING, purchase STRING) CLUSTERED BY (purchase) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional' = 'true')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES ('Fred', 'cards')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to fail update");
            QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET purchase = 'bread' WHERE customer = 'Fred'", tableName), new QueryExecutor.QueryParam[0])).failsWithMessage("Updating Hive table bucket columns is not supported");
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateFailOnIllegalCast() {
        this.withTemporaryTable("fail_update_on_illegal_cast", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 INT, col2 VARCHAR, col3 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3) VALUES (17, 'S1', 7)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to fail update");
            QueryAssert.assertThat(() -> QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col1 = col2 WHERE col3 = 7", tableName), new QueryExecutor.QueryParam[0])).failsWithMessage("UPDATE table column types don't match SET expressions: Table: [integer], Expressions: [varchar]");
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateSimple() {
        this.withTemporaryTable("acid_update_simple", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 VARCHAR, col3 BIGINT, col4 BOOLEAN, col5 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (7, 'ONE', 1000, true, 101), (13, 'TWO', 2000, false, 202)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col2 = 'DEUX', col3 = col3 + 20 + col1 + col5 WHERE col1 = 13", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{7, "ONE", 1000, true, 101}), QueryAssert.Row.row((Object[])new Object[]{13, "DEUX", 2235, false, 202}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateSelectedValues() {
        this.withTemporaryTable("acid_update_simple", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 VARCHAR, col3 BIGINT, col4 BOOLEAN, col5 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (7, 'ONE', 1000, true, 101), (13, 'TWO', 2000, false, 202)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to update %s", new Object[]{tableName});
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col2 = 'DEUX', col3 = col3 + 20 + col1 + col5 WHERE col1 = 13", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{7, "ONE", 1000, true, 101}), QueryAssert.Row.row((Object[])new Object[]{13, "DEUX", 2235, false, 202}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateCopyColumn() {
        this.withTemporaryTable("acid_update_copy_column", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 int, col2 int, col3 VARCHAR) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3) VALUES (7, 15, 'ONE'), (13, 17, 'DEUX')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col1 = col2 WHERE col1 = 13", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{7, 15, "ONE"}), QueryAssert.Row.row((Object[])new Object[]{17, 17, "DEUX"}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateSomeLiteralNullColumnValues() {
        this.withTemporaryTable("update_some_literal_null_columns", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 VARCHAR, col3 BIGINT, col4 BOOLEAN, col5 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (1, 'ONE', 1000, true, 101), (2, 'TWO', 2000, false, 202)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to run first update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col2 = NULL, col3 = NULL WHERE col1 = 2", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished first update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, "ONE", 1000, true, 101}), QueryAssert.Row.row((Object[])new Object[]{2, null, null, false, 202}));
            log.info("About to run second update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col1 = NULL, col2 = NULL, col3 = NULL, col4 = NULL WHERE col1 = 1", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished first update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 101}), QueryAssert.Row.row((Object[])new Object[]{2, null, null, false, 202}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateSomeComputedNullColumnValues() {
        this.withTemporaryTable("update_some_computed_null_columns", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 VARCHAR, col3 BIGINT, col4 BOOLEAN, col5 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (1, 'ONE', 1000, true, 101), (2, 'TWO', 2000, false, 202)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to run first update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col2 = IF(RAND()<0, NULL), col3 = IF(RAND()<0, NULL) WHERE col1 = 2", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished first update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, "ONE", 1000, true, 101}), QueryAssert.Row.row((Object[])new Object[]{2, null, null, false, 202}));
            log.info("About to run second update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col1 = IF(RAND()<0, NULL), col2 = IF(RAND()<0, NULL), col3 = IF(RAND()<0, NULL), col4 = IF(RAND()<0, NULL) WHERE col1 = 1", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished first update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 101}), QueryAssert.Row.row((Object[])new Object[]{2, null, null, false, 202}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateAllLiteralNullColumnValues() {
        this.withTemporaryTable("update_all_literal_null_columns", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 VARCHAR, col3 BIGINT, col4 BOOLEAN, col5 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (1, 'ONE', 1000, true, 101), (2, 'TWO', 2000, false, 202)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col1 = NULL, col2 = NULL, col3 = NULL, col4 = NULL, col5 = null WHERE col1 = 1", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished first update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{2, "TWO", 2000, false, 202}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateAllComputedNullColumnValues() {
        this.withTemporaryTable("update_all_computed_null_columns", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 VARCHAR, col3 BIGINT, col4 BOOLEAN, col5 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (1, 'ONE', 1000, true, 101), (2, 'TWO', 2000, false, 202)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col1 = IF(RAND()<0, NULL), col2 = IF(RAND()<0, NULL), col3 = IF(RAND()<0, NULL), col4 = IF(RAND()<0, NULL), col5 = IF(RAND()<0, NULL) WHERE col1 = 1", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished first update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{2, "TWO", 2000, false, 202}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateReversed() {
        this.withTemporaryTable("update_reversed", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 VARCHAR, col3 BIGINT, col4 BOOLEAN, col5 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (1, 'ONE', 1000, true, 101), (2, 'TWO', 2000, false, 202)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col3 = col3 + 20 + col1 + col5, col1 = 3, col2 = 'DEUX' WHERE col1 = 2", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, "ONE", 1000, true, 101}), QueryAssert.Row.row((Object[])new Object[]{3, "DEUX", 2224, false, 202}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdatePermuted() {
        this.withTemporaryTable("update_permuted", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 VARCHAR, col3 BIGINT, col4 BOOLEAN, col5 INT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (1, 'ONE', 1000, true, 101), (2, 'TWO', 2000, false, 202)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col5 = 303, col1 = 3, col3 = col3 + 20 + col1 + col5, col4 = true, col2 = 'DUO' WHERE col1 = 2", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, "ONE", 1000, true, 101}), QueryAssert.Row.row((Object[])new Object[]{3, "DUO", 2224, true, 303}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateAllColumnsSetAndDependencies() {
        this.withTemporaryTable("update_all_columns_set", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 INT, col3 BIGINT, col4 INT, col5 TINYINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (1, 2, 3, 4, 5), (21, 22, 23, 24, 25)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col5 = col4, col1 = col3, col3 = col2, col4 = col5, col2 = col1 WHERE col1 = 21", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Finished update");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4, 5}), QueryAssert.Row.row((Object[])new Object[]{23, 21, 22, 25, 24}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdatePartitioned() {
        this.withTemporaryTable("update_partitioned", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 INT, col2 VARCHAR, col3 BIGINT) WITH (transactional = true, partitioned_by = ARRAY['col3'])", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3) VALUES (13, 'T1', 3), (23, 'T2', 3), (17, 'S1', 7)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{13, "T1", 3}), QueryAssert.Row.row((Object[])new Object[]{23, "T2", 3}), QueryAssert.Row.row((Object[])new Object[]{17, "S1", 7}));
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col1 = col1 + 1 WHERE col3 = 3 AND col1 > 15", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{13, "T1", 3}), QueryAssert.Row.row((Object[])new Object[]{24, "T2", 3}), QueryAssert.Row.row((Object[])new Object[]{18, "S1", 7}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateBucketed() {
        this.withTemporaryTable("update_bucketed", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (customer STRING, purchase STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional' = 'true')", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to insert");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES ('Fred', 'cards'), ('Fred', 'limes'), ('Ann', 'lemons')", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Fred", "cards"}), QueryAssert.Row.row((Object[])new Object[]{"Fred", "limes"}), QueryAssert.Row.row((Object[])new Object[]{"Ann", "lemons"}));
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET purchase = 'bread' WHERE customer = 'Ann'", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Fred", "cards"}), QueryAssert.Row.row((Object[])new Object[]{"Fred", "limes"}), QueryAssert.Row.row((Object[])new Object[]{"Ann", "bread"}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testAcidUpdateMajorCompaction() {
        this.withTemporaryTable("schema_evolution_column_addition", true, false, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (column1 INT, column2 BIGINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (11, 100)", tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (22, 200)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{11, 100L}), QueryAssert.Row.row((Object[])new Object[]{22, 200L}));
            log.info("About to compact");
            TestHiveTransactionalTable.compactTableAndWait(CompactionMode.MAJOR, tableName, "", Duration.valueOf((String)"6m"));
            log.info("About to update");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET column1 = 33 WHERE column2 = 200", tableName), new QueryExecutor.QueryParam[0]);
            log.info("About to select");
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{11, 100L}), QueryAssert.Row.row((Object[])new Object[]{33, 200L}));
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES (44, 400), (55, 500)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{11, 100L}), QueryAssert.Row.row((Object[])new Object[]{33, 200L}), QueryAssert.Row.row((Object[])new Object[]{44, 400L}), QueryAssert.Row.row((Object[])new Object[]{55, 500L}));
            QueryExecutors.onPresto().executeQuery(String.format("DELETE FROM %s WHERE column2 IN (100, 500)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{33, 200L}), QueryAssert.Row.row((Object[])new Object[]{44, 400L}));
        });
    }

    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testInsertDeletUpdateWithPrestoAndHive() {
        this.withTemporaryTable("update_insert_delete_presto_hive", true, true, BucketingType.NONE, tableName -> {
            QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 INT, col3 BIGINT, col4 INT, col5 TINYINT) WITH (transactional = true)", tableName), new QueryExecutor.QueryParam[0]);
            log.info("Performing first insert on Presto");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (1, 2, 3, 4, 5), (21, 22, 23, 24, 25)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4, 5}), QueryAssert.Row.row((Object[])new Object[]{21, 22, 23, 24, 25}));
            log.info("Performing first update on Presto");
            QueryExecutors.onPresto().executeQuery(String.format("UPDATE %s SET col5 = col4, col1 = col3, col3 = col2, col4 = col5, col2 = col1 WHERE col1 = 21", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4, 5}), QueryAssert.Row.row((Object[])new Object[]{23, 21, 22, 25, 24}));
            log.info("Performing second insert on Hive");
            QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (31, 32, 33, 34, 35)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4, 5}), QueryAssert.Row.row((Object[])new Object[]{23, 21, 22, 25, 24}), QueryAssert.Row.row((Object[])new Object[]{31, 32, 33, 34, 35}));
            log.info("Performing first delete on Presto");
            QueryExecutors.onPresto().executeQuery(String.format("DELETE FROM %s WHERE col1 = 23", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4, 5}), QueryAssert.Row.row((Object[])new Object[]{31, 32, 33, 34, 35}));
            log.info("Performing second update on Hive");
            QueryExecutors.onHive().executeQuery(String.format("UPDATE %s SET col5 = col4, col1 = col3, col3 = col2, col4 = col5, col2 = col1 WHERE col1 = 31", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "true", QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4, 5}), QueryAssert.Row.row((Object[])new Object[]{33, 31, 32, 35, 34}));
            log.info("Performing more inserts on Presto");
            QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s (col1, col2, col3, col4, col5) VALUES (41, 42, 43, 44, 45), (51, 52, 53, 54, 55)", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4, 5}), QueryAssert.Row.row((Object[])new Object[]{33, 31, 32, 35, 34}), QueryAssert.Row.row((Object[])new Object[]{41, 42, 43, 44, 45}), QueryAssert.Row.row((Object[])new Object[]{51, 52, 53, 54, 55}));
            log.info("Performing second delete on Hive");
            QueryExecutors.onHive().executeQuery(String.format("DELETE FROM %s WHERE col5 = 5", tableName), new QueryExecutor.QueryParam[0]);
            this.verifySelectForPrestoAndHive("SELECT * FROM " + tableName, "TRUE", QueryAssert.Row.row((Object[])new Object[]{33, 31, 32, 35, 34}), QueryAssert.Row.row((Object[])new Object[]{41, 42, 43, 44, 45}), QueryAssert.Row.row((Object[])new Object[]{51, 52, 53, 54, 55}));
        });
    }

    @DataProvider
    public Object[][] insertersProvider() {
        return new Object[][]{{false, HiveOrPresto.HIVE, HiveOrPresto.PRESTO}, {false, HiveOrPresto.PRESTO, HiveOrPresto.PRESTO}, {true, HiveOrPresto.HIVE, HiveOrPresto.PRESTO}, {true, HiveOrPresto.PRESTO, HiveOrPresto.PRESTO}};
    }

    private static QueryResult execute(HiveOrPresto hiveOrPresto, String sql, QueryExecutor.QueryParam ... params) {
        return TestHiveTransactionalTable.executorFor(hiveOrPresto).executeQuery(sql, params);
    }

    private static QueryExecutor executorFor(HiveOrPresto hiveOrPresto) {
        switch (hiveOrPresto) {
            case HIVE: {
                return QueryExecutors.onHive();
            }
            case PRESTO: {
                return QueryExecutors.onPresto();
            }
        }
        throw new IllegalStateException("Unknown enum value " + hiveOrPresto);
    }

    @DataProvider
    public Object[][] inserterAndDeleterProvider() {
        return new Object[][]{{HiveOrPresto.HIVE, HiveOrPresto.PRESTO}, {HiveOrPresto.PRESTO, HiveOrPresto.PRESTO}, {HiveOrPresto.PRESTO, HiveOrPresto.HIVE}};
    }

    void withTemporaryTable(String rootName, boolean transactional, boolean isPartitioned, BucketingType bucketingType, Consumer<String> testRunner) {
        if (transactional) {
            this.ensureTransactionalHive();
        }
        String tableName = null;
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName(rootName, isPartitioned, bucketingType));){
            tableName = table.getName();
            testRunner.accept(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"hive_transactional"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/5463", match="Expected row count to be <4>, but was <6>")
    public void testFilesForAbortedTransactionsIgnored() throws Exception {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
        String tableName = "test_aborted_transaction_table";
        QueryExecutors.onHive().executeQuery("CREATE TABLE " + tableName + " (col INT) STORED AS ORC TBLPROPERTIES ('transactional'='true')", new QueryExecutor.QueryParam[0]);
        ThriftHiveMetastoreClient client = this.testHiveMetastoreClientFactory.createMetastoreClient();
        try {
            String selectFromOnePartitionsSql = "SELECT col FROM " + tableName + " ORDER BY COL";
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + " VALUES (1),(2)", new QueryExecutor.QueryParam[0]);
            QueryResult onePartitionQueryResult = QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)onePartitionQueryResult).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2})});
            String tableLocation = TableLocationUtils.getTablePath(tableName);
            QueryExecutors.onHive().executeQuery("INSERT INTO TABLE " + tableName + " SELECT 3", new QueryExecutor.QueryParam[0]);
            long transaction = client.openTransaction("test");
            ((TxnToWriteId)client.allocateTableWriteIds("default", tableName, Collections.singletonList(transaction)).get(0)).getWriteId();
            client.abortTransaction(transaction);
            String deltaA = tableLocation + "/delta_0000001_0000001_0000";
            String deltaB = tableLocation + "/delta_0000002_0000002_0000";
            String deltaC = tableLocation + "/delta_0000003_0000003_0000";
            this.hdfsDeleteAll(deltaB);
            this.hdfsDeleteAll(deltaC);
            this.hdfsCopyAll(deltaA, deltaB);
            onePartitionQueryResult = QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)onePartitionQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{2})});
            this.hdfsCopyAll(deltaA, deltaC);
            onePartitionQueryResult = QueryExecutor.query((String)selectFromOnePartitionsSql, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)onePartitionQueryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{1}), QueryAssert.Row.row((Object[])new Object[]{2}), QueryAssert.Row.row((Object[])new Object[]{2})});
        }
        finally {
            client.close();
            QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    private void hdfsDeleteAll(String directory) {
        if (!this.hdfsClient.exist(directory)) {
            return;
        }
        for (String file : this.hdfsClient.listDirectory(directory)) {
            this.hdfsClient.delete(directory + "/" + file);
        }
    }

    private void hdfsCopyAll(String source, String target) {
        if (!this.hdfsClient.exist(target)) {
            this.hdfsClient.createDirectory(target);
        }
        for (String file : this.hdfsClient.listDirectory(source)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.hdfsClient.loadFile(source + "/" + file, (OutputStream)bos);
            this.hdfsClient.saveFile(target + "/" + file, (InputStream)new ByteArrayInputStream(bos.toByteArray()));
        }
    }

    @DataProvider
    public Object[][] testCreateAcidTableDataProvider() {
        return new Object[][]{{false, BucketingType.NONE}, {false, BucketingType.BUCKETED_DEFAULT}, {false, BucketingType.BUCKETED_V1}, {false, BucketingType.BUCKETED_V2}, {true, BucketingType.NONE}, {true, BucketingType.BUCKETED_DEFAULT}};
    }

    private static String hiveTableProperties(TransactionalTableType transactionalTableType, BucketingType bucketingType) {
        ImmutableList.Builder tableProperties = ImmutableList.builder();
        tableProperties.addAll(transactionalTableType.getHiveTableProperties());
        tableProperties.addAll(bucketingType.getHiveTableProperties());
        tableProperties.add((Object)"'NO_AUTO_COMPACTION'='true'");
        return tableProperties.build().stream().collect(Collectors.joining(",", "TBLPROPERTIES (", ")"));
    }

    private static String prestoTableProperties(TransactionalTableType transactionalTableType, boolean isPartitioned, BucketingType bucketingType) {
        ImmutableList.Builder tableProperties = ImmutableList.builder();
        tableProperties.addAll(transactionalTableType.getPrestoTableProperties());
        tableProperties.addAll(bucketingType.getPrestoTableProperties("fcol", 4));
        if (isPartitioned) {
            tableProperties.add((Object)"partitioned_by = ARRAY['partcol']");
        }
        return tableProperties.build().stream().collect(Collectors.joining(",", "WITH (", ")"));
    }

    private static void compactTableAndWait(CompactionMode compactMode, String tableName, String partitionString, Duration timeout) {
        log.info("Running %s compaction on %s", new Object[]{compactMode, tableName});
        Failsafe.with((Policy[])new RetryPolicy[]{new RetryPolicy().withMaxDuration(java.time.Duration.ofMillis(timeout.toMillis())).withMaxAttempts(Integer.MAX_VALUE)}).onFailure(event -> {
            throw new IllegalStateException(String.format("Could not compact table %s in %d retries", tableName, event.getAttemptCount()), event.getFailure());
        }).onSuccess(event -> log.info("Finished %s compaction on %s in %s (%d tries)", new Object[]{compactMode, tableName, event.getElapsedTime(), event.getAttemptCount()})).run(() -> TestHiveTransactionalTable.tryCompactingTable(compactMode, tableName, partitionString, Duration.valueOf((String)"2m")));
    }

    private static void tryCompactingTable(CompactionMode compactMode, String tableName, String partitionString, Duration timeout) throws TimeoutException {
        List<Map<String, String>> startedCompactions;
        Instant beforeCompactionStart = Instant.now();
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s %s COMPACT '%s'", tableName, partitionString, compactMode.name()), new QueryExecutor.QueryParam[0]).getRowsCount();
        log.info("Started compactions after %s: %s", new Object[]{beforeCompactionStart, TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.empty())});
        long loopStart = System.nanoTime();
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            startedCompactions = TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.of(beforeCompactionStart));
            Verify.verify((startedCompactions.size() < 2 ? 1 : 0) != 0, (String)"Expected at most 1 compaction", (Object[])new Object[0]);
            if (startedCompactions.isEmpty()) {
                log.info("Compaction has not started yet. Existing compactions: " + TestHiveTransactionalTable.getTableCompactions(compactMode, tableName, Optional.empty()));
                continue;
            }
            String compactionState = startedCompactions.get(0).get("state");
            if (compactionState.equals("failed")) {
                log.info("Compaction has failed: %s", new Object[]{startedCompactions.get(0)});
                throw new IllegalStateException("Compaction has failed");
            }
            if (compactionState.equals("succeeded")) {
                return;
            }
            if (Duration.nanosSince((long)loopStart).compareTo(timeout) > 0) break;
        }
        log.info("Waiting for compaction has timed out: %s", new Object[]{startedCompactions.get(0)});
        throw new TimeoutException("Compaction has timed out");
    }

    private static List<Map<String, String>> getTableCompactions(CompactionMode compactionMode, String tableName, Optional<Instant> startedAfter) {
        return (List)Stream.of(QueryExecutors.onHive().executeQuery("SHOW COMPACTIONS", new QueryExecutor.QueryParam[0])).flatMap(TestHiveTransactionalTable::mapRows).filter(row -> TestHiveTransactionalTable.isCompactionForTable(compactionMode, tableName, row)).filter(row -> {
            if (startedAfter.isPresent()) {
                try {
                    return Long.parseLong((String)row.get("start time")) >= ((Instant)startedAfter.get()).truncatedTo(ChronoUnit.SECONDS).toEpochMilli();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }).collect(ImmutableList.toImmutableList());
    }

    private static Stream<Map<String, String>> mapRows(QueryResult result) {
        if (result.getRowsCount() == 0) {
            return Stream.of(new Map[0]);
        }
        List columnNames = result.row(0).stream().filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        ImmutableList.Builder rows = ImmutableList.builder();
        for (int rowIndex = 1; rowIndex < result.getRowsCount(); ++rowIndex) {
            ImmutableMap.Builder singleRow = ImmutableMap.builder();
            List row = result.row(rowIndex);
            for (int column = 0; column < columnNames.size(); ++column) {
                String columnName = ((String)columnNames.get(column)).toLowerCase(Locale.ENGLISH);
                singleRow.put((Object)columnName, (Object)((String)row.get(column)));
            }
            rows.add((Object)singleRow.build());
        }
        return rows.build().stream();
    }

    private static String tableName(String testName, boolean isPartitioned, BucketingType bucketingType) {
        return String.format("test_%s_%b_%s_%s", testName, isPartitioned, bucketingType.name(), TemporaryHiveTable.randomTableSuffix());
    }

    private static boolean isCompactionForTable(CompactionMode compactMode, String tableName, Map<String, String> row) {
        return row.get("table").equals(tableName.toLowerCase(Locale.ENGLISH)) && row.get("type").equals(compactMode.name());
    }

    private String makeInsertValues(int col1Value, int col2First, int col2Last) {
        Preconditions.checkArgument((col2First <= col2Last ? 1 : 0) != 0, (String)"The first value %s must be less or equal to the last %s", (int)col2First, (int)col2Last);
        return IntStream.rangeClosed(col2First, col2Last).mapToObj(i -> String.format("(%s, %s)", col1Value, i)).collect(Collectors.joining(", "));
    }

    private void ensureTransactionalHive() {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
    }

    private void ensureSchemaEvolutionSupported() {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive schema evolution requires Hive version 3 or above");
        }
    }

    private void verifySelectForPrestoAndHive(String select, String whereClause, QueryAssert.Row ... rows) {
        this.verifySelect(QueryExecutors.onPresto(), select, whereClause, rows);
        this.verifySelect(QueryExecutors.onHive(), select, whereClause, rows);
    }

    private void verifySelect(QueryExecutor executor, String select, String whereClause, QueryAssert.Row ... rows) {
        String fullQuery = String.format("%s WHERE %s", select, whereClause);
        QueryAssert.assertThat((QueryResult)executor.executeQuery(fullQuery, new QueryExecutor.QueryParam[0])).containsOnly(rows);
    }

    public static enum CompactionMode {
        MAJOR,
        MINOR;

    }

    private static enum HiveOrPresto {
        HIVE,
        PRESTO;

    }
}

