/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.hive.AbstractTestHiveViews;
import io.trino.tests.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class, ImmutableTpchTablesRequirements.ImmutableOrdersTable.class})
public class TestHiveViews
extends AbstractTestHiveViews {
    @Test(groups={"hive_views"})
    public void testFailingHiveViewsForInformationSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_list_failing_views CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_list_failing_views", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_list_failing_views.correct_view AS SELECT * FROM nation limit 5", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("CREATE TABLE test_list_failing_views.table_dropped (col0 BIGINT)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_list_failing_views.failing_view AS SELECT * FROM test_list_failing_views.table_dropped", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("DROP TABLE test_list_failing_views.table_dropped", new QueryExecutor.QueryParam[0]);
        String withSchemaFilter = "SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views'";
        String withNoFilter = "SELECT table_name FROM information_schema.views";
        if (this.getHiveVersionMajor() == 3) {
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)withSchemaFilter, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)withSchemaFilter, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        } else {
            QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)withSchemaFilter, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasNoRows();
            Assertions.assertThat((List)QueryExecutor.query((String)withNoFilter, (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]).rows()).doesNotContain((Object[])new List[]{ImmutableList.of((Object)"correct_view")});
        }
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views' AND table_name = 'correct_view'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        Assertions.assertThatThrownBy(() -> QueryExecutor.query((String)"SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views' AND table_name = 'failing_view'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasMessageContaining("Failed to translate Hive view 'test_list_failing_views.failing_view'");
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)"SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = 'test_list_failing_views'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_name"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_comment"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view", "col0"})});
        Assertions.assertThatThrownBy(() -> QueryExecutor.query((String)"SELECT * FROM information_schema.columns WHERE table_schema = 'test_list_failing_views' AND table_name = 'failing_view'", (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasMessageContaining("Failed to translate Hive view 'test_list_failing_views.failing_view'");
    }
}

