/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.Requirements;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.fulfillment.table.hive.HiveTableDefinition;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.hive.AllSimpleTypesTableDefinitions;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.testng.annotations.Test;

public class TestInsertIntoHiveTable
extends ProductTest
implements RequirementsProvider {
    private static final String TABLE_NAME = "target_table";
    private static final String PARTITIONED_TABLE_WITH_SERDE = "target_partitioned_with_serde_property";

    public Requirement getRequirements(Configuration configuration) {
        return Requirements.compose((Requirement[])new Requirement[]{TableRequirements.mutableTable((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE, (String)TABLE_NAME, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED), TableRequirements.mutableTable((TableDefinition)TestInsertIntoHiveTable.partitionedTableDefinition(), (String)PARTITIONED_TABLE_WITH_SERDE, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED), TableRequirements.immutableTable((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE)});
    }

    private static TableDefinition partitionedTableDefinition() {
        String createTableDdl = "CREATE TABLE %NAME%( id int, name string ) PARTITIONED BY (dt string) ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe' WITH SERDEPROPERTIES ( 'field.delim'='\\t', 'line.delim'='\\n', 'serialization.format'='\\t' )";
        return HiveTableDefinition.builder((String)PARTITIONED_TABLE_WITH_SERDE).setCreateTableDDLTemplate(createTableDdl).setNoData().build();
    }

    @Test
    public void testInsertIntoValuesToHiveTableAllHiveSimpleTypes() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryExecutor.query((String)("INSERT INTO " + tableNameInDatabase + " VALUES(TINYINT '127', SMALLINT '32767', 2147483647, 9223372036854775807, REAL '123.345', 234.567, CAST(346 as DECIMAL(10,0)),CAST(345.67800 as DECIMAL(10,5)),timestamp '2015-05-10 12:15:35.123', date '2015-05-10', 'ala ma kota', 'ala ma kot', CAST('ala ma    ' as CHAR(10)), true, from_base64('a290IGJpbmFybnk='))"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(123.345f), 234.567, new BigDecimal("346"), new BigDecimal("345.67800"), Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)), Date.valueOf("2015-05-10"), "ala ma kota", "ala ma kot", "ala ma    ", true, "kot binarny".getBytes(StandardCharsets.UTF_8)})});
    }

    @Test
    public void testInsertIntoSelectToHiveTableAllHiveSimpleTypes() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("INSERT INTO " + tableNameInDatabase + " SELECT * from textfile_all_types"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(123.345f), 234.567, new BigDecimal("346"), new BigDecimal("345.67800"), Timestamp.valueOf(LocalDateTime.of(2015, 5, 10, 12, 15, 35, 123000000)), Date.valueOf("2015-05-10"), "ala ma kota", "ala ma kot", "ala ma    ", true, "kot binarny".getBytes(StandardCharsets.UTF_8)})});
    }

    @Test
    public void testInsertIntoPartitionedWithSerdeProperty() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(PARTITIONED_TABLE_WITH_SERDE).getNameInDatabase();
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("INSERT INTO " + tableNameInDatabase + " SELECT 1, 'Trino', '2018-01-01'"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
        QueryAssert.assertThat((QueryResult)QueryExecutor.query((String)("SELECT * FROM " + tableNameInDatabase), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "Trino", "2018-01-01"})});
    }
}

