/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.hive;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.HiveDataSource;
import io.trino.tempto.fulfillment.table.hive.InlineDataSource;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.internal.hadoop.hdfs.HdfsDataSourceWriter;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSyncPartitionMetadata
extends ProductTest {
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    private HdfsDataSourceWriter hdfsDataSourceWriter;

    @Test(groups={"hive_partitioning", "smoke", "trino_jdbc"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testAddPartition() {
        String tableName = "test_sync_partition_metadata_add_partition";
        this.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'ADD')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", "2"}), QueryAssert.Row.row((Object[])new Object[]{"f", "9"}));
        QueryAssert.assertThat(() -> QueryExecutor.query((String)("SELECT payload, col_x, col_y FROM " + tableName + " ORDER BY 1, 2, 3 ASC"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessage(String.format("Partition location does not exist: hdfs://hadoop-master:9000%s/%s/col_x=b/col_y=2", this.warehouseDirectory, tableName));
        TestSyncPartitionMetadata.cleanup(tableName);
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testDropPartition() {
        String tableName = "test_sync_partition_metadata_drop_partition";
        this.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'DROP')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}));
        TestSyncPartitionMetadata.assertData(tableName, QueryAssert.Row.row((Object[])new Object[]{1, "a", "1"}));
        TestSyncPartitionMetadata.cleanup(tableName);
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testFullSyncPartition() {
        String tableName = "test_sync_partition_metadata_add_drop_partition";
        this.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'FULL')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"f", "9"}));
        TestSyncPartitionMetadata.assertData(tableName, QueryAssert.Row.row((Object[])new Object[]{1, "a", "1"}), QueryAssert.Row.row((Object[])new Object[]{42, "f", "9"}));
        TestSyncPartitionMetadata.cleanup(tableName);
    }

    @Test(groups={"hive_partitioning", "smoke", "trino_jdbc"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testInvalidSyncMode() {
        String tableName = "test_repair_invalid_mode";
        this.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        QueryAssert.assertThat(() -> QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'INVALID')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).failsWithMessageMatching("java.sql.SQLException: Query failed (.*): Invalid partition metadata sync mode: INVALID");
        TestSyncPartitionMetadata.cleanup(tableName);
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testMixedCasePartitionNames() {
        String tableName = "test_sync_partition_mixed_case";
        this.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        String tableLocation = this.tableLocation(tableName);
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)tableName, (String)"io/trino/tests/hive/data/single_int_column/data.orc");
        this.hdfsDataSourceWriter.ensureDataOnHdfs(tableLocation + "/col_x=h/col_Y=11", dataSource);
        this.hdfsClient.createDirectory(tableLocation + "/COL_X=UPPER/COL_Y=12");
        this.hdfsDataSourceWriter.ensureDataOnHdfs(tableLocation + "/COL_X=UPPER/COL_Y=12", dataSource);
        QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'FULL', false)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"UPPER", "12"}), QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"f", "9"}), QueryAssert.Row.row((Object[])new Object[]{"g", "10"}), QueryAssert.Row.row((Object[])new Object[]{"h", "11"}));
        TestSyncPartitionMetadata.assertData(tableName, QueryAssert.Row.row((Object[])new Object[]{1, "a", "1"}), QueryAssert.Row.row((Object[])new Object[]{42, "UPPER", "12"}), QueryAssert.Row.row((Object[])new Object[]{42, "f", "9"}), QueryAssert.Row.row((Object[])new Object[]{42, "g", "10"}), QueryAssert.Row.row((Object[])new Object[]{42, "h", "11"}));
    }

    @Test(groups={"hive_partitioning", "smoke"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="Error committing write to Hive(?s:.*)(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testConflictingMixedCasePartitionNames() {
        String tableName = "test_sync_partition_mixed_case";
        this.prepare(this.hdfsClient, this.hdfsDataSourceWriter, tableName);
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)tableName, (String)"io/trino/tests/hive/data/single_int_column/data.orc");
        this.hdfsDataSourceWriter.ensureDataOnHdfs(this.tableLocation(tableName) + "/COL_X=a/cOl_y=1", dataSource);
        Assertions.assertThatThrownBy(() -> QueryExecutor.query((String)("CALL system.sync_partition_metadata('default', '" + tableName + "', 'ADD', false)"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0])).hasMessageContaining(String.format("One or more partitions already exist for table 'default.%s'", tableName));
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", "2"}));
    }

    private String tableLocation(String tableName) {
        return this.warehouseDirectory + "/" + tableName;
    }

    private void prepare(HdfsClient hdfsClient, HdfsDataSourceWriter hdfsDataSourceWriter, String tableName) {
        QueryExecutor.query((String)("DROP TABLE IF EXISTS " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("CREATE TABLE " + tableName + " (payload bigint, col_x varchar, col_y varchar) WITH (format = 'ORC', partitioned_by = ARRAY[ 'col_x', 'col_y' ])"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryExecutor.query((String)("INSERT INTO " + tableName + " VALUES (1, 'a', '1'), (2, 'b', '2')"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        String tableLocation = this.tableLocation(tableName);
        hdfsClient.delete(tableLocation + "/col_x=b/col_y=2");
        hdfsClient.createDirectory(tableLocation + "/col_x=f/col_y=9");
        HiveDataSource dataSource = InlineDataSource.createResourceDataSource((String)tableName, (String)"io/trino/tests/hive/data/single_int_column/data.orc");
        hdfsDataSourceWriter.ensureDataOnHdfs(tableLocation + "/col_x=f/col_y=9", dataSource);
        hdfsClient.createDirectory(tableLocation + "/COL_X=g/col_y=10");
        hdfsDataSourceWriter.ensureDataOnHdfs(tableLocation + "/COL_X=g/col_y=10", dataSource);
        hdfsClient.createDirectory(tableLocation + "/col_x=d");
        hdfsClient.createDirectory(tableLocation + "/col_y=3/col_x=h");
        hdfsClient.createDirectory(tableLocation + "/col_y=3");
        hdfsClient.createDirectory(tableLocation + "/xyz");
        TestSyncPartitionMetadata.assertPartitions(tableName, QueryAssert.Row.row((Object[])new Object[]{"a", "1"}), QueryAssert.Row.row((Object[])new Object[]{"b", "2"}));
    }

    private static void cleanup(String tableName) {
        QueryExecutor.query((String)("DROP TABLE " + tableName), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
    }

    private static void assertPartitions(String tableName, QueryAssert.Row ... rows) {
        QueryResult partitionListResult = QueryExecutor.query((String)("SELECT * FROM \"" + tableName + "$partitions\" ORDER BY 1, 2"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)partitionListResult).containsExactly(rows);
    }

    private static void assertData(String tableName, QueryAssert.Row ... rows) {
        QueryResult dataResult = QueryExecutor.query((String)("SELECT payload, col_x, col_y FROM " + tableName + " ORDER BY 1, 2, 3 ASC"), (QueryExecutor.QueryParam[])new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)dataResult).containsExactly(rows);
    }
}

