/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.iceberg;

import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.hive.util.TemporaryHiveTable;
import io.trino.tests.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestIcebergCreateTable
extends ProductTest {
    @BeforeTestWithContext
    public void setUp() {
        QueryExecutors.onPresto().executeQuery("CREATE SCHEMA IF NOT EXISTS iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @AfterTestWithContext
    public void cleanUp() {
        QueryExecutors.onPresto().executeQuery("DROP SCHEMA iceberg.iceberg", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "storage_formats"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4864", match="Failed to read footer of file")
    public void testCreateTable() {
        String tableName = "iceberg.iceberg.test_create_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onPresto().executeQuery("CREATE TABLE " + tableName + "(a bigint, b varchar)", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onPresto().executeQuery("INSERT INTO " + tableName + "(a, b) VALUES (NULL, NULL), (-42, 'abc'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onPresto().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"iceberg", "storage_formats"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4864", match="Failed to read footer of file")
    public void testCreateTableAsSelect() {
        String tableName = "iceberg.iceberg.test_create_table_as_select_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onPresto().executeQuery("CREATE TABLE " + tableName + " AS SELECT * FROM (VALUES   (NULL, NULL),   (-42, 'abc'),   (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz')) t(a, b)", new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc"}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz"})});
        }
        finally {
            QueryExecutors.onPresto().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

