/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.iceberg;

import io.trino.jdbc.Row;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.utils.QueryExecutors;
import java.sql.Date;
import java.sql.Timestamp;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSparkCompatibility
extends ProductTest {
    private static final String SPARK_CATALOG = "iceberg_test";
    private static final String PRESTO_CATALOG = "iceberg";

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testPrestoReadingSparkData() {
        String baseTableName = "test_presto_reading_primitive_types";
        String sparkTableName = TestSparkCompatibility.sparkTableName(baseTableName);
        String sparkTableDefinition = "CREATE TABLE %s (  _string STRING, _bigint BIGINT, _integer INTEGER, _real REAL, _double DOUBLE, _boolean BOOLEAN, _timestamp TIMESTAMP, _date DATE) USING ICEBERG";
        QueryExecutors.onSpark().executeQuery(String.format(sparkTableDefinition, sparkTableName), new QueryExecutor.QueryParam[0]);
        String values = "VALUES ('a_string', 1000000000000000, 1000000000, 10000000.123, 100000000000.123, true, TIMESTAMP '2020-06-28 14:16:00.456', DATE '1950-06-28')";
        String insert = String.format("INSERT INTO %s %s", sparkTableName, values);
        QueryExecutors.onSpark().executeQuery(insert, new QueryExecutor.QueryParam[0]);
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{"a_string", 1000000000000000L, 1000000000, Float.valueOf(1.0E7f), 1.00000000000123E11, true, Timestamp.valueOf("2020-06-28 14:16:00.456"), Date.valueOf("1950-06-28")});
        String startOfSelect = "SELECT _string, _bigint, _integer, _real, _double, _boolean";
        QueryResult sparkSelect = QueryExecutors.onSpark().executeQuery(String.format("%s, _timestamp, _date FROM %s", startOfSelect, sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)sparkSelect).containsOnly(new QueryAssert.Row[]{row});
        QueryResult prestoSelect = QueryExecutors.onPresto().executeQuery(String.format("%s, CAST(_timestamp AS TIMESTAMP), _date FROM %s", startOfSelect, TestSparkCompatibility.prestoTableName(baseTableName)), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)prestoSelect).containsOnly(new QueryAssert.Row[]{row});
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + sparkTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testSparkReadingPrestoData() {
        String baseTableName = "test_spark_reading_primitive_types";
        String prestoTableName = TestSparkCompatibility.prestoTableName(baseTableName);
        String prestoTableDefinition = "CREATE TABLE %s (  _string VARCHAR, _bigint BIGINT, _integer INTEGER, _real REAL, _double DOUBLE, _boolean BOOLEAN, _date DATE) WITH (format = 'ORC')";
        QueryExecutors.onPresto().executeQuery(String.format(prestoTableDefinition, prestoTableName), new QueryExecutor.QueryParam[0]);
        String values = "VALUES ('a_string', 1000000000000000, 1000000000, 10000000.123, 100000000000.123, true, DATE '1950-06-28')";
        String insert = String.format("INSERT INTO %s %s", prestoTableName, values);
        QueryExecutors.onPresto().executeQuery(insert, new QueryExecutor.QueryParam[0]);
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{"a_string", 1000000000000000L, 1000000000, Float.valueOf(1.0E7f), 1.00000000000123E11, true, "1950-06-28"});
        String startOfSelect = "SELECT _string, _bigint, _integer, _real, _double, _boolean";
        QueryResult prestoSelect = QueryExecutors.onPresto().executeQuery(String.format("%s, /* CAST(_timestamp AS VARCHAR),*/ CAST(_date AS VARCHAR) FROM %s", startOfSelect, prestoTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)prestoSelect).containsOnly(new QueryAssert.Row[]{row});
        QueryResult sparkSelect = QueryExecutors.onSpark().executeQuery(String.format("%s, /* CAST(_timestamp AS STRING),*/ CAST(_date AS STRING) FROM %s", startOfSelect, TestSparkCompatibility.sparkTableName(baseTableName)), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)sparkSelect).containsOnly(new QueryAssert.Row[]{row});
        QueryExecutors.onPresto().executeQuery("DROP TABLE " + prestoTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testSparkCreatesPrestoDrops() {
        String baseTableName = "test_spark_creates_presto_drops";
        QueryExecutors.onSpark().executeQuery(String.format("CREATE TABLE %s (_string STRING, _bigint BIGINT) USING ICEBERG", TestSparkCompatibility.sparkTableName(baseTableName)), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery("DROP TABLE " + TestSparkCompatibility.prestoTableName(baseTableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testPrestoCreatesSparkDrops() {
        String baseTableName = "test_presto_creates_spark_drops";
        QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (_string VARCHAR, _bigint BIGINT)", TestSparkCompatibility.prestoTableName(baseTableName)), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + TestSparkCompatibility.sparkTableName(baseTableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testSparkReadsPrestoPartitionedTable() {
        String baseTableName = "test_spark_reads_presto_partitioned_table";
        String prestoTableName = TestSparkCompatibility.prestoTableName(baseTableName);
        QueryExecutors.onPresto().executeQuery(String.format("CREATE TABLE %s (_string VARCHAR, _bigint BIGINT) WITH (partitioning = ARRAY['_string'])", prestoTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onPresto().executeQuery(String.format("INSERT INTO %s VALUES ('a', 1001), ('b', 1002), ('c', 1003)", prestoTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{"b", 1002});
        String select = "SELECT * FROM %s WHERE _string = 'b'";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery(String.format(select, prestoTableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{row});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onSpark().executeQuery(String.format(select, TestSparkCompatibility.sparkTableName(baseTableName)), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{row});
        QueryExecutors.onPresto().executeQuery("DROP TABLE " + prestoTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testPrestoReadsSparkPartitionedTable() {
        String baseTableName = "test_spark_reads_presto_partitioned_table";
        String sparkTableName = TestSparkCompatibility.sparkTableName(baseTableName);
        QueryExecutors.onSpark().executeQuery(String.format("CREATE TABLE %s (_string STRING, _bigint BIGINT) USING ICEBERG PARTITIONED BY (_string)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s VALUES ('a', 1001), ('b', 1002), ('c', 1003)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{"b", 1002});
        String select = "SELECT * FROM %s WHERE _string = 'b'";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onSpark().executeQuery(String.format(select, sparkTableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{row});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onPresto().executeQuery(String.format(select, TestSparkCompatibility.prestoTableName(baseTableName)), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{row});
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + sparkTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testPrestoReadingCompositeSparkData() {
        String baseTableName = "test_presto_reading_spark_composites";
        String sparkTableName = TestSparkCompatibility.sparkTableName(baseTableName);
        String sparkTableDefinition = "CREATE TABLE %s (  doc_id string,\n  info MAP<STRING, INT>,\n  pets ARRAY<STRING>,\n  user_info STRUCT<name:STRING, surname:STRING, age:INT, gender:STRING>)  USING ICEBERG";
        QueryExecutors.onSpark().executeQuery(String.format(sparkTableDefinition, sparkTableName), new QueryExecutor.QueryParam[0]);
        String insert = "INSERT INTO TABLE %s SELECT 'Doc213', map('age', 28, 'children', 3), array('Dog', 'Cat', 'Pig'), \nnamed_struct('name', 'Santa', 'surname', 'Claus','age', 1000,'gender', 'MALE')";
        QueryExecutors.onSpark().executeQuery(String.format(insert, sparkTableName), new QueryExecutor.QueryParam[0]);
        String prestoTableName = TestSparkCompatibility.prestoTableName(baseTableName);
        String prestoSelect = "SELECT doc_id, info['age'], pets[2], user_info.surname FROM " + prestoTableName;
        QueryResult prestoResult = QueryExecutors.onPresto().executeQuery(prestoSelect, new QueryExecutor.QueryParam[0]);
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{"Doc213", 28, "Cat", "Claus"});
        QueryAssert.assertThat((QueryResult)prestoResult).containsOnly(new QueryAssert.Row[]{row});
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testSparkReadingCompositePrestoData() {
        String baseTableName = "test_spark_reading_presto_composites";
        String prestoTableName = TestSparkCompatibility.prestoTableName(baseTableName);
        String prestoTableDefinition = "CREATE TABLE %s (  doc_id VARCHAR,\n  info MAP(VARCHAR, INTEGER),\n  pets ARRAY(VARCHAR),\n  user_info ROW(name VARCHAR, surname VARCHAR, age INTEGER, gender VARCHAR))";
        QueryExecutors.onPresto().executeQuery(String.format(prestoTableDefinition, prestoTableName), new QueryExecutor.QueryParam[0]);
        String insert = "INSERT INTO %s VALUES('Doc213', MAP(ARRAY['age', 'children'], ARRAY[28, 3]), ARRAY['Dog', 'Cat', 'Pig'], ROW('Santa', 'Claus', 1000, 'MALE'))";
        QueryExecutors.onPresto().executeQuery(String.format(insert, prestoTableName), new QueryExecutor.QueryParam[0]);
        String sparkTableName = TestSparkCompatibility.sparkTableName(baseTableName);
        String sparkSelect = "SELECT doc_id, info['age'], pets[1], user_info.surname FROM " + sparkTableName;
        QueryResult sparkResult = QueryExecutors.onSpark().executeQuery(sparkSelect, new QueryExecutor.QueryParam[0]);
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{"Doc213", 28, "Cat", "Claus"});
        QueryAssert.assertThat((QueryResult)sparkResult).containsOnly(new QueryAssert.Row[]{row});
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testPrestoReadingNestedSparkData() {
        String baseTableName = "test_presto_reading_nested_spark_data";
        String sparkTableName = TestSparkCompatibility.sparkTableName(baseTableName);
        String sparkTableDefinition = "CREATE TABLE %s (\n  doc_id STRING\n, nested_map MAP<STRING, ARRAY<STRUCT<sname: STRING, snumber: INT>>>\n, nested_array ARRAY<MAP<STRING, ARRAY<STRUCT<mname: STRING, mnumber: INT>>>>\n, nested_struct STRUCT<name:STRING, complicated: ARRAY<MAP<STRING, ARRAY<STRUCT<mname: STRING, mnumber: INT>>>>>)\n USING ICEBERG";
        QueryExecutors.onSpark().executeQuery(String.format(sparkTableDefinition, sparkTableName), new QueryExecutor.QueryParam[0]);
        String insert = "INSERT INTO TABLE %s SELECT  'Doc213', map('s1', array(named_struct('sname', 'ASName1', 'snumber', 201), named_struct('sname', 'ASName2', 'snumber', 202))), array(map('m1', array(named_struct('mname', 'MAS1Name1', 'mnumber', 301), named_struct('mname', 'MAS1Name2', 'mnumber', 302)))       ,map('m2', array(named_struct('mname', 'MAS2Name1', 'mnumber', 401), named_struct('mname', 'MAS2Name2', 'mnumber', 402)))), named_struct('name', 'S1',               'complicated', array(map('m1', array(named_struct('mname', 'SAMA1Name1', 'mnumber', 301), named_struct('mname', 'SAMA1Name2', 'mnumber', 302)))                                   ,map('m2', array(named_struct('mname', 'SAMA2Name1', 'mnumber', 401), named_struct('mname', 'SAMA2Name2', 'mnumber', 402)))))";
        QueryExecutors.onSpark().executeQuery(String.format(insert, sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{"Doc213", "ASName2", 201, "MAS2Name1", 302, "SAMA1Name1", 402});
        String sparkSelect = "SELECT  doc_id, nested_map['s1'][1].sname, nested_map['s1'][0].snumber, nested_array[1]['m2'][0].mname, nested_array[0]['m1'][1].mnumber, nested_struct.complicated[0]['m1'][0].mname, nested_struct.complicated[1]['m2'][1].mnumber  FROM ";
        QueryResult sparkResult = QueryExecutors.onSpark().executeQuery(sparkSelect + sparkTableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)sparkResult).containsOnly(new QueryAssert.Row[]{row});
        String prestoTableName = TestSparkCompatibility.prestoTableName(baseTableName);
        String prestoSelect = "SELECT  doc_id, nested_map['s1'][2].sname, nested_map['s1'][1].snumber, nested_array[2]['m2'][1].mname, nested_array[1]['m1'][2].mnumber, nested_struct.complicated[1]['m1'][1].mname, nested_struct.complicated[2]['m2'][2].mnumber  FROM ";
        QueryResult prestoResult = QueryExecutors.onPresto().executeQuery(prestoSelect + prestoTableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)prestoResult).containsOnly(new QueryAssert.Row[]{row});
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testSparkReadingNestedPrestoData() {
        String baseTableName = "test_spark_reading_nested_presto_data";
        String prestoTableName = TestSparkCompatibility.prestoTableName(baseTableName);
        String prestoTableDefinition = "CREATE TABLE %s (\n  doc_id VARCHAR\n, nested_map MAP(VARCHAR, ARRAY(ROW(sname VARCHAR, snumber INT)))\n, nested_array ARRAY(MAP(VARCHAR, ARRAY(ROW(mname VARCHAR, mnumber INT))))\n, nested_struct ROW(name VARCHAR, complicated ARRAY(MAP(VARCHAR, ARRAY(ROW(mname VARCHAR, mnumber INT))))))";
        QueryExecutors.onPresto().executeQuery(String.format(prestoTableDefinition, prestoTableName), new QueryExecutor.QueryParam[0]);
        String insert = "INSERT INTO %s SELECT  'Doc213', map(array['s1'], array[array[row('ASName1', 201), row('ASName2', 202)]]), array[map(array['m1'], array[array[row('MAS1Name1', 301), row('MAS1Name2', 302)]])       ,map(array['m2'], array[array[row('MAS2Name1', 401), row('MAS2Name2', 402)]])], row('S1'      ,array[map(array['m1'], array[array[row('SAMA1Name1', 301), row('SAMA1Name2', 302)]])            ,map(array['m2'], array[array[row('SAMA2Name1', 401), row('SAMA2Name2', 402)]])])";
        QueryExecutors.onPresto().executeQuery(String.format(insert, prestoTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{"Doc213", "ASName2", 201, "MAS2Name1", 302, "SAMA1Name1", 402});
        String prestoSelect = "SELECT  doc_id, nested_map['s1'][2].sname, nested_map['s1'][1].snumber, nested_array[2]['m2'][1].mname, nested_array[1]['m1'][2].mnumber, nested_struct.complicated[1]['m1'][1].mname, nested_struct.complicated[2]['m2'][2].mnumber  FROM ";
        QueryResult prestoResult = QueryExecutors.onPresto().executeQuery(prestoSelect + prestoTableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)prestoResult).containsOnly(new QueryAssert.Row[]{row});
        String sparkTableName = TestSparkCompatibility.sparkTableName(baseTableName);
        String sparkSelect = "SELECT  doc_id, nested_map['s1'][1].sname, nested_map['s1'][0].snumber, nested_array[1]['m2'][0].mname, nested_array[0]['m1'][1].mnumber, nested_struct.complicated[0]['m1'][0].mname, nested_struct.complicated[1]['m2'][1].mnumber  FROM ";
        QueryResult sparkResult = QueryExecutors.onSpark().executeQuery(sparkSelect + sparkTableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)sparkResult).containsOnly(new QueryAssert.Row[]{row});
    }

    @Test(groups={"iceberg", "profile_specific_tests"})
    public void testIdBasedFieldMapping() {
        String baseTableName = "test_schema_evolution_for_nested_fields";
        String prestoTableName = TestSparkCompatibility.prestoTableName(baseTableName);
        String sparkTableName = TestSparkCompatibility.sparkTableName(baseTableName);
        QueryExecutors.onSpark().executeQuery(String.format("CREATE TABLE %s (_struct STRUCT<rename:BIGINT, keep:BIGINT, drop_and_add:BIGINT, CaseSensitive:BIGINT>, _partition BIGINT) USING ICEBERG partitioned by (_partition) TBLPROPERTIES ('write.format.default' = 'orc')", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO TABLE %s SELECT named_struct('rename', 1, 'keep', 2, 'drop_and_add', 3, 'CaseSensitive', 4), 1001", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("ALTER TABLE %s RENAME COLUMN _struct.rename TO renamed", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("ALTER TABLE %s DROP COLUMN _struct.drop_and_add", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("ALTER TABLE %s ADD COLUMN _struct.drop_and_add BIGINT", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.Row expected = QueryAssert.Row.row((Object[])new Object[]{this.rowBuilder().addField("renamed", (Object)1L).addField("keep", (Object)2L).addField("CaseSensitive", (Object)4L).addField("drop_and_add", null).build(), 1001});
        QueryResult result = QueryExecutors.onPresto().executeQuery(String.format("SELECT * FROM %s", prestoTableName), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals(result.column(1).get(0), expected.getValues().get(0));
    }

    private static String sparkTableName(String tableName) {
        return String.format("%s.default.%s", SPARK_CATALOG, tableName);
    }

    private static String prestoTableName(String tableName) {
        return String.format("%s.default.%s", PRESTO_CATALOG, tableName);
    }

    private Row.Builder rowBuilder() {
        return Row.builder();
    }
}

