/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.jdbc;

import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.airlift.log.Logger;
import io.trino.jdbc.TestingRedirectHandlerInjector;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.TpchTableResults;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestExternalAuthorizerOAuth2
extends ProductTest {
    private static final Logger log = Logger.get(TestExternalAuthorizerOAuth2.class);
    @Inject
    @Named(value="databases.presto.jdbc_url")
    String jdbcUrl;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private Future<?> lastLoginAction;

    @AfterClass(alwaysRun=true)
    public void clean() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    @Test(groups={"oauth2", "profile_specific_tests"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/6991", match="Last login action has failed with exception")
    public void shouldAuthenticateAndExecuteQuery() throws SQLException {
        this.prepareSeleniumHandler();
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        try (Connection connection = DriverManager.getConnection(this.jdbcUrl, properties);
             PreparedStatement statement = connection.prepareStatement("select * from tpch.tiny.nation");
             ResultSet results = statement.executeQuery();){
            Assertions.assertThatNoException().isThrownBy(() -> this.checkLastLoginActionExecutionFailures());
            QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)results)).matches(TpchTableResults.PRESTO_NATION_RESULT);
        }
    }

    private void prepareSeleniumHandler() {
        this.lastLoginAction = Futures.immediateFailedFuture((Throwable)((Object)new AssertionError((Object)"Login action has not been triggered")));
        TestingRedirectHandlerInjector.setRedirectHandler(uri -> {
            this.lastLoginAction = this.executor.submit(() -> {
                WebDriver driver = this.getWebDriver();
                driver.get(uri.toString());
                WebDriverWait wait = new WebDriverWait(driver, 10L);
                this.submitCredentials(driver, "foo@bar.com", "foobar", wait);
                this.giveConsent(driver, wait);
            });
        });
    }

    private WebDriver getWebDriver() {
        ChromeOptions options = new ChromeOptions();
        options.setAcceptInsecureCerts(true);
        return new RemoteWebDriver(this.getWebDriverUrl(), (Capabilities)options);
    }

    private URL getWebDriverUrl() {
        try {
            return new URL("http", "selenium-chrome", 7777, "/wd/hub");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void submitCredentials(WebDriver driver, String email, String password, WebDriverWait wait) {
        log.info("trying to submit credentials");
        By emailElementLocator = By.id((String)"email");
        log.info("waiting for email field");
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)emailElementLocator));
        log.info("email field found");
        WebElement usernameElement = driver.findElement(emailElementLocator);
        usernameElement.sendKeys(new CharSequence[]{email});
        log.info("email field set to %s", new Object[]{email});
        log.info("waiting for password field");
        By passwordElementLocator = By.id((String)"password");
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)passwordElementLocator));
        log.info("password field found");
        WebElement passwordElement = driver.findElement(passwordElementLocator);
        passwordElement.sendKeys(new CharSequence[]{password + "\n"});
        log.info("password field set to %s", new Object[]{password});
    }

    private void giveConsent(WebDriver driver, WebDriverWait wait) {
        log.info("trying to give consent");
        log.info("waiting for openId checkbox");
        By openIdCheckboxLocator = By.id((String)"openid");
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)openIdCheckboxLocator));
        log.info("openId checkbox found");
        WebElement openIdCheckbox = driver.findElement(openIdCheckboxLocator);
        openIdCheckbox.click();
        log.info("openId checkbox clicked");
        log.info("waiting for accept button");
        By acceptButtonLocator = By.id((String)"accept");
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)acceptButtonLocator));
        log.info("accept button found");
        WebElement acceptButton = driver.findElement(acceptButtonLocator);
        acceptButton.click();
        log.info("accept button clicked");
    }

    private void checkLastLoginActionExecutionFailures() throws Throwable {
        try {
            this.lastLoginAction.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                throw new AssertionError("Last login action has failed with exception", e.getCause());
            }
            throw e;
        }
    }
}

