/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.sqlserver;

import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.sqlserver.SqlServerDataTypesTableDefinition;
import io.trino.tests.utils.QueryExecutors;
import java.sql.Date;
import org.testng.annotations.Test;

public class TestInsert
extends ProductTest
implements RequirementsProvider {
    private static final String SQLSERVER = "sqlserver";
    private static final String MASTER = "master";
    private static final String INSERT_TABLE_NAME = String.format("%s.%s", "dbo", SqlServerDataTypesTableDefinition.SQLSERVER_INSERT.getName());

    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)SqlServerDataTypesTableDefinition.SQLSERVER_INSERT);
    }

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTables() {
        QueryExecutors.onPresto().executeQuery(String.format("DROP TABLE IF EXISTS %s", INSERT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testInsertMin() {
        String sql = String.format("INSERT INTO %s.%s values (BIGINT '%s', SMALLINT '%s', INTEGER '%s', DOUBLE '%s', CHAR 'a   ', 'aa', DOUBLE '%s', DATE '%s')", SQLSERVER, INSERT_TABLE_NAME, Long.MIN_VALUE, (short)Short.MIN_VALUE, Integer.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE, Date.valueOf("1970-01-01"));
        QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        sql = String.format("SELECT * FROM %s.%s", MASTER, INSERT_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onSqlServer().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Long.MIN_VALUE, (short)Short.MIN_VALUE, Integer.MIN_VALUE, Double.MIN_VALUE, "a   ", "aa", Double.MIN_VALUE, Date.valueOf("1970-01-01")})});
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testInsertMax() {
        String sql = String.format("INSERT INTO %s.%s values (BIGINT '%s', SMALLINT '%s', INTEGER '%s', DOUBLE '%s', CHAR 'aaaa', 'aaaaaa', DOUBLE '%s', DATE '%s' )", SQLSERVER, INSERT_TABLE_NAME, Long.MAX_VALUE, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Double.MAX_VALUE, Double.valueOf("12345678912.3456756"), Date.valueOf("9999-12-31"));
        QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        sql = String.format("SELECT * FROM %s.%s", MASTER, INSERT_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onSqlServer().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Double.MAX_VALUE, "aaaa", "aaaaaa", Double.valueOf("12345678912.3456756"), Date.valueOf("9999-12-31")})});
    }

    @Test(groups={"sqlserver", "profile_specific_tests"})
    public void testInsertNull() {
        String sql = String.format("INSERT INTO %s.%s values (null, null, null, null, null, null, null, null)", SQLSERVER, INSERT_TABLE_NAME);
        QueryExecutors.onPresto().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        sql = String.format("SELECT * FROM %s.%s", MASTER, INSERT_TABLE_NAME);
        QueryResult queryResult = QueryExecutors.onSqlServer().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null, null})});
    }
}

