/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.utils;

import com.google.common.base.Preconditions;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.context.ThreadLocalTestContextHolder;
import java.util.HashMap;

public final class SchemaRegistryClientUtils {
    private static final int CACHE_SIZE = 100;

    private SchemaRegistryClientUtils() {
    }

    public static SchemaRegistryClient getSchemaRegistryClient() {
        HashMap schemaRegistryProperties = new HashMap(((Configuration)ThreadLocalTestContextHolder.testContext().getDependency(Configuration.class)).getSubconfiguration("schema-registry").asMap());
        Preconditions.checkArgument((boolean)schemaRegistryProperties.containsKey("url"), (Object)"schemaRegistry url is missing");
        return new CachedSchemaRegistryClient((String)schemaRegistryProperties.remove("url"), 100, schemaRegistryProperties);
    }
}

