/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Throwables;
import io.airlift.log.Logger;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveVersionProvider;
import java.time.temporal.ChronoUnit;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.jodah.failsafe.RetryPolicy;
import org.intellij.lang.annotations.Language;

public class HiveProductTest
extends ProductTest {
    private static final Logger log = Logger.get(HiveProductTest.class);
    static final String ERROR_COMMITTING_WRITE_TO_HIVE_ISSUE = "https://github.com/trinodb/trino/issues/4936";
    @Language(value="RegExp")
    static final String ERROR_COMMITTING_WRITE_TO_HIVE_MATCH = "(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)";
    public static final RetryPolicy<QueryResult> ERROR_COMMITTING_WRITE_TO_HIVE_RETRY_POLICY = ((RetryPolicy)new RetryPolicy().handleIf(HiveProductTest::isErrorCommittingToHive)).withBackoff(1L, 10L, ChronoUnit.SECONDS).withMaxRetries(30).onRetry(event -> log.warn(event.getLastFailure(), "Query failed on attempt %d, will retry.", new Object[]{event.getAttemptCount()}));
    @Inject
    private HiveVersionProvider hiveVersionProvider;

    private static boolean isErrorCommittingToHive(Throwable throwable) {
        return Pattern.compile(ERROR_COMMITTING_WRITE_TO_HIVE_MATCH).matcher(Throwables.getStackTraceAsString((Throwable)throwable)).find();
    }

    protected int getHiveVersionMajor() {
        return this.hiveVersionProvider.getHiveVersion().getMajorVersion();
    }

    protected int getHiveVersionMinor() {
        return this.hiveVersionProvider.getHiveVersion().getMinorVersion();
    }

    protected int getHiveVersionPatch() {
        return this.hiveVersionProvider.getHiveVersion().getPatchVersion();
    }

    protected boolean isHiveVersionBefore12() {
        return this.getHiveVersionMajor() == 0 || this.getHiveVersionMajor() == 1 && this.getHiveVersionMinor() < 2;
    }

    protected boolean isHiveWithBrokenAvroTimestamps() {
        return this.getHiveVersionMajor() == 3 && this.getHiveVersionMinor() == 1 && (this.getHiveVersionPatch() == 0 || this.getHiveVersionPatch() == 1);
    }
}

