/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.testng.services.Flaky;
import io.trino.tests.product.hive.BaseTestSyncPartitionMetadata;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import java.util.Objects;
import org.testng.annotations.Test;

public class TestAbfsSyncPartitionMetadata
extends BaseTestSyncPartitionMetadata {
    private final String schema = "test_" + TemporaryHiveTable.randomTableSuffix();

    @Override
    protected String schemaLocation() {
        String container = Objects.requireNonNull(System.getenv("ABFS_CONTAINER"), "Environment variable not set: ABFS_CONTAINER");
        String account = Objects.requireNonNull(System.getenv("ABFS_ACCOUNT"), "Environment variable not set: ABFS_ACCOUNT");
        return String.format("abfs://%s@%s.dfs.core.windows.net/%s", container, account, this.schema);
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testAddPartition() {
        super.testAddPartition();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testAddPartitionContainingCharactersThatNeedUrlEncoding() {
        super.testAddPartitionContainingCharactersThatNeedUrlEncoding();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testDropPartition() {
        super.testDropPartition();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testDropPartitionContainingCharactersThatNeedUrlEncoding() {
        super.testDropPartitionContainingCharactersThatNeedUrlEncoding();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testFullSyncPartition() {
        super.testFullSyncPartition();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testInvalidSyncMode() {
        super.testInvalidSyncMode();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testMixedCasePartitionNames() {
        super.testMixedCasePartitionNames();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testConflictingMixedCasePartitionNames() {
        super.testConflictingMixedCasePartitionNames();
    }
}

