/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.util.CachingTestUtils;
import io.trino.tests.product.utils.QueryAssertions;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCaching
extends ProductTest {
    private static final int NUMBER_OF_FILES = 5;

    @Test(groups={"hive_caching", "profile_specific_tests"})
    public void testReadFromCache() {
        this.testReadFromTable("table1");
        this.testReadFromTable("table2");
    }

    private void testReadFromTable(String tableNameSuffix) {
        String cachedTableName = "hive.default.test_cache_read" + tableNameSuffix;
        String nonCachedTableName = "hivenoncached.default.test_cache_read" + tableNameSuffix;
        QueryAssert.Row[] tableData = this.createTestTable(nonCachedTableName);
        CachingTestUtils.CacheStats beforeCacheStats = CachingTestUtils.getCacheStats();
        long initialRemoteReads = beforeCacheStats.getRemoteReads();
        long initialCachedReads = beforeCacheStats.getCachedReads();
        long initialNonLocalReads = beforeCacheStats.getNonLocalReads();
        long initialAsyncDownloadedMb = beforeCacheStats.getAsyncDownloadedMb();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + cachedTableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(tableData);
        QueryAssertions.assertEventually(new Duration(20.0, TimeUnit.SECONDS), () -> {
            CachingTestUtils.CacheStats afterQueryCacheStats = CachingTestUtils.getCacheStats();
            Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(afterQueryCacheStats.getAsyncDownloadedMb()), (Comparable)Long.valueOf(initialAsyncDownloadedMb + 5L));
            Assertions.assertGreaterThan((Comparable)Long.valueOf(afterQueryCacheStats.getRemoteReads()), (Comparable)Long.valueOf(initialRemoteReads));
            Assert.assertEquals((long)afterQueryCacheStats.getCachedReads(), (long)initialCachedReads);
            Assert.assertEquals((long)afterQueryCacheStats.getNonLocalReads(), (long)initialNonLocalReads);
        });
        QueryAssertions.assertEventually(new Duration(10.0, TimeUnit.SECONDS), () -> {
            CachingTestUtils.CacheStats beforeQueryCacheStats = CachingTestUtils.getCacheStats();
            long beforeQueryCachedReads = beforeQueryCacheStats.getCachedReads();
            long beforeQueryRemoteReads = beforeQueryCacheStats.getRemoteReads();
            long beforeQueryNonLocalReads = beforeQueryCacheStats.getNonLocalReads();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + cachedTableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(tableData);
            CachingTestUtils.CacheStats afterQueryCacheStats = CachingTestUtils.getCacheStats();
            Assertions.assertGreaterThan((Comparable)Long.valueOf(afterQueryCacheStats.getCachedReads()), (Comparable)Long.valueOf(beforeQueryCachedReads));
            Assert.assertEquals((long)afterQueryCacheStats.getRemoteReads(), (long)beforeQueryRemoteReads);
            Assert.assertEquals((long)afterQueryCacheStats.getNonLocalReads(), (long)beforeQueryNonLocalReads);
        });
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + nonCachedTableName, new QueryExecutor.QueryParam[0]);
    }

    private QueryAssert.Row[] createTestTable(String tableName) {
        StringBuilder randomDataBuilder = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 500000; ++i) {
            randomDataBuilder.append(random.nextInt(10));
        }
        String randomData = randomDataBuilder.toString();
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " (col varchar) WITH (format='TEXTFILE')", new QueryExecutor.QueryParam[0]);
        for (int i = 0; i < 5; ++i) {
            QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " SELECT format('%1$s%1$s%1$s%1$s%1$s', '" + randomData + "')", new QueryExecutor.QueryParam[0]);
        }
        QueryAssert.Row row = QueryAssert.Row.row((Object[])new Object[]{randomData.repeat(5)});
        return Collections.nCopies(5, row).toArray(new QueryAssert.Row[0]);
    }
}

