/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.JDBCType;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveRedirectionToIceberg
extends ProductTest {
    @BeforeTestWithContext
    public void createAdditionalSchema() {
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive.nondefaultschema", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirect() {
        String tableName = "redirect_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectWithNonDefaultSchema() {
        String tableName = "redirect_non_default_schema_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.nondefaultschema." + tableName;
        String icebergTableName = "iceberg.nondefaultschema." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectToNonexistentCatalog() {
        String tableName = "redirect_to_nonexistent_iceberg_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("SET SESSION hive.iceberg_catalog_name = 'someweirdcatalog'", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'hive.default.redirect_to_nonexistent_iceberg_.*' redirected to 'someweirdcatalog.default.redirect_to_nonexistent_iceberg_.*', but the target catalog 'someweirdcatalog' does not exist");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectWithDefaultSchemaInSession() {
        String tableName = "redirect_with_use_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + tableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("USE hive.default", new QueryExecutor.QueryParam[0]);
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + tableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectPartitionsToUnpartitioned() {
        String tableName = "iceberg_unpartitioned_table_" + TemporaryHiveTable.randomTableSuffix();
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT record_count, data.nationkey.min, data.nationkey.max, data.name.min, data.name.max FROM hive.default.\"" + tableName + "$partitions\"", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25L, 0L, 24L, "ALGERIA", "VIETNAM"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRedirectPartitionsToPartitioned() {
        String tableName = "iceberg_partitioned_table_" + TemporaryHiveTable.randomTableSuffix();
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, true);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT partition.regionkey, record_count, data.nationkey.min, data.nationkey.max, data.name.min, data.name.max FROM hive.default.\"" + tableName + "$partitions\"", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0L, 5L, 0L, 16L, "ALGERIA", "MOZAMBIQUE"}), QueryAssert.Row.row((Object[])new Object[]{1L, 5L, 1L, 24L, "ARGENTINA", "UNITED STATES"}), QueryAssert.Row.row((Object[])new Object[]{2L, 5L, 8L, 21L, "CHINA", "VIETNAM"}), QueryAssert.Row.row((Object[])new Object[]{3L, 5L, 6L, 23L, "FRANCE", "UNITED KINGDOM"}), QueryAssert.Row.row((Object[])new Object[]{4L, 5L, 4L, 20L, "EGYPT", "SAUDI ARABIA"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"}, dataProvider="schemaAndPartitioning")
    public void testInsert(String schema, boolean partitioned) {
        String tableName = "iceberg_insert_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive." + schema + "." + tableName;
        String icebergTableName = "iceberg." + schema + "." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, partitioned, false);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + hiveTableName + " VALUES (42, 'some name', 12, 'some comment')", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42L, "some name", 12L, "some comment"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42L, "some name", 12L, "some comment"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @DataProvider
    public static Object[][] schemaAndPartitioning() {
        return new Object[][]{{"default", false}, {"default", true}, {"nondefaultschema", false}, {"nondefaultschema", true}};
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testDelete() {
        String tableName = "iceberg_insert_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, true);
        QueryExecutors.onTrino().executeQuery("DELETE FROM " + hiveTableName + " WHERE regionkey = 1", new QueryExecutor.QueryParam[0]);
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT nationkey, name, regionkey, comment FROM tpch.tiny.nation WHERE regionkey != 1", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testUpdate() {
        String tableName = "iceberg_insert_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, true);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE " + hiveTableName + " SET nationkey = nationkey + 100 WHERE regionkey = 1", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): This connector does not support updates");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testDropTable() {
        String tableName = "hive_drop_iceberg_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table '" + icebergTableName + "' does not exist");
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testDescribe() {
        String tableName = "iceberg_describe_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, true);
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("DESCRIBE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("DESCRIBE " + hiveTableName, new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testShowCreateTable() {
        String tableName = "iceberg_show_create_table_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, true);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + hiveTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"CREATE TABLE " + icebergTableName + " (\n   nationkey bigint,\n   name varchar,\n   regionkey bigint,\n   comment varchar\n)\nWITH (\n   format = 'ORC',\n   format_version = 2,\n" + String.format("   location = 'hdfs://hadoop-master:9000/user/hive/warehouse/%s',\n", tableName) + "   partitioning = ARRAY['regionkey']\n)"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testShowStats() {
        String tableName = "iceberg_show_create_table_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, true);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW STATS FOR " + hiveTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"nationkey", null, null, 0.0, null, "0", "24"}), QueryAssert.Row.row((Object[])new Object[]{"name", null, null, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{"regionkey", null, null, 0.0, null, "0", "4"}), QueryAssert.Row.row((Object[])new Object[]{"comment", null, null, 0.0, null, null, null}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, 25.0, null, null})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testAlterTableRename() {
        String tableName = "iceberg_rename_table_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE " + hiveTableName + " RENAME TO hive.default." + tableName + "_new", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table rename across catalogs is not supported");
        String newTableNameWithoutCatalogWithoutSchema = tableName + "_new_without_catalog_without_schema";
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + hiveTableName + " RENAME TO " + newTableNameWithoutCatalogWithoutSchema, new QueryExecutor.QueryParam[0]);
        String newTableNameWithoutCatalogWithSchema = tableName + "_new_without_catalog_with_schema";
        QueryExecutors.onTrino().executeQuery("ALTER TABLE hive.default." + newTableNameWithoutCatalogWithoutSchema + " RENAME TO default." + newTableNameWithoutCatalogWithSchema, new QueryExecutor.QueryParam[0]);
        String newTableNameWithCatalogWithSchema = tableName + "_new_with_catalog_with_schema";
        QueryExecutors.onTrino().executeQuery("ALTER TABLE hive.default." + newTableNameWithoutCatalogWithSchema + " RENAME TO iceberg.default." + newTableNameWithCatalogWithSchema, new QueryExecutor.QueryParam[0]);
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName + "_new_with_catalog_with_schema", new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE " + hiveTableName + "_new_with_catalog_with_schema", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName + "_new_with_catalog_with_schema", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testAlterTableAddColumn() {
        String tableName = "iceberg_alter_table_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + hiveTableName + " ADD COLUMN some_new_column double", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("DESCRIBE " + icebergTableName, new QueryExecutor.QueryParam[0]).column(1)).containsOnly(new Object[]{"nationkey", "name", "regionkey", "comment", "some_new_column"});
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT * , NULL FROM tpch.tiny.nation", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testAlterTableDropColumn() {
        String tableName = "iceberg_alter_table_drop_column_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + hiveTableName + " DROP COLUMN comment", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("DESCRIBE " + icebergTableName, new QueryExecutor.QueryParam[0]).column(1)).containsOnly(new Object[]{"nationkey", "name", "regionkey"});
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT nationkey, name, regionkey FROM tpch.tiny.nation", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testAlterTableRenameColumn() {
        String tableName = "iceberg_alter_table_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryExecutors.onTrino().executeQuery("ALTER TABLE " + hiveTableName + " RENAME COLUMN nationkey TO nation_key", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery("DESCRIBE " + icebergTableName, new QueryExecutor.QueryParam[0]).column(1)).containsOnly(new Object[]{"nation_key", "name", "regionkey", "comment"});
        TestHiveRedirectionToIceberg.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("SELECT nationkey as nation_key, name, regionkey, comment FROM tpch.tiny.nation", new QueryExecutor.QueryParam[0]));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testCommentTable() {
        String tableName = "iceberg_comment_table_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        TestHiveRedirectionToIceberg.assertTableComment("hive", "default", tableName).isNull();
        TestHiveRedirectionToIceberg.assertTableComment("iceberg", "default", tableName).isNull();
        String tableComment = "This is my table, there are many like it but this one is mine";
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE " + hiveTableName + " IS '%s'", tableComment), new QueryExecutor.QueryParam[0]);
        TestHiveRedirectionToIceberg.assertTableComment("hive", "default", tableName).isEqualTo(tableComment);
        TestHiveRedirectionToIceberg.assertTableComment("iceberg", "default", tableName).isEqualTo(tableComment);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testCommentColumn() {
        String tableName = "iceberg_comment_column_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        String columnName = "nationkey";
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        TestHiveRedirectionToIceberg.assertColumnComment("hive", "default", tableName, columnName).isNull();
        TestHiveRedirectionToIceberg.assertColumnComment("iceberg", "default", tableName, columnName).isNull();
        String columnComment = "Internal identifier for the nation";
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.%s IS '%s'", hiveTableName, columnName, columnComment), new QueryExecutor.QueryParam[0]);
        TestHiveRedirectionToIceberg.assertColumnComment("hive", "default", tableName, columnName).isEqualTo(columnComment);
        TestHiveRedirectionToIceberg.assertColumnComment("iceberg", "default", tableName, columnName).isEqualTo(columnComment);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testShowGrants() {
        String tableName = "iceberg_show_grants_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SHOW GRANTS ON %s", hiveTableName), new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + icebergTableName + " and SHOW GRANTS is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testInformationSchemaColumns() {
        String schemaName = "redirect_information_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String tableName = "redirect_information_schema_table_" + TemporaryHiveTable.randomTableSuffix();
        String icebergTableName = "iceberg." + schemaName + "." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.information_schema.columns WHERE table_schema = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name", 2, null, "YES", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey", 3, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment", 4, null, "YES", "varchar"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.information_schema.columns WHERE table_schema = '%s'", schemaName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name", 2, null, "YES", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey", 3, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment", 4, null, "YES", "varchar"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM iceberg.information_schema.columns WHERE table_schema = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "name", 2, null, "YES", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "regionkey", 3, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "comment", 4, null, "YES", "varchar"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA hive." + schemaName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testSystemJdbcColumns() {
        String schemaName = "redirect_system_jdbc_columns_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String tableName = "redirect_system_jdbc_columns_table_" + TemporaryHiveTable.randomTableSuffix();
        String icebergTableName = "iceberg." + schemaName + "." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = '%s'", schemaName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'iceberg' AND table_schem = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"iceberg", schemaName, tableName, "comment"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA hive." + schemaName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testGrant() {
        String tableName = "iceberg_grant_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("GRANT SELECT ON " + hiveTableName + " TO ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + icebergTableName + " and GRANT is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testRevoke() {
        String tableName = "iceberg_revoke_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("REVOKE SELECT ON " + hiveTableName + " FROM ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + icebergTableName + " and REVOKE is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testSetTableAuthorization() {
        String tableName = "iceberg_set_table_authorization_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE " + hiveTableName + " SET AUTHORIZATION ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + icebergTableName + " and SET TABLE AUTHORIZATION is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_iceberg_redirections", "profile_specific_tests"})
    public void testDeny() {
        String tableName = "iceberg_deny_" + TemporaryHiveTable.randomTableSuffix();
        String hiveTableName = "hive.default." + tableName;
        String icebergTableName = "iceberg.default." + tableName;
        TestHiveRedirectionToIceberg.createIcebergTable(icebergTableName, false);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DENY DELETE ON " + hiveTableName + " TO ROLE PUBLIC", new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (#\\E\\S+\\Q): line 1:1: Table " + hiveTableName + " is redirected to " + icebergTableName + " and DENY is not supported with table redirections");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + icebergTableName, new QueryExecutor.QueryParam[0]);
    }

    private static void createIcebergTable(String tableName, boolean partitioned) {
        TestHiveRedirectionToIceberg.createIcebergTable(tableName, partitioned, true);
    }

    private static void createIcebergTable(String tableName, boolean partitioned, boolean withData) {
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " " + (partitioned ? "WITH (partitioning = ARRAY['regionkey']) " : "") + " AS SELECT * FROM tpch.tiny.nation " + (withData ? "WITH DATA" : "WITH NO DATA"), new QueryExecutor.QueryParam[0]);
    }

    private static AbstractStringAssert<?> assertTableComment(String catalog, String schema, String tableName) {
        QueryResult queryResult = TestHiveRedirectionToIceberg.readTableComment(catalog, schema, tableName);
        return Assertions.assertThat((String)((String)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)queryResult.rows())))));
    }

    private static QueryResult readTableComment(String catalog, String schema, String tableName) {
        return QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = ? AND schema_name = ? AND table_name = ?", new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)catalog), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)schema), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)tableName)});
    }

    private static AbstractStringAssert<?> assertColumnComment(String catalog, String schema, String tableName, String columnName) {
        QueryResult queryResult = TestHiveRedirectionToIceberg.readColumnComment(catalog, schema, tableName, columnName);
        return Assertions.assertThat((String)((String)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)queryResult.rows())))));
    }

    private static QueryResult readColumnComment(String catalog, String schema, String tableName, String columnName) {
        return QueryExecutors.onTrino().executeQuery(String.format("SELECT comment FROM %s.information_schema.columns WHERE table_schema = ? AND table_name = ? AND column_name = ?", catalog), new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)schema), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)tableName), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)columnName)});
    }

    private static void assertResultsEqual(QueryResult first, QueryResult second) {
        QueryAssert.assertThat((QueryResult)first).containsOnly((List)second.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        QueryAssert.assertThat((QueryResult)second).containsOnly((List)first.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
    }
}

