/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.jdbc.Row;
import io.trino.jdbc.RowField;
import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestReadUniontype
extends HiveProductTest {
    private static final String TABLE_NAME = "test_read_uniontype";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void cleanup() {
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE IF EXISTS %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
    }

    @DataProvider(name="storage_formats")
    public static Object[][] storageFormats() {
        return new String[][]{{"ORC"}, {"AVRO"}};
    }

    private void createTestTable(String storageFormat) {
        this.cleanup();
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (id INT,foo UNIONTYPE<INT,DOUBLE,ARRAY<STRING>>)STORED AS %s", TABLE_NAME, storageFormat), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storage_formats", groups={"smoke"})
    public void testReadUniontype(String storageFormat) {
        if (this.getHiveVersionMajor() != 1 || this.getHiveVersionMinor() != 2) {
            throw new SkipException("This test can only be run with Hive 1.2 (default config)");
        }
        this.createTestTable(storageFormat);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT 0, create_union(0, CAST(36 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 1, create_union(1, CAST(NULL AS INT), CAST(7.2 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 2, create_union(2, CAST(NULL AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 3, create_union(1, CAST(NULL AS INT), CAST(10.8 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 4, create_union(0, CAST(144 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 5, create_union(2, CAST(NULL AS INT), CAST(NULL AS DOUBLE), ARRAY('hello', 'world'))", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO TABLE %s SELECT 6, create_union(0, CAST(180 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 7, create_union(1, CAST(NULL AS INT), CAST(21.6 AS DOUBLE), ARRAY('foo','bar')) UNION ALL SELECT 8, create_union(0, CAST(252 AS INT), CAST(NULL AS DOUBLE), ARRAY('foo','bar'))", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryResult selectAllResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assert.assertEquals((int)selectAllResult.rows().size(), (int)9);
        for (List row : selectAllResult.rows()) {
            int id = (Integer)row.get(0);
            switch (id) {
                case 0: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 36, null, null});
                    break;
                }
                case 1: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 7.2, null});
                    break;
                }
                case 2: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)2, null, null, Arrays.asList("foo", "bar")});
                    break;
                }
                case 3: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 10.8, null});
                    break;
                }
                case 4: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 144, null, null});
                    break;
                }
                case 5: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)2, null, null, Arrays.asList("hello", "world")});
                    break;
                }
                case 6: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 180, null, null});
                    break;
                }
                case 7: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)1, null, 21.6, null});
                    break;
                }
                case 8: {
                    TestReadUniontype.assertStructEquals(row.get(1), new Object[]{(byte)0, 252, null, null});
                }
            }
        }
    }

    private static void assertStructEquals(Object actual, Object[] expected) {
        Assertions.assertThat((Object)actual).isInstanceOf(Row.class);
        Row actualRow = (Row)actual;
        Assert.assertEquals((int)actualRow.getFields().size(), (int)expected.length);
        for (int i = 0; i < actualRow.getFields().size(); ++i) {
            Assert.assertEquals((Object)((RowField)actualRow.getFields().get(i)).getValue(), (Object)expected[i]);
        }
    }
}

