/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive.util;

import com.google.common.collect.Iterables;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TableLocationUtils {
    private static final Pattern ACID_LOCATION_PATTERN = Pattern.compile("(.*)/delta_[^/]+");

    private TableLocationUtils() {
    }

    public static String getTableLocation(String tableName) {
        return TableLocationUtils.getTableLocation(tableName, 0);
    }

    public static String getTableLocation(String tableName, int partitionColumns) {
        StringBuilder regex = new StringBuilder("/[^/]*$");
        for (int i = 0; i < partitionColumns; ++i) {
            regex.insert(0, "/[^/]*");
        }
        String tableLocation = (String)Iterables.getOnlyElement((Iterable)QueryExecutors.onTrino().executeQuery(String.format("SELECT DISTINCT regexp_replace(\"$path\", '%s', '') FROM %s", regex, tableName), new QueryExecutor.QueryParam[0]).column(1));
        Matcher acidLocationMatcher = ACID_LOCATION_PATTERN.matcher(tableLocation);
        if (acidLocationMatcher.matches()) {
            tableLocation = acidLocationMatcher.group(1);
        }
        return tableLocation;
    }

    public static String getTablePath(String tableName) throws URISyntaxException {
        return TableLocationUtils.getTablePath(tableName, 0);
    }

    public static String getTablePath(String tableName, int partitionColumns) throws URISyntaxException {
        String location = TableLocationUtils.getTableLocation(tableName, partitionColumns);
        URI uri = new URI(location);
        return uri.getPath();
    }
}

