/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.utils;

import io.trino.tempto.context.ThreadLocalTestContextHolder;
import io.trino.tempto.query.QueryExecutionException;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import java.sql.Connection;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;

public final class QueryExecutors {
    public static QueryExecutor onTrino() {
        return QueryExecutors.connectToTrino("presto");
    }

    public static QueryExecutor onCompatibilityTestServer() {
        return QueryExecutors.connectToTrino("compatibility-test-server");
    }

    @Deprecated
    public static QueryExecutor connectToPresto(String prestoConfig) {
        return QueryExecutors.connectToTrino(prestoConfig);
    }

    public static QueryExecutor connectToTrino(final String trinoConfig) {
        return new QueryExecutor(){
            private final QueryExecutor delegate;
            {
                this.delegate = (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, trinoConfig);
            }

            public QueryResult executeQuery(String sql, QueryExecutor.QueryParam ... params) throws QueryExecutionException {
                return (QueryResult)Failsafe.with((Policy[])new RetryPolicy[]{HiveProductTest.ERROR_COMMITTING_WRITE_TO_HIVE_RETRY_POLICY}).get(() -> this.delegate.executeQuery(sql, params));
            }

            public Connection getConnection() {
                return this.delegate.getConnection();
            }

            public void close() {
                this.delegate.close();
            }
        };
    }

    public static QueryExecutor onHive() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "hive");
    }

    public static QueryExecutor onSqlServer() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "sqlserver");
    }

    public static QueryExecutor onMySql() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "mysql");
    }

    public static QueryExecutor onSpark() {
        return (QueryExecutor)ThreadLocalTestContextHolder.testContext().getDependency(QueryExecutor.class, "spark");
    }

    private QueryExecutors() {
    }
}

