/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.cassandra;

import io.airlift.units.Duration;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.internal.fulfillment.table.TableName;
import io.trino.tempto.internal.query.CassandraQueryExecutor;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.cassandra.DataTypesTableDefinition;
import io.trino.tests.product.utils.QueryAssertions;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestInsertIntoCassandraTable
extends ProductTest
implements RequirementsProvider {
    private static final String CASSANDRA_INSERT_TABLE = "Insert_All_Types";
    private static final String CASSANDRA_MATERIALIZED_VIEW = "Insert_All_Types_Mview";
    private Configuration configuration;

    public Requirement getRequirements(Configuration configuration) {
        this.configuration = configuration;
        return TableRequirements.mutableTable((TableDefinition)DataTypesTableDefinition.CASSANDRA_ALL_TYPES, (String)CASSANDRA_INSERT_TABLE, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED);
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInsertIntoValuesToCassandraTableAllSimpleTypes() {
        TableName table = MutableTablesState.mutableTablesState().get(CASSANDRA_INSERT_TABLE).getTableName();
        String tableNameInDatabase = String.format("%s.%s", "cassandra", table.getNameInDatabase());
        QueryAssertions.assertContainsEventually(() -> QueryExecutors.onTrino().executeQuery(String.format("SHOW TABLES FROM %s.%s", "cassandra", "test"), new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery(String.format("SELECT '%s'", table.getSchemalessNameInDatabase()), new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryResult queryResult = QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableNameInDatabase, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)queryResult).hasNoRows();
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableNameInDatabase + "(a, b, bl, bo, d, do, dt, f, fr, i, ti, si, integer, l, m, s, t, ts, tu, u, v, vari) VALUES ('ascii value', BIGINT '99999', null, true, null, 123.456789, DATE '9999-12-31',REAL '123.45678', null, null, TINYINT '-128', SMALLINT '-32768', 123, null, null, null, 'text value', timestamp '9999-12-31 23:59:59Z',uuid '50554d6e-29bb-11e5-b345-feff819cdc9f', uuid '12151fd2-7586-11e9-8f9e-2a86e4085a59', 'varchar value',null)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableNameInDatabase, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"ascii value", 99999, null, true, null, 123.456789, Date.valueOf("9999-12-31"), 123.45678, null, null, 123, null, null, null, Short.MIN_VALUE, "text value", -128, Timestamp.from(OffsetDateTime.of(9999, 12, 31, 23, 59, 59, 0, ZoneOffset.UTC).toInstant()), "50554d6e-29bb-11e5-b345-feff819cdc9f", "12151fd2-7586-11e9-8f9e-2a86e4085a59", "varchar value", null})});
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableNameInDatabase + "(a, b, bl, bo, d, do, dt, f, fr, i, ti, si, integer, l, m, s, t, ts, tu, u, v, vari) VALUES ('key 1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null) ", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s WHERE a = 'key 1'", tableNameInDatabase), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"key 1", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null})});
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (a, bo, integer, t) VALUES ('key 2', false, 999, 'text 2')", tableNameInDatabase), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s WHERE a = 'key 2'", tableNameInDatabase), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"key 2", null, null, false, null, null, null, null, null, null, 999, null, null, null, null, "text 2", null, null, null, null, null, null})});
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (a) VALUES (null) ", tableNameInDatabase), new QueryExecutor.QueryParam[0])).hasMessageContaining("Invalid null value in condition for column a");
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInsertIntoValuesToCassandraMaterizedView() {
        TableName table = MutableTablesState.mutableTablesState().get(CASSANDRA_INSERT_TABLE).getTableName();
        this.onCasssandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", CASSANDRA_MATERIALIZED_VIEW));
        this.onCasssandra(String.format("CREATE MATERIALIZED VIEW %s.%s AS SELECT * FROM %s WHERE b IS NOT NULL PRIMARY KEY (a, b) WITH CLUSTERING ORDER BY (integer DESC)", "test", CASSANDRA_MATERIALIZED_VIEW, table.getNameInDatabase()));
        QueryAssertions.assertContainsEventually(() -> QueryExecutors.onTrino().executeQuery(String.format("SHOW TABLES FROM %s.%s", "cassandra", "test"), new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery(String.format("SELECT lower('%s')", CASSANDRA_MATERIALIZED_VIEW), new QueryExecutor.QueryParam[0]), new Duration(1.0, TimeUnit.MINUTES));
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s.%s.%s (a) VALUES (null) ", "cassandra", "test", CASSANDRA_MATERIALIZED_VIEW), new QueryExecutor.QueryParam[0])).hasMessageContaining("Inserting into materialized views not yet supported");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s.%s.%s", "cassandra", "test", CASSANDRA_MATERIALIZED_VIEW), new QueryExecutor.QueryParam[0])).hasMessageContaining("Dropping materialized views not yet supported");
        this.onCasssandra(String.format("DROP MATERIALIZED VIEW IF EXISTS %s.%s", "test", CASSANDRA_MATERIALIZED_VIEW));
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInsertIntoTupleType() {
        String tableName = "insert_tuple_table";
        this.onCasssandra(String.format("DROP TABLE IF EXISTS %s.%s", "test", tableName));
        this.onCasssandra(String.format("CREATE TABLE %s.%s (key int, value frozen<tuple<int, text, float>>, PRIMARY KEY (key))", "test", tableName));
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s.%s.%s (key, value) VALUES (1, ROW(1, 'text-1', 1.11))", "cassandra", "test", tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Unsupported column type: row(integer, varchar, real)");
        this.onCasssandra(String.format("DROP TABLE IF EXISTS %s.%s", "test", tableName));
    }

    private void onCasssandra(String query) {
        CassandraQueryExecutor queryExecutor = new CassandraQueryExecutor(this.configuration);
        queryExecutor.executeQuery(query);
        queryExecutor.close();
    }
}

