/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.trino.tempto.query.QueryExecutor;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.hive.BaseTestSyncPartitionMetadata;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Objects;
import org.apache.parquet.Strings;
import org.testng.annotations.Test;

public class TestAbfsSyncPartitionMetadata
extends BaseTestSyncPartitionMetadata {
    private final String schema = "test_" + TemporaryHiveTable.randomTableSuffix();

    @Override
    protected String schemaLocation() {
        String container = Objects.requireNonNull(System.getenv("ABFS_CONTAINER"), "Environment variable not set: ABFS_CONTAINER");
        String account = Objects.requireNonNull(System.getenv("ABFS_ACCOUNT"), "Environment variable not set: ABFS_ACCOUNT");
        return String.format("abfs://%s@%s.dfs.core.windows.net/%s", container, account, this.schema);
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testAddPartition() {
        super.testAddPartition();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testAddPartitionContainingCharactersThatNeedUrlEncoding() {
        super.testAddPartitionContainingCharactersThatNeedUrlEncoding();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testDropPartition() {
        super.testDropPartition();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testDropPartitionContainingCharactersThatNeedUrlEncoding() {
        super.testDropPartitionContainingCharactersThatNeedUrlEncoding();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testFullSyncPartition() {
        super.testFullSyncPartition();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testInvalidSyncMode() {
        super.testInvalidSyncMode();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testMixedCasePartitionNames() {
        super.testMixedCasePartitionNames();
    }

    @Override
    @Test(groups={"azure"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testConflictingMixedCasePartitionNames() {
        super.testConflictingMixedCasePartitionNames();
    }

    @Override
    protected void removeHdfsDirectory(String path) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) && !path.equals("/") ? 1 : 0) != 0);
        QueryExecutors.onHive().executeQuery("dfs -rm -f -r " + path, new QueryExecutor.QueryParam[0]);
    }

    @Override
    protected void makeHdfsDirectory(String path) {
        QueryExecutors.onHive().executeQuery("dfs -mkdir -p " + path, new QueryExecutor.QueryParam[0]);
    }

    @Override
    protected void copyOrcFileToHdfsDirectory(String tableName, String targetDirectory) {
        String orcFilePath = this.generateOrcFile();
        QueryExecutors.onHive().executeQuery(String.format("dfs -cp %s %s", orcFilePath, targetDirectory), new QueryExecutor.QueryParam[0]);
    }

    private String generateOrcFile() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS single_int_column", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE single_int_column (payload bigint) WITH (format = 'ORC')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO single_int_column VALUES (42)", new QueryExecutor.QueryParam[0]);
        return Iterables.getOnlyElement((Iterable)QueryExecutors.onTrino().executeQuery("SELECT \"$path\" FROM single_int_column", new QueryExecutor.QueryParam[0]).row(0)).toString();
    }
}

