/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestComments
extends ProductTest {
    private static final String COMMENT_TABLE_NAME = "comment_test";
    private static final String COMMENT_COLUMN_NAME = "comment_column_test";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTable() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS comment_test", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS comment_column_test", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"comment"})
    public void testCommentTable() {
        String createTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT 'old comment'\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutors.onTrino().executeQuery(createTableSql, new QueryExecutor.QueryParam[0]);
        QueryResult actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)this.tableWithCommentPattern(COMMENT_TABLE_NAME, Optional.of("old comment")));
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS 'new comment'", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)this.tableWithCommentPattern(COMMENT_TABLE_NAME, Optional.of("new comment")));
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS ''", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)this.tableWithCommentPattern(COMMENT_TABLE_NAME, Optional.of("")));
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS NULL", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)this.tableWithCommentPattern(COMMENT_TABLE_NAME, Optional.empty()));
    }

    private String tableWithCommentPattern(String tableName, Optional<String> expectedComment) {
        return String.format("CREATE TABLE hive.default.\\Q%s\\E \\((?s:[^)]+)\\)\n", tableName) + expectedComment.map(comment -> "COMMENT '" + comment + "'\n").orElse("") + "WITH(?s:.*)";
    }

    @Test(groups={"comment"})
    public void testCommentColumn() {
        String createTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'test comment',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_COLUMN_NAME);
        QueryExecutors.onTrino().executeQuery(createTableSql, new QueryExecutor.QueryParam[0]);
        String createTableSqlPattern = String.format("\\QCREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'test comment',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\\E(?s:.*)", COMMENT_COLUMN_NAME);
        QueryResult actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_column_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)createTableSqlPattern);
        createTableSqlPattern = String.format("\\QCREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'new comment',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\\E(?s:.*)", COMMENT_COLUMN_NAME);
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS 'new comment'", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_column_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)createTableSqlPattern);
        createTableSqlPattern = String.format("\\QCREATE TABLE hive.default.%s (\n   c1 bigint COMMENT '',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\\E(?s:.*)", COMMENT_COLUMN_NAME);
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS ''", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_column_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)createTableSqlPattern);
        createTableSqlPattern = String.format("\\QCREATE TABLE hive.default.%s (\n   c1 bigint,\n   c2 bigint COMMENT '',\n   c3 bigint\n)\\E(?s:.*)", COMMENT_COLUMN_NAME);
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS NULL", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_column_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)createTableSqlPattern);
    }
}

