/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.AbstractTestHiveViews;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class, ImmutableTpchTablesRequirements.ImmutableOrdersTable.class})
public class TestHiveViews
extends AbstractTestHiveViews {
    @Test(groups={"hive_views"})
    public void testFailingHiveViewsWithMetadataListing() {
        TestHiveViews.setupBrokenView();
        this.testFailingHiveViewsWithInformationSchema();
        this.testFailingHiveViewsWithSystemJdbc();
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_list_failing_views CASCADE", new QueryExecutor.QueryParam[0]);
    }

    private void testFailingHiveViewsWithInformationSchema() {
        String withSchemaFilter = "SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views'";
        String withNoFilter = "SELECT table_name FROM information_schema.views";
        if (this.getHiveVersionMajor() == 3) {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(withSchemaFilter, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(withNoFilter, new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        } else {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(withSchemaFilter, new QueryExecutor.QueryParam[0])).hasNoRows();
            Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery(withNoFilter, new QueryExecutor.QueryParam[0]).rows()).doesNotContain((Object[])new List[]{ImmutableList.of((Object)"correct_view")});
        }
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views' AND table_name = 'correct_view'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT table_name FROM information_schema.views WHERE table_schema = 'test_list_failing_views' AND table_name = 'failing_view'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Failed to translate Hive view 'test_list_failing_views.failing_view'");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = 'test_list_failing_views'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_name"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_comment"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view", "col0"})});
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM information_schema.columns WHERE table_schema = 'test_list_failing_views' AND table_name = 'failing_view'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Failed to translate Hive view 'test_list_failing_views.failing_view'");
    }

    private void testFailingHiveViewsWithSystemJdbc() {
        String withSchemaFilter = "SELECT table_name FROM system.jdbc.tables WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views' AND table_type = 'VIEW'";
        String withNoFilter = "SELECT table_name FROM system.jdbc.tables WHERE table_cat = 'hive' AND table_type = 'VIEW'";
        if (this.getHiveVersionMajor() == 3) {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(withSchemaFilter, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(withNoFilter, new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view"})});
        } else {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(withSchemaFilter, new QueryExecutor.QueryParam[0])).hasNoRows();
            Assertions.assertThat((List)QueryExecutors.onTrino().executeQuery(withNoFilter, new QueryExecutor.QueryParam[0]).rows()).doesNotContain((Object[])new List[]{ImmutableList.of((Object)"correct_view")});
        }
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT table_name FROM system.jdbc.tables WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views' AND table_name = 'correct_view'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view"})});
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT table_name FROM system.jdbc.tables WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views' AND table_name = 'failing_view'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Failed to translate Hive view 'test_list_failing_views.failing_view'");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT table_name, column_name FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_name"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"correct_view", "n_comment"}), QueryAssert.Row.row((Object[])new Object[]{"failing_view", "col0"})});
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM system.jdbc.columns WHERE table_cat = 'hive' AND table_schem = 'test_list_failing_views' AND table_name = 'failing_view'", new QueryExecutor.QueryParam[0])).hasMessageContaining("Failed to translate Hive view 'test_list_failing_views.failing_view'");
    }

    private static void setupBrokenView() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_list_failing_views CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_list_failing_views", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_list_failing_views.correct_view AS SELECT * FROM nation limit 5", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_list_failing_views.table_dropped (col0 BIGINT)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_list_failing_views.failing_view AS SELECT * FROM test_list_failing_views.table_dropped", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE test_list_failing_views.table_dropped", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_views"})
    public void testLateralViewExplode() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS pageAds", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE pageAds(pageid, adid_list) WITH (format='TEXTFILE') AS VALUES   (VARCHAR 'two', ARRAY[11, 22]),   ('nothing', NULL),   ('zero', ARRAY[]),   ('one', ARRAY[42])", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view as SELECT pageid, adid FROM pageAds LATERAL VIEW explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT * FROM hive_lateral_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11}), QueryAssert.Row.row((Object[])new Object[]{"two", 22}), QueryAssert.Row.row((Object[])new Object[]{"one", 42})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view_outer_explode", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view_outer_explode as SELECT pageid, adid FROM pageAds LATERAL VIEW OUTER explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT * FROM hive_lateral_view_outer_explode", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11}), QueryAssert.Row.row((Object[])new Object[]{"two", 22}), QueryAssert.Row.row((Object[])new Object[]{"one", 42}), QueryAssert.Row.row((Object[])new Object[]{"nothing", null}), QueryAssert.Row.row((Object[])new Object[]{"zero", null})}));
    }

    @Test(groups={"hive_views"})
    public void testLateralViewExplodeArrayOfStructs() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS pageAdsStructs", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE pageAdsStructs(pageid VARCHAR, adid_list ARRAY(ROW(a INTEGER, b INTEGER))) WITH (format='TEXTFILE')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO pageAdsStructs VALUES   ('two', ARRAY[ROW(11, 12), ROW(13, 14)]),   ('nothing', NULL),   ('zero', ARRAY[]),   ('one', ARRAY[ROW(42, 43)])", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view_structs", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view_structs as SELECT pageid, adid FROM pageAdsStructs LATERAL VIEW explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT pageid, adid.a, adid.b FROM hive_lateral_view_structs", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11, 12}), QueryAssert.Row.row((Object[])new Object[]{"two", 13, 14}), QueryAssert.Row.row((Object[])new Object[]{"one", 42, 43})}));
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_lateral_view_structs_outer_explode", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_lateral_view_structs_outer_explode as SELECT pageid, adid FROM pageAdsStructs LATERAL VIEW OUTER explode(adid_list) adTable AS adid", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT pageid, adid.a, adid.b FROM hive_lateral_view_structs_outer_explode", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"two", 11, 12}), QueryAssert.Row.row((Object[])new Object[]{"two", 13, 14}), QueryAssert.Row.row((Object[])new Object[]{"one", 42, 43}), QueryAssert.Row.row((Object[])new Object[]{"nothing", null, null}), QueryAssert.Row.row((Object[])new Object[]{"zero", null, null})}));
    }

    @Test(groups={"hive_views"})
    public void testLateralViewJsonTupleAs() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_json_tuple_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_json_tuple_table WITH (format='TEXTFILE') AS SELECT 3 id, CAST('{\"user_id\": 1000, \"first.name\": \"Mateusz\", \"Last Name\": \"Gajewski\", \".NET\": true, \"aNull\": null}' AS varchar) jsonstr", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_json_tuple_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_json_tuple_view AS SELECT `t`.`id`, `x`.`a`, `x`.`b`, `x`.`c`, `x`.`d`, `x`.`e`, `x`.`f` FROM test_json_tuple_table AS `t` LATERAL VIEW json_tuple(`t`.`jsonstr`, \"first.name\", \"Last Name\", '.NET', \"user_id\", \"aNull\", \"nonexistentField\") `x` AS `a`, `b`, `c`, `d`, `e`, `f`", new QueryExecutor.QueryParam[0]);
        TestHiveViews.assertViewQuery("SELECT * FROM test_json_tuple_view", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3, "Mateusz", "Gajewski", "true", "1000", null, null})}));
    }

    @Test(groups={"hive_views"})
    public void testFromUtcTimestamp() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_from_utc_timestamp_source", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_from_utc_timestamp_source (  source_tinyint tinyint,   source_smallint smallint,   source_integer int,   source_bigint bigint,   source_float float,   source_double double,   source_decimal_three decimal(10,3),   source_decimal_zero decimal(10,0),   source_timestamp timestamp,   source_date date)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_from_utc_timestamp_source VALUES (   123,   10123,   259200123,   2592000123,   2592000.0,   2592000.123,   2592000.123,  2592000,  timestamp '1970-01-30 16:00:00.000',   date '1970-01-30')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_from_utc_timestamp_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_from_utc_timestamp_view AS SELECT    CAST(from_utc_timestamp(source_tinyint, 'America/Los_Angeles') AS STRING) ts_tinyint,    CAST(from_utc_timestamp(source_smallint, 'America/Los_Angeles') AS STRING) ts_smallint,    CAST(from_utc_timestamp(source_integer, 'America/Los_Angeles') AS STRING) ts_integer,    CAST(from_utc_timestamp(source_bigint, 'America/Los_Angeles') AS STRING) ts_bigint,    CAST(from_utc_timestamp(source_float, 'America/Los_Angeles') AS STRING) ts_float,    CAST(from_utc_timestamp(source_double, 'America/Los_Angeles') AS STRING) ts_double,    CAST(from_utc_timestamp(source_decimal_three, 'America/Los_Angeles') AS STRING) ts_decimal_three,    CAST(from_utc_timestamp(source_decimal_zero, 'America/Los_Angeles') AS STRING) ts_decimal_zero,    CAST(from_utc_timestamp(source_timestamp, 'America/Los_Angeles') AS STRING) ts_timestamp,    CAST(from_utc_timestamp(source_date, 'America/Los_Angeles') AS STRING) ts_date FROM test_from_utc_timestamp_source", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_from_utc_timestamp_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 16:00:00.123", "1969-12-31 16:00:10.123", "1970-01-03 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.000", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.000", "1970-01-30 08:00:00.000", "1970-01-29 16:00:00.000"})});
        if (this.isObsoleteFromUtcTimestampSemantics()) {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM test_from_utc_timestamp_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 21:30:00.123", "1969-12-31 21:30:10.123", "1970-01-03 21:30:00.123", "1970-01-30 21:30:00.123", "1970-01-30 21:30:00", "1970-01-30 21:30:00.123", "1970-01-30 21:30:00.123", "1970-01-30 21:30:00", "1970-01-30 08:00:00", "1970-01-29 16:00:00"})});
        } else {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM test_from_utc_timestamp_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 16:00:00.123", "1969-12-31 16:00:10.123", "1970-01-03 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00.123", "1970-01-30 16:00:00", "1970-01-30 08:00:00", "1970-01-29 16:00:00"})});
        }
    }

    @Test(groups={"hive_views"})
    public void testFromUtcTimestampCornerCases() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS test_from_utc_timestamp_corner_cases_source", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_from_utc_timestamp_corner_cases_source AS SELECT * FROM (VALUES   CAST(-5000000000001 AS BIGINT),  CAST(-1000000000001 AS BIGINT),  -1,  1,  5000000000001)AS source(source_bigint)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS test_from_utc_timestamp_corner_cases_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_from_utc_timestamp_corner_cases_view AS SELECT    CAST(from_utc_timestamp(source_bigint, 'America/Los_Angeles') as STRING) ts_bigint FROM test_from_utc_timestamp_corner_cases_source", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_from_utc_timestamp_corner_cases_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1811-07-23 07:13:41.999"}), QueryAssert.Row.row((Object[])new Object[]{"1938-04-24 14:13:19.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 15:59:59.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 16:00:00.001"}), QueryAssert.Row.row((Object[])new Object[]{"2128-06-11 01:53:20.001"})});
        if (this.isObsoleteFromUtcTimestampSemantics()) {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM test_from_utc_timestamp_corner_cases_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1811-07-23 12:51:39.999"}), QueryAssert.Row.row((Object[])new Object[]{"1938-04-24 19:43:19.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 21:29:59.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 21:30:00.001"}), QueryAssert.Row.row((Object[])new Object[]{"2128-06-11 07:38:20.001"})});
        } else {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM test_from_utc_timestamp_corner_cases_view", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1811-07-23 07:13:41.999"}), QueryAssert.Row.row((Object[])new Object[]{"1938-04-24 14:13:19.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 15:59:59.999"}), QueryAssert.Row.row((Object[])new Object[]{"1969-12-31 16:00:00.001"}), QueryAssert.Row.row((Object[])new Object[]{"2128-06-11 01:53:20.001"})});
        }
    }

    private boolean isObsoleteFromUtcTimestampSemantics() {
        return this.getHiveVersionMajor() < 3 || this.getHiveVersionMajor() == 3 && this.getHiveVersionMinor() < 1;
    }

    @Test(groups={"hive_views"})
    public void testCastTimestampAsDecimal() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS cast_timestamp_as_decimal", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE cast_timestamp_as_decimal (a_timestamp TIMESTAMP)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO cast_timestamp_as_decimal VALUES ('1990-01-02 12:13:14.123456789')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS cast_timestamp_as_decimal_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW cast_timestamp_as_decimal_view AS SELECT CAST(a_timestamp as DECIMAL(10,0)) a_cast_timestamp FROM cast_timestamp_as_decimal", new QueryExecutor.QueryParam[0]);
        String testQuery = "SELECT * FROM cast_timestamp_as_decimal_view";
        if (this.getHiveVersionMajor() > 3 || this.getHiveVersionMajor() == 3 && this.getHiveVersionMinor() >= 1) {
            TestHiveViews.assertViewQuery(testQuery, queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("631282394")})}));
        } else {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(testQuery, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("631282394")})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery(testQuery, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("631261694")})});
        }
        QueryExecutors.onHive().executeQuery("DROP VIEW cast_timestamp_as_decimal_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE cast_timestamp_as_decimal", new QueryExecutor.QueryParam[0]);
    }
}

