/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.AbstractTestHiveViews;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class, ImmutableTpchTablesRequirements.ImmutableOrdersTable.class})
public class TestHiveViewsLegacy
extends AbstractTestHiveViews {
    @BeforeTestWithContext
    public void setup() {
        this.setSessionProperty("hive.hive_views_legacy_translation", "true");
    }

    @Override
    @Test(groups={"hive_views"})
    public void testShowCreateView() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_show_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_show_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW CREATE VIEW hive_show_view", new QueryExecutor.QueryParam[0])).hasRowsCount(1);
    }

    @Override
    @Test(groups={"hive_views"})
    public void testHiveViewInInformationSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_schema CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_schema", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW test_schema.hive_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_schema.hive_table(a string)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_schema.trino_table(a int)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE VIEW test_schema.trino_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        boolean hiveWithTableNamesByType = this.getHiveVersionMajor() >= 3 || this.getHiveVersionMajor() == 2 && this.getHiveVersionMinor() >= 3;
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM information_schema.tables WHERE table_schema = 'test_schema'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "trino_table", "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "hive_table", "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "hive_test_view", hiveWithTableNamesByType ? "VIEW" : "BASE TABLE"}), QueryAssert.Row.row((Object[])new Object[]{"hive", "test_schema", "trino_test_view", "VIEW"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT view_definition FROM information_schema.views WHERE table_schema = 'test_schema' and table_name = 'hive_test_view'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"SELECT \"nation\".\"n_nationkey\", \"nation\".\"n_name\", \"nation\".\"n_regionkey\", \"nation\".\"n_comment\" FROM \"default\".\"nation\""})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("DESCRIBE test_schema.hive_test_view", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"n_nationkey", "bigint", "", ""})});
    }

    @Override
    @Test(groups={"hive_views"})
    public void testHiveViewWithParametrizedTypes() {
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS hive_view_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS hive_table_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE hive_table_parametrized(a decimal(20,4), b bigint, c varchar(20))", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE VIEW hive_view_parametrized AS SELECT * FROM hive_table_parametrized", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO TABLE hive_table_parametrized VALUES (1.2345, 42, 'bar')", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.hive_view_parametrized", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{new BigDecimal("1.2345"), 42, "bar"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT data_type FROM information_schema.columns WHERE table_name = 'hive_view_parametrized'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"decimal(20,4)"}), QueryAssert.Row.row((Object[])new Object[]{"bigint"}), QueryAssert.Row.row((Object[])new Object[]{"varchar(20)"})});
    }

    @Override
    @Test
    public void testArrayIndexingInView() {
        Assertions.assertThatThrownBy(() -> super.testArrayIndexingInView()).hasMessageContaining("Could not find rows:\n[hive]\n\nactual rows:\n[presto]");
    }

    @Override
    public void testArrayConstructionInView() {
        Assertions.assertThatThrownBy(() -> super.testArrayConstructionInView()).hasMessageContaining("Function 'array' not registered");
    }

    @Override
    public void testMapConstructionInView() {
        Assertions.assertThatThrownBy(() -> super.testMapConstructionInView()).hasMessageContaining("Unexpected parameters (varchar(15), varchar(15)) for function map");
    }

    @Override
    public void testPmodFunction() {
        Assertions.assertThatThrownBy(() -> super.testPmodFunction()).hasMessageContaining("Function 'pmod' not registered");
    }

    @Override
    public void testNestedHiveViews() {
        Assertions.assertThatThrownBy(() -> super.testNestedHiveViews()).hasMessageContaining("View 'hive.default.nested_top_view' is stale or in invalid state: column [n_renamed] of type varchar projected from query view at position 0 cannot be coerced to column [n_renamed] of type varchar(25) stored in view definition");
    }

    @Override
    @Test
    public void testCurrentUser() {
        Assertions.assertThatThrownBy(() -> super.testCurrentUser()).hasMessageContaining("Failed parsing stored view 'hive.default.current_user_hive_view': line 1:20: mismatched input '('");
    }

    @Override
    protected QueryExecutor connectToTrino(String catalog) {
        QueryExecutor executor = super.connectToTrino(catalog);
        executor.executeQuery("SET SESSION hive.hive_views_legacy_translation = true", new QueryExecutor.QueryParam[0]);
        return executor;
    }
}

