/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.log.Logger;
import io.trino.plugin.hive.authentication.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.NoHiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.Transport;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.Table;
import org.testng.annotations.Test;

public class TestDatabricksCompatibilityCleanUp
extends ProductTest {
    private static final Logger log = Logger.get(TestDatabricksCompatibilityCleanUp.class);
    private static final long SCHEMA_CLEANUP_THRESHOLD_SECONDS = System.currentTimeMillis() / 1000L - TimeUnit.DAYS.toSeconds(7L);
    private static final long MAX_JOB_TIME_MILLIS = TimeUnit.MINUTES.toMillis(5L);

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testCleanUpOldTablesUsingDelta() throws Exception {
        String hiveMetastoreUri = Objects.requireNonNull(System.getenv("HIVE_METASTORE_URI"), "Environment HIVE_METASTORE_URI was not set");
        URI metastoreUri = URI.create(hiveMetastoreUri);
        long startTime = System.currentTimeMillis();
        List<String> schemas = QueryExecutors.onTrino().executeQuery("SELECT DISTINCT(table_schema) FROM information_schema.tables", new QueryExecutor.QueryParam[0]).rows().stream().map(row -> (String)row.get(0)).filter(schema -> schema.toLowerCase(Locale.ROOT).startsWith("test") || schema.equals("default")).collect(Collectors.toUnmodifiableList());
        try (ThriftHiveMetastoreClient thriftHiveMetastoreClient = new ThriftHiveMetastoreClient(Transport.create((HostAndPort)HostAndPort.fromParts((String)metastoreUri.getHost(), (int)metastoreUri.getPort()), Optional.empty(), Optional.empty(), (int)100000, (HiveMetastoreAuthentication)new NoHiveMetastoreAuthentication(), Optional.empty()), metastoreUri.getHost());){
            QueryExecutors.onTrino().executeQuery("SET SESSION hive.hive_views_legacy_translation = true", new QueryExecutor.QueryParam[0]);
            schemas.forEach(schema -> this.cleanSchema((String)schema, startTime, thriftHiveMetastoreClient));
        }
    }

    private void cleanSchema(String schema, long startTime, ThriftHiveMetastoreClient thriftHiveMetastoreClient) {
        Set<String> allTableNames = this.findAllTestTablesInSchema(schema);
        int droppedTablesCount = 0;
        for (String tableName : allTableNames) {
            try {
                Table table = thriftHiveMetastoreClient.getTable(schema, tableName);
                int createTime = table.getCreateTime();
                if ((long)createTime <= SCHEMA_CLEANUP_THRESHOLD_SECONDS) {
                    if (table.getTableType() != null && table.getTableType().contains("VIEW")) {
                        QueryExecutors.onTrino().executeQuery(String.format("DROP VIEW IF EXISTS %s.%s", schema, tableName), new QueryExecutor.QueryParam[0]);
                        log.info("Dropped view %s.%s", new Object[]{schema, tableName});
                    } else {
                        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s.%s", schema, tableName), new QueryExecutor.QueryParam[0]);
                        log.info("Dropped table %s.%s", new Object[]{schema, tableName});
                    }
                    ++droppedTablesCount;
                }
                if (System.currentTimeMillis() - startTime <= MAX_JOB_TIME_MILLIS) continue;
                break;
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Exception while dropping table %s.%s", new Object[]{schema, tableName});
            }
        }
        log.info("Dropped %d tables in schema %s", new Object[]{droppedTablesCount, schema});
        if (!schema.equals("default") && QueryExecutors.onTrino().executeQuery(String.format("SHOW TABLES IN %s", schema), new QueryExecutor.QueryParam[0]).getRowsCount() == 0) {
            try {
                QueryExecutors.onTrino().executeQuery("DROP SCHEMA IF EXISTS " + schema, new QueryExecutor.QueryParam[0]);
                log.info("Dropped schema %s", new Object[]{schema});
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Tried to delete schema %s but failed", new Object[]{schema});
            }
        }
    }

    private Set<String> findAllTestTablesInSchema(String schema) {
        try {
            QueryResult allTables = QueryExecutors.onTrino().executeQuery(String.format("SHOW TABLES IN %s", schema), new QueryExecutor.QueryParam[0]);
            log.info("Found %d potential tables to drop in schema %s", new Object[]{allTables.rows().size(), schema});
            return allTables.rows().stream().map(row -> (String)row.get(0)).filter(name -> name.toLowerCase(Locale.ROOT).startsWith("test")).collect(Collectors.toUnmodifiableSet());
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception while fetching tables for schema %s", new Object[]{schema});
            return ImmutableSet.of();
        }
    }
}

