/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksUpdates
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testUpdatesFromDatabricks() {
        String tableName = "test_updates_" + TemporaryHiveTable.randomTableSuffix();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default.\"" + tableName + "\" (id, value) WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "') AS VALUES   (1, 'Poland'), (2, 'Germany'), (3, 'Romania')", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
        try {
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsExactly(TestDeltaLakeDatabricksUpdates.toRows(prestoResult));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'France' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{-1})});
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsExactly(TestDeltaLakeDatabricksUpdates.toRows(prestoResult));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'Spain' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{-1})});
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsExactly(TestDeltaLakeDatabricksUpdates.toRows(prestoResult));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'Portugal' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{-1})});
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsExactly(TestDeltaLakeDatabricksUpdates.toRows(prestoResult));
        }
        catch (Throwable throwable) {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{-1})});
            throw throwable;
        }
        QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0])).containsExactly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{-1})});
    }

    private static List<QueryAssert.Row> toRows(QueryResult result) {
        return (List)result.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList());
    }
}

