/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.S3ClientFactory;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeltaLakeDropTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    private static final Engine TRINO_ENGINE = new TrinoEngine();
    private static final Engine DATABRICKS_ENGINE = new DatabricksEngine();
    @Inject
    @Named(value="s3.server_type")
    private String s3ServerType;
    private AmazonS3 s3;

    @BeforeTestWithContext
    public void setup() {
        super.setUp();
        this.s3 = new S3ClientFactory().createS3Client(this.s3ServerType);
    }

    @DataProvider
    public static Object[][] engineConfigurations() {
        return new Object[][]{{TRINO_ENGINE, TRINO_ENGINE, true}, {TRINO_ENGINE, TRINO_ENGINE, false}, {TRINO_ENGINE, DATABRICKS_ENGINE, true}, {TRINO_ENGINE, DATABRICKS_ENGINE, false}, {DATABRICKS_ENGINE, TRINO_ENGINE, true}, {DATABRICKS_ENGINE, TRINO_ENGINE, false}, {DATABRICKS_ENGINE, DATABRICKS_ENGINE, true}, {DATABRICKS_ENGINE, DATABRICKS_ENGINE, false}};
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"}, dataProvider="engineConfigurations")
    public void testDatabricksManagedTableDroppedFromTrino(Engine creator, Engine dropper, boolean explicitLocation) {
        this.testCleanupOnDrop(creator, dropper, explicitLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCleanupOnDrop(Engine creator, Engine dropper, boolean explicitLocation) {
        String schemaName = "schema_with_location_" + TemporaryHiveTable.randomTableSuffix();
        String tableName = explicitLocation ? "external_table" : "managed_table";
        creator.createSchema(schemaName, String.format("s3://%s/databricks-compatibility-test-%s", this.bucketName, schemaName));
        try {
            QueryExecutors.onTrino().executeQuery("USE delta." + schemaName, new QueryExecutor.QueryParam[0]);
            String tableLocation = explicitLocation ? String.format("s3://" + this.bucketName + "/databricks-compatibility-test-%s/%s", schemaName, tableName) : "";
            creator.createTable(schemaName, tableName, tableLocation);
            ObjectListing tableFiles = this.s3.listObjects(this.bucketName, "databricks-compatibility-test-" + schemaName + "/" + tableName);
            Assertions.assertThat((List)tableFiles.getObjectSummaries()).isNotEmpty();
            dropper.dropTable(schemaName, tableName);
            tableFiles = this.s3.listObjects(this.bucketName, "databricks-compatibility-test-" + schemaName + "/" + tableName);
            if (explicitLocation) {
                Assertions.assertThat((List)tableFiles.getObjectSummaries()).isNotEmpty();
            } else {
                Assertions.assertThat((List)tableFiles.getObjectSummaries()).isEmpty();
            }
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE IF EXISTS " + schemaName + "." + tableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
        }
    }

    private static class DatabricksEngine
    implements Engine {
        private DatabricksEngine() {
        }

        @Override
        public void createSchema(String schemaName, String location) {
            QueryExecutors.onDelta().executeQuery(String.format("CREATE SCHEMA %s LOCATION \"%s\"", schemaName, location), new QueryExecutor.QueryParam[0]);
        }

        @Override
        public void createTable(String schemaName, String tableName, String location) {
            Object locationStatement = location.isEmpty() ? "" : "LOCATION \"" + location + "\"";
            QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE %s.%s USING DELTA %s AS VALUES (1, 2), (2, 3), (3, 4)", schemaName, tableName, locationStatement), new QueryExecutor.QueryParam[0]);
        }

        @Override
        public void dropTable(String schemaName, String tableName) {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + schemaName + "." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    private static class TrinoEngine
    implements Engine {
        private TrinoEngine() {
        }

        @Override
        public void createSchema(String schemaName, String location) {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE SCHEMA delta.%s WITH (location = '%s')", schemaName, location), new QueryExecutor.QueryParam[0]);
        }

        @Override
        public void createTable(String schemaName, String tableName, String location) {
            Object locationStatement = location.isEmpty() ? "" : "WITH (location = '" + location + "')";
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s.%s (a, b) %s AS VALUES (1, 2), (2, 3), (3, 4)", schemaName, tableName, locationStatement), new QueryExecutor.QueryParam[0]);
        }

        @Override
        public void dropTable(String schemaName, String tableName) {
            QueryExecutors.onTrino().executeQuery("DROP TABLE " + schemaName + "." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    private static interface Engine {
        public void createSchema(String var1, String var2);

        public void createTable(String var1, String var2, String var3);

        public void dropTable(String var1, String var2);
    }
}

