/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestTablePartitioningWithSpecialChars
extends ProductTest {
    private static final String INSERTED_PARTITION_VALUES = "(1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslashes'),(6, 'with\\backslash'),(7, 'with=equal'),(8, 'with?question'),(9, 'with!exclamation'),(10, 'with%%percent'),(11, 'with%%%%percents'),(12, 'with space')";
    private static final ImmutableList<QueryAssert.Row> EXPECTED_PARTITION_VALUES = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, "with-hyphen"}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, "with.dot"}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, "with:colon"}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, "with/slash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "with\\\\backslashes"}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, "with\\backslash"}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, "with=equal"}), (Object)QueryAssert.Row.row((Object[])new Object[]{8, "with?question"}), (Object)QueryAssert.Row.row((Object[])new Object[]{9, "with!exclamation"}), (Object)QueryAssert.Row.row((Object[])new Object[]{10, "with%percent"}), (Object)QueryAssert.Row.row((Object[])new Object[]{11, "with%%percents"}), (Object)QueryAssert.Row.row((Object[])new Object[]{12, "with space"}), (Object[])new QueryAssert.Row[0]);

    @Test(groups={"hive_partitioning"})
    public void testStringPartitioningWithSpecialCharactersCtasInTrino() {
        String tableName = "test_string_partitioning_with_special_chars_ctas_in_trino";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (id, part_col) WITH (partitioned_by = ARRAY['part_col']) AS VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslashes'),(6, 'with\\backslash'),(7, 'with=equal'),(8, 'with?question'),(9, 'with!exclamation'),(10, 'with%%percent'),(11, 'with%%%%percents'),(12, 'with space')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(EXPECTED_PARTITION_VALUES);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).contains(EXPECTED_PARTITION_VALUES);
    }

    @Test(groups={"hive_partitioning"})
    public void testStringPartitioningWithSpecialCharactersInsertInTrino() {
        String tableName = "test_string_partitioning_with_special_chars_insert_in_trino";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (id BIGINT, part_col VARCHAR) WITH (partitioned_by = ARRAY['part_col']) ", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslashes'),(6, 'with\\backslash'),(7, 'with=equal'),(8, 'with?question'),(9, 'with!exclamation'),(10, 'with%%percent'),(11, 'with%%%%percents'),(12, 'with space')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(EXPECTED_PARTITION_VALUES);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).contains(EXPECTED_PARTITION_VALUES);
    }

    @Test(groups={"hive_partitioning"})
    public void testStringPartitioningWithSpecialCharactersInsertInHive() {
        String sourceTableName = "test_string_partitioning_with_special_chars_insert_in_hive_source";
        String tableName = "test_string_partitioning_with_special_chars_insert_in_hive";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + sourceTableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (id, part_col) AS VALUES (1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslashes'),(6, 'with\\backslash'),(7, 'with=equal'),(8, 'with?question'),(9, 'with!exclamation'),(10, 'with%%percent'),(11, 'with%%%%percents'),(12, 'with space')", sourceTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (id BIGINT) PARTITIONED BY (part_col STRING) ", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("set hive.exec.dynamic.partition.mode=nonstrict", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s PARTITION(part_col) SELECT * FROM %s", tableName, sourceTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(EXPECTED_PARTITION_VALUES);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).contains(EXPECTED_PARTITION_VALUES);
    }

    @Test(groups={"hive_partitioning"})
    public void testStringPartitioningWithUtfChars() {
        String tableName = "test_string_partitioning_with_utf_chars";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (id BIGINT, part_col VARCHAR) WITH (partitioned_by = ARRAY['part_col']) ", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (1, '\u0142\u0105ka')", tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Hive partition keys can only contain printable ASCII characters");
    }
}

