/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.utils;

import com.google.common.collect.ImmutableList;
import io.minio.messages.Event;
import io.minio.messages.EventType;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class MinioNotificationsAssertions {
    private MinioNotificationsAssertions() {
    }

    public static void createNotificationsTable(String tableName) {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (name varchar, time timestamp, bucket varchar, object_key varchar, request map<varchar, varchar>, response map<varchar, varchar>, user_agent varchar, object_size int, object_version varchar, object_etag varchar, sequencer varchar)", MinioNotificationsAssertions.schemaTableName(tableName)), new QueryExecutor.QueryParam[0]);
    }

    public static void deleteNotificationsTable(String tableName) {
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", MinioNotificationsAssertions.schemaTableName(tableName)), new QueryExecutor.QueryParam[0]);
    }

    private static String schemaTableName(String tableName) {
        return String.format("memory.default.\"%s\"", tableName);
    }

    public static void recordNotification(String tableName, Event event) {
        String insertQuery = String.format("INSERT INTO %s (name, time, request, response, user_agent, bucket, object_key, object_size, object_version, object_etag, sequencer) VALUES (%s, from_iso8601_timestamp(%s), %s, %s, %s, %s, url_decode(%s), %d, %s, %s, %s)", MinioNotificationsAssertions.schemaTableName(tableName), MinioNotificationsAssertions.quote(event.eventType().name()), MinioNotificationsAssertions.quote(event.eventTime().toString()), MinioNotificationsAssertions.toSqlLiteral(event.requestParameters()), MinioNotificationsAssertions.toSqlLiteral(event.responseElements()), MinioNotificationsAssertions.quote(event.userAgent()), MinioNotificationsAssertions.quote(event.bucketName()), MinioNotificationsAssertions.quote(event.objectName()), event.objectSize(), MinioNotificationsAssertions.quote(event.objectVersionId()), MinioNotificationsAssertions.quote(event.etag()), MinioNotificationsAssertions.quote(event.sequencer()));
        QueryExecutors.onTrino().executeQuery(insertQuery, new QueryExecutor.QueryParam[0]);
    }

    private static String toSqlLiteral(Map<String, String> value) {
        if (value == null) {
            return "NULL";
        }
        ImmutableList.Builder keys = ImmutableList.builder();
        ImmutableList.Builder values = ImmutableList.builder();
        value.forEach((key, val) -> {
            keys.add((Object)MinioNotificationsAssertions.quote(key));
            values.add((Object)MinioNotificationsAssertions.quote(val));
        });
        return String.format("map(ARRAY[%s], ARRAY[%s])", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)keys.build()), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)values.build()));
    }

    private static String quote(String input) {
        if (input == null) {
            return "''";
        }
        return "'" + input.replaceAll("'", "''") + "'";
    }

    public static void assertNotificationsCount(String tableName, EventType eventType, String objectName, int expectedCalls) {
        List rows = QueryExecutors.onTrino().executeQuery(String.format("SELECT name, request, time FROM %s WHERE name = %s AND object_key = %s ORDER BY sequencer ASC", MinioNotificationsAssertions.schemaTableName(tableName), MinioNotificationsAssertions.quote(eventType.name()), MinioNotificationsAssertions.quote(objectName)), new QueryExecutor.QueryParam[0]).rows();
        if (rows.size() != expectedCalls) {
            throw new AssertionError((Object)String.format("Expected notification %s for '%s' %d time(s) but got %d: %s", eventType, objectName, expectedCalls, rows.size(), MinioNotificationsAssertions.formatEvents(rows)));
        }
    }

    private static String formatEvents(List<List<?>> calls) {
        return calls.stream().map(row -> String.format("%s at %s with request: %s", row.get(0), row.get(1), row.get(2))).collect(Collectors.joining(", ", "[", "]"));
    }
}

