/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.jdbc;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.MutableTableRequirement;
import io.trino.tempto.fulfillment.table.MutableTablesState;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.AllSimpleTypesTableDefinitions;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.testng.annotations.Test;

public class TestPreparedStatements
extends ProductTest {
    private static final String TABLE_NAME = "textfile_all_types";
    private static final String TABLE_NAME_MUTABLE = "all_types_table_name";
    private static final String INSERT_SQL = "INSERT INTO %s VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_STAR_SQL = "SELECT * FROM %s";

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableAllTypesTable.class})
    public void preparedSelectApi() {
        String selectSql = "SELECT c_int FROM textfile_all_types WHERE c_int = ?";
        int testValue = Integer.MAX_VALUE;
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(selectSql, new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.INTEGER, (Object)Integer.MAX_VALUE)})).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Integer.MAX_VALUE})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(selectSql, new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.INTEGER, null)})).hasNoRows();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(selectSql, new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.INTEGER, (Object)2)})).hasNoRows();
    }

    @Test(groups={"jdbc"})
    @Requires(value={ImmutableAllTypesTable.class})
    public void preparedSelectSql() throws SQLException {
        String prepareSql = "PREPARE ps1 from SELECT c_int FROM textfile_all_types WHERE c_int = ?";
        int testValue = Integer.MAX_VALUE;
        String executeSql = "EXECUTE ps1 using ";
        try (Statement statement = this.connection().createStatement();){
            statement.execute(prepareSql);
            QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)statement.executeQuery(executeSql + "2147483647"))).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Integer.MAX_VALUE})});
            QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)statement.executeQuery(executeSql + "NULL"))).hasNoRows();
            QueryAssert.assertThat((QueryResult)QueryResult.forResultSet((ResultSet)statement.executeQuery(executeSql + "2"))).hasNoRows();
        }
    }

    @Test(groups={"jdbc"})
    @Requires(value={MutableAllTypesTable.class})
    public void preparedInsertVarbinaryApi() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME_MUTABLE).getNameInDatabase();
        String insertSqlWithTable = String.format(INSERT_SQL, tableNameInDatabase);
        String selectSqlWithTable = String.format(SELECT_STAR_SQL, tableNameInDatabase);
        QueryExecutors.onTrino().executeQuery(insertSqlWithTable, new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.TINYINT, null), QueryExecutor.param((JDBCType)JDBCType.SMALLINT, null), QueryExecutor.param((JDBCType)JDBCType.INTEGER, null), QueryExecutor.param((JDBCType)JDBCType.BIGINT, null), QueryExecutor.param((JDBCType)JDBCType.FLOAT, null), QueryExecutor.param((JDBCType)JDBCType.DOUBLE, null), QueryExecutor.param((JDBCType)JDBCType.DECIMAL, null), QueryExecutor.param((JDBCType)JDBCType.DECIMAL, null), QueryExecutor.param((JDBCType)JDBCType.TIMESTAMP, null), QueryExecutor.param((JDBCType)JDBCType.DATE, null), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, null), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, null), QueryExecutor.param((JDBCType)JDBCType.CHAR, null), QueryExecutor.param((JDBCType)JDBCType.BOOLEAN, null), QueryExecutor.param((JDBCType)JDBCType.VARBINARY, (Object)new byte[]{0, 1, 2, 3, 0, 42, -7})});
        QueryResult result = QueryExecutors.onTrino().executeQuery(selectSqlWithTable, new QueryExecutor.QueryParam[0]);
        this.assertColumnTypes(result);
        QueryAssert.assertThat((QueryResult)result).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, new byte[]{0, 1, 2, 3, 0, 42, -7}})});
    }

    @Test(groups={"jdbc"})
    @Requires(value={MutableAllTypesTable.class})
    public void preparedInsertApi() {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME_MUTABLE).getNameInDatabase();
        String insertSqlWithTable = String.format(INSERT_SQL, tableNameInDatabase);
        String selectSqlWithTable = String.format(SELECT_STAR_SQL, tableNameInDatabase);
        QueryExecutors.onTrino().executeQuery(insertSqlWithTable, new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.TINYINT, (Object)127), QueryExecutor.param((JDBCType)JDBCType.SMALLINT, (Object)Short.MAX_VALUE), QueryExecutor.param((JDBCType)JDBCType.INTEGER, (Object)Integer.MAX_VALUE), QueryExecutor.param((JDBCType)JDBCType.BIGINT, (Object)new BigInteger("9223372036854775807")), QueryExecutor.param((JDBCType)JDBCType.FLOAT, (Object)Float.valueOf("123.345")), QueryExecutor.param((JDBCType)JDBCType.DOUBLE, (Object)234.567), QueryExecutor.param((JDBCType)JDBCType.DECIMAL, (Object)BigDecimal.valueOf(345L)), QueryExecutor.param((JDBCType)JDBCType.DECIMAL, (Object)BigDecimal.valueOf(345.678)), QueryExecutor.param((JDBCType)JDBCType.TIMESTAMP, (Object)Timestamp.valueOf("2015-05-10 12:15:35")), QueryExecutor.param((JDBCType)JDBCType.DATE, (Object)Date.valueOf("2015-05-10")), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)"ala ma kota"), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)"ala ma kot"), QueryExecutor.param((JDBCType)JDBCType.CHAR, (Object)"    ala ma"), QueryExecutor.param((JDBCType)JDBCType.BOOLEAN, (Object)Boolean.TRUE), QueryExecutor.param((JDBCType)JDBCType.VARBINARY, (Object)new byte[]{0, 1, 2, 3, 0, 42, -7})});
        QueryExecutors.onTrino().executeQuery(insertSqlWithTable, new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.TINYINT, (Object)1), QueryExecutor.param((JDBCType)JDBCType.SMALLINT, (Object)2), QueryExecutor.param((JDBCType)JDBCType.INTEGER, (Object)3), QueryExecutor.param((JDBCType)JDBCType.BIGINT, (Object)4), QueryExecutor.param((JDBCType)JDBCType.FLOAT, (Object)Float.valueOf("5.6")), QueryExecutor.param((JDBCType)JDBCType.DOUBLE, (Object)7.8), QueryExecutor.param((JDBCType)JDBCType.DECIMAL, (Object)BigDecimal.valueOf(91L)), QueryExecutor.param((JDBCType)JDBCType.DECIMAL, (Object)BigDecimal.valueOf(2.3)), QueryExecutor.param((JDBCType)JDBCType.TIMESTAMP, (Object)Timestamp.valueOf("2012-05-10 1:35:15")), QueryExecutor.param((JDBCType)JDBCType.DATE, (Object)Date.valueOf("2014-03-10")), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)"abc"), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)"def"), QueryExecutor.param((JDBCType)JDBCType.CHAR, (Object)"       ghi"), QueryExecutor.param((JDBCType)JDBCType.BOOLEAN, (Object)Boolean.FALSE), QueryExecutor.param((JDBCType)JDBCType.VARBINARY, (Object)new byte[]{0, 1, 2, 3, 0, 42, -7})});
        QueryExecutors.onTrino().executeQuery(insertSqlWithTable, new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.TINYINT, null), QueryExecutor.param((JDBCType)JDBCType.SMALLINT, null), QueryExecutor.param((JDBCType)JDBCType.INTEGER, null), QueryExecutor.param((JDBCType)JDBCType.BIGINT, null), QueryExecutor.param((JDBCType)JDBCType.FLOAT, null), QueryExecutor.param((JDBCType)JDBCType.DOUBLE, null), QueryExecutor.param((JDBCType)JDBCType.DECIMAL, null), QueryExecutor.param((JDBCType)JDBCType.DECIMAL, null), QueryExecutor.param((JDBCType)JDBCType.TIMESTAMP, null), QueryExecutor.param((JDBCType)JDBCType.DATE, null), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, null), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, null), QueryExecutor.param((JDBCType)JDBCType.CHAR, null), QueryExecutor.param((JDBCType)JDBCType.BOOLEAN, null), QueryExecutor.param((JDBCType)JDBCType.VARBINARY, null)});
        QueryResult result = QueryExecutors.onTrino().executeQuery(selectSqlWithTable, new QueryExecutor.QueryParam[0]);
        this.assertColumnTypes(result);
        QueryAssert.assertThat((QueryResult)result).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.valueOf("9223372036854775807"), Float.valueOf("123.345"), 234.567, BigDecimal.valueOf(345L), new BigDecimal("345.67800"), Timestamp.valueOf("2015-05-10 12:15:35"), Date.valueOf("2015-05-10"), "ala ma kota", "ala ma kot", "    ala ma", Boolean.TRUE, new byte[]{0, 1, 2, 3, 0, 42, -7}}), QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4L, Float.valueOf("5.6"), 7.8, BigDecimal.valueOf(91L), BigDecimal.valueOf(2.3), Timestamp.valueOf("2012-05-10 1:35:15"), Date.valueOf("2014-03-10"), "abc", "def", "       ghi", Boolean.FALSE, new byte[]{0, 1, 2, 3, 0, 42, -7}}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null})});
    }

    @Test(groups={"jdbc"})
    @Requires(value={MutableAllTypesTable.class})
    public void preparedInsertSql() throws SQLException {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME_MUTABLE).getNameInDatabase();
        String insertSqlWithTable = "PREPARE ps1 from " + String.format(INSERT_SQL, tableNameInDatabase);
        String selectSqlWithTable = String.format(SELECT_STAR_SQL, tableNameInDatabase);
        String executeSql = "EXECUTE ps1 using ";
        try (Statement statement = this.connection().createStatement();){
            statement.execute(insertSqlWithTable);
            statement.execute(executeSql + "cast(127 as tinyint), cast(32767 as smallint), 2147483647, 9223372036854775807, cast(123.345 as real), cast(234.567 as double), cast(345 as decimal(10)), cast(345.678 as decimal(10,5)), timestamp '2015-05-10 12:15:35', date '2015-05-10', 'ala ma kota', 'ala ma kot', cast('ala ma' as char(10)), true, X'00010203002AF9'");
            statement.execute(executeSql + "cast(1 as tinyint), cast(2 as smallint), 3, 4, cast(5.6 as real), cast(7.8 as double), cast(9 as decimal(10)), cast(2.3 as decimal(10,5)), timestamp '2012-05-10 1:35:15', date '2014-03-10', 'abc', 'def', cast('ghi' as char(10)), false, varbinary 'jkl'");
            statement.execute(executeSql + "null, null, null, null, null, null, null, null, null, null, null, null, null, null, null");
            QueryResult result = QueryExecutors.onTrino().executeQuery(selectSqlWithTable, new QueryExecutor.QueryParam[0]);
            this.assertColumnTypes(result);
            QueryAssert.assertThat((QueryResult)result).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.valueOf("9223372036854775807"), Float.valueOf("123.345"), 234.567, BigDecimal.valueOf(345L), new BigDecimal("345.67800"), Timestamp.valueOf("2015-05-10 12:15:35"), Date.valueOf("2015-05-10"), "ala ma kota", "ala ma kot", "ala ma    ", Boolean.TRUE, new byte[]{0, 1, 2, 3, 0, 42, -7}}), QueryAssert.Row.row((Object[])new Object[]{1, 2, 3, 4, Float.valueOf("5.6"), 7.8, BigDecimal.valueOf(9L), new BigDecimal("2.30000"), Timestamp.valueOf("2012-05-10 1:35:15"), Date.valueOf("2014-03-10"), "abc", "def", "ghi       ", Boolean.FALSE, "jkl".getBytes(StandardCharsets.UTF_8)}), QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null})});
        }
    }

    @Test(groups={"jdbc"})
    @Requires(value={MutableAllTypesTable.class})
    public void preparedInsertVarbinarySql() throws SQLException {
        String tableNameInDatabase = MutableTablesState.mutableTablesState().get(TABLE_NAME_MUTABLE).getNameInDatabase();
        String insertSqlWithTable = "PREPARE ps1 from " + String.format(INSERT_SQL, tableNameInDatabase);
        String selectSqlWithTable = String.format(SELECT_STAR_SQL, tableNameInDatabase);
        String executeSql = "EXECUTE ps1 using ";
        try (Statement statement = this.connection().createStatement();){
            statement.execute(insertSqlWithTable);
            statement.execute(executeSql + "null, null, null, null, null, null, null, null, null, null, null, null, null, null, X'00010203002AF9'");
            QueryResult result = QueryExecutors.onTrino().executeQuery(selectSqlWithTable, new QueryExecutor.QueryParam[0]);
            this.assertColumnTypes(result);
            QueryAssert.assertThat((QueryResult)result).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, new byte[]{0, 1, 2, 3, 0, 42, -7}})});
        }
    }

    private void assertColumnTypes(QueryResult queryResult) {
        QueryAssert.assertThat((QueryResult)queryResult).hasColumns(new JDBCType[]{JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INTEGER, JDBCType.BIGINT, JDBCType.REAL, JDBCType.DOUBLE, JDBCType.DECIMAL, JDBCType.DECIMAL, JDBCType.TIMESTAMP, JDBCType.DATE, JDBCType.VARCHAR, JDBCType.VARCHAR, JDBCType.CHAR, JDBCType.BOOLEAN, JDBCType.VARBINARY});
    }

    private Connection connection() {
        return QueryExecutors.onTrino().getConnection();
    }

    private static class MutableAllTypesTable
    implements RequirementsProvider {
        private MutableAllTypesTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.mutableTable((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE, (String)TestPreparedStatements.TABLE_NAME_MUTABLE, (MutableTableRequirement.State)MutableTableRequirement.State.CREATED);
        }
    }

    private static class ImmutableAllTypesTable
    implements RequirementsProvider {
        private ImmutableAllTypesTable() {
        }

        public Requirement getRequirements(Configuration configuration) {
            return TableRequirements.immutableTable((TableDefinition)AllSimpleTypesTableDefinitions.ALL_HIVE_SIMPLE_TYPES_TEXTFILE);
        }
    }
}

