/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeltaLakeAlterTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testAddColumnWithCommentOnTrino() {
        String tableName = "test_dl_add_column_with_comment_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT COMMENT 'new column comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "new_col"), (String)"new column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "new_col"), (String)"new column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

