/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.testng.annotations.Test;

public class TestDeltaLakeColumnMappingMode
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testColumnMappingModeNone() {
        String tableName = "test_dl_column_mapping_mode_none" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            ImmutableList expectedRows = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expectedRows);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testColumnMappingModeName() {
        String tableName = "test_dl_column_mapping_mode_name" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + " (a_number INT) USING delta  LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "' TBLPROPERTIES ( 'delta.columnMapping.mode'='name', 'delta.minReaderVersion'='2', 'delta.minWriterVersion'='5')", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DESCRIBE delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Only 'none' is supported for 'delta.columnMapping.mode' table property");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Only 'none' is supported for 'delta.columnMapping.mode' table property");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SHOW STATS FOR delta.default." + tableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Only 'none' is supported for 'delta.columnMapping.mode' table property");
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO delta.default." + tableName + " VALUES (1)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Only 'none' is supported for 'delta.columnMapping.mode' table property");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

