/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveAndDeltaLakeRedirect
extends BaseTestDeltaLakeS3Storage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToDeltaRedirect() {
        String tableName = "redirect_to_delta_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsOnly((List)hiveResult.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToDeltaNonDefaultSchemaRedirect() {
        String tableName = "redirect_to_delta_non_default_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE SCHEMA IF NOT EXISTS extraordinary", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks("extraordinary", tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery("SELECT * FROM extraordinary." + tableName, new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.extraordinary.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsOnly((List)hiveResult.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE extraordinary." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToNonexistentDeltaCatalogRedirectFailure() {
        String tableName = "redirect_to_nonexistent_delta_" + TemporaryHiveTable.randomTableSuffix();
        try {
            QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, false), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("SET SESSION hive.delta_lake_catalog_name = 'epsilon'", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'hive.default.redirect_to_nonexistent_delta_.*' redirected to 'epsilon.default.redirect_to_nonexistent_delta_.*', but the target catalog 'epsilon' does not exist");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToDeltaRedirectWithDefaultSchemaInSession() {
        String tableName = "redirect_to_delta_with_use_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("USE hive.default", new QueryExecutor.QueryParam[0]);
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM \"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsOnly((List)hiveResult.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToUnpartitionedDeltaPartitionsRedirectFailure() {
        String tableName = "delta_lake_unpartitioned_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'hive.default.delta_lake_unpartitioned_table_.*\\$partitions' redirected to 'delta.default.delta_lake_unpartitioned_table_.*\\$partitions', but the target table 'delta.default.delta_lake_unpartitioned_table_.*\\$partitions' does not exist");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToPartitionedDeltaPartitionsRedirectFailure() {
        String tableName = "delta_lake_partitioned_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'hive.default.delta_lake_partitioned_table_.*\\$partitions' redirected to 'delta.default.delta_lake_partitioned_table_.*\\$partitions', but the target table 'delta.default.delta_lake_partitioned_table_.*\\$partitions' does not exist");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToHiveRedirect() {
        String tableName = "redirect_to_hive_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList expectedResults = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, false, -128}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, true, 127}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, false, 0}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, false, 1}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, true, 37}));
            QueryResult deltaResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)deltaResult).containsOnly((List)expectedResults);
            QueryAssert.assertThat((QueryResult)hiveResult).containsOnly((List)expectedResults);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToHiveNonDefaultSchemaRedirect() {
        String tableName = "redirect_to_hive_non_default_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive.extraordinary", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("extraordinary", tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList expectedResults = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, false, -128}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, true, 127}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, false, 0}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, false, 1}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, true, 37}));
            QueryResult deltaResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.extraordinary.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.extraordinary.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)deltaResult).containsOnly((List)expectedResults);
            QueryAssert.assertThat((QueryResult)hiveResult).containsOnly((List)expectedResults);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.extraordinary." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToNonexistentHiveCatalogRedirectFailure() {
        String tableName = "redirect_to_nonexistent_hive_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("SET SESSION delta.hive_catalog_name = 'spark'", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'delta.default.redirect_to_nonexistent_hive_.*' redirected to 'spark.default.redirect_to_nonexistent_hive_.*', but the target catalog 'spark' does not exist");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToHiveRedirectWithDefaultSchemaInSession() {
        String tableName = "redirect_to_hive_with_use_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("USE hive.default", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList expectedResults = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, false, -128}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, true, 127}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, false, 0}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, false, 1}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, true, 37}));
            QueryResult deltaResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM \"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)deltaResult).containsOnly((List)expectedResults);
            QueryAssert.assertThat((QueryResult)hiveResult).containsOnly((List)expectedResults);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToPartitionedHivePartitionsRedirect() {
        String tableName = "hive_partitioned_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList expectedResults = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{-128}), (Object)QueryAssert.Row.row((Object[])new Object[]{127}), (Object)QueryAssert.Row.row((Object[])new Object[]{0}), (Object)QueryAssert.Row.row((Object[])new Object[]{1}), (Object)QueryAssert.Row.row((Object[])new Object[]{37}));
            QueryResult deltaResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)deltaResult).containsOnly((List)expectedResults);
            QueryAssert.assertThat((QueryResult)hiveResult).containsOnly((List)expectedResults);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToUnpartitionedHivePartitionsRedirectFailure() {
        String tableName = "hive_unpartitioned_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, false), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s$partitions\"", tableName), new QueryExecutor.QueryParam[0])).hasMessageMatching(".*Table 'delta.default.hive_unpartitioned_table.*partitions' does not exist");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToHiveInsert() {
        String tableName = "hive_insert_by_delta_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO delta.default.\"%s\" VALUES (6, false, -17), (7, true, 1)", tableName), new QueryExecutor.QueryParam[0]);
            ImmutableList expectedResults = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{1, false, -128}), (Object)QueryAssert.Row.row((Object[])new Object[]{2, true, 127}), (Object)QueryAssert.Row.row((Object[])new Object[]{3, false, 0}), (Object)QueryAssert.Row.row((Object[])new Object[]{4, false, 1}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, true, 37}), (Object)QueryAssert.Row.row((Object[])new Object[]{6, false, -17}), (Object)QueryAssert.Row.row((Object[])new Object[]{7, true, 1}));
            QueryResult deltaResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)deltaResult).containsOnly((List)expectedResults);
            QueryAssert.assertThat((QueryResult)hiveResult).containsOnly((List)expectedResults);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToDeltaInsert() {
        String tableName = "delta_insert_by_hive_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO hive.default.\"%s\" VALUES (1234567890, 'San Escobar', 5, 'If I had a world of my own, everything would be nonsense')", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT count(*) FROM hive.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{5})});
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToHiveDescribe() {
        String tableName = "hive_describe_by_delta_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList expectedResults = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"id", "integer", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"flag", "boolean", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"rate", "tinyint", "partition key", ""}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("DESCRIBE delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0])).containsOnly((List)expectedResults);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToDeltaDescribe() {
        String tableName = "delta_describe_by_hive_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            ImmutableList expectedResults = ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{"nationkey", "bigint", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"name", "varchar", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"regionkey", "bigint", "", ""}), (Object)QueryAssert.Row.row((Object[])new Object[]{"comment", "varchar", "", ""}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("DESCRIBE hive.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0])).containsOnly((List)expectedResults);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToHiveShowCreateTable() {
        String tableName = "hive_show_create_table_by_delta_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SHOW CREATE TABLE delta.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToDeltaShowCreateTable() {
        String tableName = "delta_show_create_table_by_hive_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SHOW CREATE TABLE hive.default.\"%s\"", tableName), new QueryExecutor.QueryParam[0])).hasRowsCount(1);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToHiveAlterTable() {
        String tableName = "hive_alter_table_by_delta_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, false), new QueryExecutor.QueryParam[0]);
        String newTableName = tableName + "_new";
        try {
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " RENAME TO " + newTableName, new QueryExecutor.QueryParam[0]);
            TestHiveAndDeltaLakeRedirect.assertResultsEqual(QueryExecutors.onTrino().executeQuery("TABLE hive.default." + newTableName, new QueryExecutor.QueryParam[0]), QueryExecutors.onTrino().executeQuery("TABLE delta.default." + newTableName, new QueryExecutor.QueryParam[0]));
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + newTableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToDeltaAlterTable() {
        String tableName = "delta_alter_table_by_hive_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE hive.default.\"" + tableName + "\" RENAME TO \"" + tableName + "_new\"", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*This connector does not support renaming tables");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testDeltaToHiveCommentTable() {
        String tableName = "hive_comment_table_by_delta_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector("default", tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'hive' AND schema_name = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0])).is(new Condition(queryResult -> queryResult.row(0).get(0) == null, "Unexpected table comment", new Object[0]));
            String tableComment = "This is my table, there are many like it but this one is mine";
            QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE delta.default.\"" + tableName + "\" IS '%s'", tableComment), new QueryExecutor.QueryParam[0]);
            TestHiveAndDeltaLakeRedirect.assertTableComment("hive", "default", tableName).isEqualTo(tableComment);
            TestHiveAndDeltaLakeRedirect.assertTableComment("delta", "default", tableName).isEqualTo(tableComment);
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE hive.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testHiveToDeltaCommentTable() {
        String tableName = "delta_comment_table_by_hive_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(tableName, true), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'delta' AND schema_name = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0])).is(new Condition(queryResult -> queryResult.row(0).get(0) == null, "Unexpected table comment", new Object[0]));
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE hive.default.\"" + tableName + "\" IS 'This is my table, there are many like it but this one is mine'", new QueryExecutor.QueryParam[0])).hasMessageMatching(".*This connector does not support setting table comments");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testInsertIntoDeltaTableFromHiveNonDefaultSchemaRedirect() {
        String destSchema = "extraordinary";
        String destTableName = "create_delta_table_from_hive_non_default_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE SCHEMA IF NOT EXISTS extraordinary", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(destSchema, destTableName, false), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO hive.%s.\"%s\" (nationkey, name, regionkey) VALUES (26, 'POLAND', 3)", destSchema, destTableName), new QueryExecutor.QueryParam[0]);
            QueryResult hiveResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.%s.\"%s\"", destSchema, destTableName), new QueryExecutor.QueryParam[0]);
            QueryResult deltaResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.%s.\"%s\"", destSchema, destTableName), new QueryExecutor.QueryParam[0]);
            ImmutableList expectedDestinationTableRows = ImmutableList.builder().add((Object)new QueryAssert.Row(new Object[]{0, "ALGERIA", 0, "haggle. carefully final deposits detect slyly agai"})).add((Object)new QueryAssert.Row(new Object[]{1, "ARGENTINA", 1, "al foxes promise slyly according to the regular accounts. bold requests alon"})).add((Object)new QueryAssert.Row(new Object[]{2, "BRAZIL", 1, "y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special"})).add((Object)new QueryAssert.Row(new Object[]{3, "CANADA", 1, "eas hang ironic, silent packages. slyly regular packages are furiously over the tithes. fluffily bold"})).add((Object)new QueryAssert.Row(new Object[]{26, "POLAND", 3, null})).build();
            QueryAssert.assertThat((QueryResult)hiveResult).containsOnly((List)expectedDestinationTableRows);
            QueryAssert.assertThat((QueryResult)deltaResult).containsOnly((List)expectedDestinationTableRows);
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE extraordinary." + destTableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testInformationSchemaColumnsHiveToDeltaRedirect() {
        String schemaName = "redirect_to_delta_information_schema_columns_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String tableName = "redirect_to_delta_information_schema_columns_table_" + TemporaryHiveTable.randomTableSuffix();
        try {
            QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(schemaName, tableName, false), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.information_schema.columns WHERE table_schema = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name", 2, null, "YES", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey", 3, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment", 4, null, "YES", "varchar"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.information_schema.columns WHERE table_schema = '%s'", schemaName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name", 2, null, "YES", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey", 3, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment", 4, null, "YES", "varchar"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.information_schema.columns WHERE table_schema = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "nationkey", 1, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "name", 2, null, "YES", "varchar"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "regionkey", 3, null, "YES", "bigint"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "comment", 4, null, "YES", "varchar"})});
        }
        catch (Throwable throwable) {
            QueryExecutors.onDelta().executeQuery(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onDelta().executeQuery(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testInformationSchemaColumnsDeltaToHiveRedirect() {
        String schemaName = "redirect_to_hive_information_schema_columns_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String tableName = "redirect_to_hive_information_schema_columns_table_" + TemporaryHiveTable.randomTableSuffix();
        try {
            QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector(schemaName, tableName, false), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.information_schema.columns WHERE table_schema = '%s' AND table_name='%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "id", 1, null, "YES", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "flag", 2, null, "YES", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "rate", 3, null, "YES", "tinyint"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.information_schema.columns WHERE table_schema = '%s'", schemaName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "id", 1, null, "YES", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "flag", 2, null, "YES", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "rate", 3, null, "YES", "tinyint"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM hive.information_schema.columns WHERE table_schema = '%s' AND table_name='%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "id", 1, null, "YES", "integer"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "flag", 2, null, "YES", "boolean"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "rate", 3, null, "YES", "tinyint"})});
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS hive.%s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS hive.%s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testSystemJdbcColumnsHiveToDeltaRedirect() {
        String schemaName = "redirect_to_delta_system_jdbc_columns_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String tableName = "redirect_to_delta_system_jdbc_columns_table_" + TemporaryHiveTable.randomTableSuffix();
        try {
            QueryExecutors.onDelta().executeQuery(this.createTableInDatabricks(schemaName, tableName, false), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns  WHERE table_cat = 'hive' AND table_schem = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns  WHERE table_cat = 'hive' AND table_schem = '%s'", schemaName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "comment"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns  WHERE table_cat = 'delta' AND table_schem = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "nationkey"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "name"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "regionkey"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "comment"})});
        }
        catch (Throwable throwable) {
            QueryExecutors.onDelta().executeQuery(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onDelta().executeQuery(String.format("DROP TABLE IF EXISTS %s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testSystemJdbcColumnsDeltaToHiveRedirect() {
        String schemaName = "redirect_to_hive_system_jdbc_columns_schema_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery("CREATE SCHEMA IF NOT EXISTS hive." + schemaName, new QueryExecutor.QueryParam[0]);
        String tableName = "redirect_to_hive_system_jdbc_columns_table_" + TemporaryHiveTable.randomTableSuffix();
        try {
            QueryExecutors.onTrino().executeQuery(this.createTableInHiveConnector(schemaName, tableName, false), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns  WHERE table_cat = 'delta' AND table_schem = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "id"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "flag"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "rate"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns  WHERE table_cat = 'delta' AND table_schem = '%s'", schemaName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "id"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "flag"}), QueryAssert.Row.row((Object[])new Object[]{"delta", schemaName, tableName, "rate"})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT table_cat, table_schem, table_name, column_name FROM system.jdbc.columns  WHERE table_cat = 'hive' AND table_schem = '%s' AND table_name = '%s'", schemaName, tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "id"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "flag"}), QueryAssert.Row.row((Object[])new Object[]{"hive", schemaName, tableName, "rate"})});
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS hive.%s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS hive.%s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP SCHEMA " + schemaName, new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"}, dataProvider="trueFalse")
    public void testViewReferencingHiveAndDeltaTable(boolean legacyHiveViewTranslation) {
        String hiveTableName = "test_view_hive_table_" + TemporaryHiveTable.randomTableSuffix();
        String deltaTableName = "test_view_delta_table_" + TemporaryHiveTable.randomTableSuffix();
        String viewName = "test_view_view_" + TemporaryHiveTable.randomTableSuffix();
        String deltaRegionTableName = "test_view_delta_region_table_" + TemporaryHiveTable.randomTableSuffix();
        String deltaTableData = "SELECT   true a_boolean,   CAST(1 AS integer) an_integer,   CAST(1 AS bigint) a_bigint,  CAST(1 AS real) a_real,   CAST(1 AS double) a_double,   CAST('13.1' AS decimal(3,1)) a_short_decimal,   CAST('123456789123456.123456789' AS decimal(24,9)) a_long_decimal,   CAST('abc' AS string) an_unbounded_varchar,   X'abcd' a_varbinary,   DATE '2005-09-10' a_date,   0 a_last_column ";
        try {
            QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default." + hiveTableName + " WITH (external_location = '" + this.locationForTable(hiveTableName) + "') AS TABLE tpch.tiny.region", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("CREATE TABLE " + deltaTableName + " USING DELTA LOCATION '" + this.locationForTable(deltaTableName) + "'  AS " + deltaTableData, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("CREATE TABLE " + deltaRegionTableName + " USING DELTA LOCATION '" + this.locationForTable(deltaRegionTableName) + "'  AS VALUES     (CAST(0 AS bigint), 'AFRICA'),     (CAST(1 AS bigint), 'AMERICA'),     (CAST(2 AS bigint), 'ASIA'),     (CAST(3 AS bigint), 'EUROPE'),     (CAST(4 AS bigint), 'MIDDLE EAST') AS data(regionkey, name)", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("CREATE VIEW " + viewName + " AS SELECT dt.*, regionkey, name FROM " + deltaTableName + " dt JOIN " + deltaRegionTableName + " ON an_integer = regionkey", new QueryExecutor.QueryParam[0]);
            List<QueryAssert.Row> expected = List.of(QueryAssert.Row.row((Object[])new Object[]{true, 1, 1L, Float.valueOf(1.0f), 1.0, new BigDecimal("13.1"), new BigDecimal("123456789123456.123456789"), "abc", new byte[]{-85, -51}, Date.valueOf(LocalDate.of(2005, 9, 10)), 0, 1L, "AMERICA"}));
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM " + viewName, new QueryExecutor.QueryParam[0])).containsOnly(expected);
            QueryExecutors.onTrino().executeQuery("SET SESSION hive.hive_views_legacy_translation = " + legacyHiveViewTranslation, new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default." + viewName, new QueryExecutor.QueryParam[0])).containsOnly(expected);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT * FROM delta.default." + viewName, new QueryExecutor.QueryParam[0])).hasMessageMatching("\\QQuery failed (\\E#\\S+\\Q): default." + viewName + " is not a Delta Lake table");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP VIEW IF EXISTS " + viewName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DROP TABLE IF EXISTS " + deltaTableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onDelta().executeQuery("DROP TABLE IF EXISTS " + deltaRegionTableName, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS hive.default." + hiveTableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @DataProvider
    public Object[][] trueFalse() {
        return new Object[][]{{true}, {false}};
    }

    private String createTableInDatabricks(String tableName, boolean partitioned) {
        return this.createTableInDatabricks("default", tableName, partitioned);
    }

    @Language(value="SQL")
    private String createTableInDatabricks(String schema, String tableName, boolean partitioned) {
        return "CREATE TABLE " + schema + "." + tableName + " USING DELTA " + (partitioned ? "PARTITIONED BY (regionkey) " : "") + "LOCATION '" + this.locationForTable(tableName) + "'  AS VALUES (CAST(0 AS bigint), 'ALGERIA', CAST(0 AS bigint), 'haggle. carefully final deposits detect slyly agai'),(CAST(1 AS bigint), 'ARGENTINA', CAST(1 AS bigint), 'al foxes promise slyly according to the regular accounts. bold requests alon'),(CAST(2 AS bigint), 'BRAZIL', CAST(1 AS bigint), 'y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special'),(CAST(3 AS bigint), 'CANADA', CAST(1 AS bigint), 'eas hang ironic, silent packages. slyly regular packages are furiously over the tithes. fluffily bold') AS data(nationkey, name, regionkey, comment)";
    }

    @Language(value="SQL")
    private String createTableInHiveConnector(String schema, String tableName, boolean partitioned) {
        return "CREATE TABLE hive." + schema + "." + tableName + "(id, flag, rate) WITH (    external_location = '" + this.locationForTable(tableName) + "'" + (partitioned ? ", partitioned_by = ARRAY['rate']" : "") + ") AS VALUES (1, BOOLEAN 'false', TINYINT '-128'), (2, BOOLEAN 'true', TINYINT '127'), (3, BOOLEAN 'false', TINYINT '0'), (4, BOOLEAN 'false', TINYINT '1'), (5, BOOLEAN 'true', TINYINT '37')";
    }

    private String locationForTable(String tableName) {
        return "s3://" + this.bucketName + "/hive-and-databricks-redirect-" + tableName;
    }

    private static AbstractStringAssert<?> assertTableComment(String catalog, String schema, String tableName) {
        QueryResult queryResult = TestHiveAndDeltaLakeRedirect.readTableComment(catalog, schema, tableName);
        return Assertions.assertThat((String)((String)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)queryResult.rows())))));
    }

    private static QueryResult readTableComment(String catalog, String schema, String tableName) {
        return QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = ? AND schema_name = ? AND table_name = ?", new QueryExecutor.QueryParam[]{QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)catalog), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)schema), QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)tableName)});
    }

    private static void assertResultsEqual(QueryResult first, QueryResult second) {
        QueryAssert.assertThat((QueryResult)first).containsOnly((List)second.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
        QueryAssert.assertThat((QueryResult)second).containsOnly((List)first.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList()));
    }
}

