/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.Requires;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.function.Consumer;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class TestHiveViewCompatibility
extends HiveProductTest {
    @Test(groups={"hive_view_compatibility", "profile_specific_tests"})
    public void testSelectOnView() {
        QueryExecutors.onCompatibilityTestServer().executeQuery("DROP VIEW IF EXISTS hive_test_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onCompatibilityTestServer().executeQuery("CREATE VIEW hive_test_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        TestHiveViewCompatibility.assertViewQuery(QueryExecutors.onCompatibilityTestServer(), "SELECT * FROM hive_test_view", queryAssert -> queryAssert.hasRowsCount(25));
        TestHiveViewCompatibility.assertViewQuery(QueryExecutors.onCompatibilityTestServer(), "SELECT n_nationkey, n_name, n_regionkey, n_comment FROM hive_test_view WHERE n_nationkey < 3", queryAssert -> queryAssert.containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0, "ALGERIA", 0, " haggle. carefully final deposits detect slyly agai"}), QueryAssert.Row.row((Object[])new Object[]{1, "ARGENTINA", 1, "al foxes promise slyly according to the regular accounts. bold requests alon"}), QueryAssert.Row.row((Object[])new Object[]{2, "BRAZIL", 1, "y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special "})}));
    }

    @Test(groups={"hive_view_compatibility", "profile_specific_tests"})
    public void testSelectOnViewFromDifferentSchema() {
        QueryExecutors.onHive().executeQuery("DROP SCHEMA IF EXISTS test_schema CASCADE", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE SCHEMA test_schema", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onCompatibilityTestServer().executeQuery("CREATE VIEW test_schema.hive_test_view_1 AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        TestHiveViewCompatibility.assertViewQuery(QueryExecutors.onCompatibilityTestServer(), "SELECT * FROM test_schema.hive_test_view_1", queryAssert -> queryAssert.hasRowsCount(25));
    }

    @Test(groups={"hive_view_compatibility", "profile_specific_tests"})
    public void testExistingView() {
        QueryExecutors.onCompatibilityTestServer().executeQuery("DROP VIEW IF EXISTS hive_duplicate_view", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onCompatibilityTestServer().executeQuery("CREATE VIEW hive_duplicate_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE VIEW hive_duplicate_view AS SELECT * FROM nation", new QueryExecutor.QueryParam[0])).hasMessageContaining("View already exists");
    }

    protected static void assertViewQuery(QueryExecutor queryExecutor, String query, Consumer<QueryAssert> assertion) {
        assertion.accept(QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(query, new QueryExecutor.QueryParam[0])));
        assertion.accept(QueryAssert.assertThat((QueryResult)queryExecutor.executeQuery(query, new QueryExecutor.QueryParam[0])));
    }
}

