/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeltaLakeAlterTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testAddColumnWithCommentOnTrino() {
        String tableName = "test_dl_add_column_with_comment_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT COMMENT 'new column comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "new_col"), (String)"new column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "new_col"), (String)"new column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    public void testAddColumnUnsupportedWriterVersion() {
        String tableName = "test_dl_add_column_unsupported_writer_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='3')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col int", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 3 which is not supported");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testCommentOnTable() {
        String tableName = "test_dl_comment_table_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment'", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'delta' AND schema_name = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"test comment"})});
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    public void testCommentOnTableUnsupportedWriterVersion() {
        String tableName = "test_dl_comment_table_unsupported_writer_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='3')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON TABLE delta.default." + tableName + " IS 'test comment'", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 3 which is not supported");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testCommentOnColumn() {
        String tableName = "test_dl_comment_column_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test column comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test column comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "delta-lake-exclude-73", "profile_specific_tests"})
    public void testCommentOnColumnUnsupportedWriterVersion() {
        String tableName = "test_dl_comment_column_unsupported_writer_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col int) USING DELTA LOCATION 's3://%s/%s'TBLPROPERTIES ('delta.minWriterVersion'='3')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("COMMENT ON COLUMN delta.default." + tableName + ".col IS 'test column comment'", new QueryExecutor.QueryParam[0])).hasMessageMatching(".* Table .* requires Delta Lake writer version 3 which is not supported");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }
}

