/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake.util;

import com.google.common.base.MoreObjects;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;

public final class DeltaLakeTestUtils {
    public static final String DATABRICKS_104_RUNTIME_VERSION = "10.4";

    private DeltaLakeTestUtils() {
    }

    public static String getDatabricksRuntimeVersion() {
        QueryResult result = QueryExecutors.onDelta().executeQuery("SELECT java_method('java.lang.System', 'getenv', 'DATABRICKS_RUNTIME_VERSION')", new QueryExecutor.QueryParam[0]);
        return (String)MoreObjects.firstNonNull((Object)((String)result.row(0).get(0)), (Object)"unknown");
    }

    public static String getColumnCommentOnTrino(String schemaName, String tableName, String columnName) {
        QueryResult result = QueryExecutors.onTrino().executeQuery("SELECT comment FROM information_schema.columns WHERE table_schema = '" + schemaName + "' AND table_name = '" + tableName + "' AND column_name = '" + columnName + "'", new QueryExecutor.QueryParam[0]);
        return (String)result.row(0).get(0);
    }

    public static String getColumnCommentOnDelta(String schemaName, String tableName, String columnName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery(String.format("DESCRIBE %s.%s %s", schemaName, tableName, columnName), new QueryExecutor.QueryParam[0]);
        return (String)result.row(2).get(1);
    }

    public static String getTableCommentOnDelta(String schemaName, String tableName) {
        QueryResult result = QueryExecutors.onDelta().executeQuery(String.format("DESCRIBE EXTENDED %s.%s", schemaName, tableName), new QueryExecutor.QueryParam[0]);
        return (String)result.rows().stream().filter(row -> row.get(0).equals("Comment")).map(row -> row.get(1)).findFirst().orElseThrow();
    }
}

