/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.testng.annotations.Test;

public abstract class BaseTestAvroSchemaEvolution
extends ProductTest {
    private static final String ORIGINAL_SCHEMA = "file:///docker/presto-product-tests/avro/original_schema.avsc";
    private static final String RENAMED_COLUMN_SCHEMA = "file:///docker/presto-product-tests/avro/rename_column_schema.avsc";
    private static final String REMOVED_COLUMN_SCHEMA = "file:///docker/presto-product-tests/avro/remove_column_schema.avsc";
    private static final String ADDED_COLUMN_SCHEMA = "file:///docker/presto-product-tests/avro/add_column_schema.avsc";
    private static final String CHANGE_COLUMN_TYPE_SCHEMA = "file:///docker/presto-product-tests/avro/change_column_type_schema.avsc";
    private static final String INCOMPATIBLE_TYPE_SCHEMA = "file:///docker/presto-product-tests/avro/incompatible_type_schema.avsc";
    private final String tableName;
    private final String columnsInTableStatement;
    private final String selectStarStatement;
    private final List<String> varcharPartitionColumns;

    protected BaseTestAvroSchemaEvolution(String tableName, String ... varcharPartitionColumns) {
        this.tableName = tableName;
        this.columnsInTableStatement = "SHOW COLUMNS IN " + tableName;
        this.selectStarStatement = "SELECT * FROM " + tableName;
        this.varcharPartitionColumns = ImmutableList.copyOf((Object[])varcharPartitionColumns);
    }

    @BeforeTestWithContext
    public void createAndLoadTable() {
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (  dummy_col VARCHAR" + (String)(this.varcharPartitionColumns.isEmpty() ? "" : ", " + this.getPartitionsAsListString(partitionColumns -> partitionColumns + " varchar")) + ")WITH (  format='AVRO',   avro_schema_url='%s'" + (String)(this.varcharPartitionColumns.isEmpty() ? "" : ", partitioned_by=ARRAY[" + this.getPartitionsAsListString(partitionColumns -> "'" + partitionColumns + "'") + "]") + ")", this.tableName, ORIGINAL_SCHEMA), new QueryExecutor.QueryParam[0]);
        this.insertData(this.tableName, 0, "'stringA0'", "0");
    }

    @AfterTestWithContext
    public void dropTestTable() {
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", this.tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"avro"})
    public void testSelectTable() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT string_col FROM %s", this.tableName), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"stringA0"})});
    }

    @Test(groups={"avro"})
    public void testInsertAfterSchemaEvolution() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        this.alterTableSchemaTo(ADDED_COLUMN_SCHEMA);
        this.insertData(this.tableName, 1, "'stringA1'", "1", "101");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0, 100), this.createRow(1, "stringA1", 1, 101)});
    }

    @Test(groups={"avro"})
    public void testSchemaEvolutionWithIncompatibleType() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.columnsInTableStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        this.alterTableSchemaTo(INCOMPATIBLE_TYPE_SCHEMA);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).hasMessageContaining("Found int, expecting string");
    }

    @Test(groups={"avro"})
    public void testSchemaEvolution() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.columnsInTableStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        this.alterTableSchemaTo(CHANGE_COLUMN_TYPE_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.columnsInTableStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "bigint", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        this.alterTableSchemaTo(ADDED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.columnsInTableStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col_added", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0, 100)});
        this.alterTableSchemaTo(REMOVED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.columnsInTableStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, 0)});
        this.alterTableSchemaTo(RENAMED_COLUMN_SCHEMA);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.columnsInTableStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col_renamed", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", null)});
    }

    @Test(groups={"avro"})
    public void testSchemaWhenUrlIsUnset() {
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.columnsInTableStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"string_col", "varchar", "", ""}), QueryAssert.Row.row((Object[])new Object[]{"int_col", "integer", "", ""})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.selectStarStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{this.createRow(0, "stringA0", 0)});
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s UNSET TBLPROPERTIES('avro.schema.url')", this.tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(this.columnsInTableStatement, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(this.prepareShowColumnsResultRows(QueryAssert.Row.row((Object[])new Object[]{"dummy_col", "varchar", "", ""})));
    }

    @Test(groups={"avro"})
    public void testCreateTableLike() {
        String createTableLikeName = this.tableName + "_avro_like";
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (LIKE %s INCLUDING PROPERTIES)", createTableLikeName, this.tableName), new QueryExecutor.QueryParam[0]);
        this.insertData(createTableLikeName, 0, "'stringA0'", "0");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT string_col FROM %s", createTableLikeName), new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"stringA0"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + createTableLikeName, new QueryExecutor.QueryParam[0]);
    }

    private void alterTableSchemaTo(String schema) {
        QueryExecutors.onHive().executeQuery(String.format("ALTER TABLE %s SET TBLPROPERTIES('avro.schema.url'='%s')", this.tableName, schema), new QueryExecutor.QueryParam[0]);
    }

    private void insertData(String tableName, int rowNumber, String ... sqlValues) {
        String columnValues = Joiner.on((String)", ").join((Object[])sqlValues) + (String)(this.varcharPartitionColumns.isEmpty() ? "" : ", " + this.getPartitionsAsListString(partitionColumn -> "'" + partitionColumn + "_" + rowNumber + "'"));
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (%s)", tableName, columnValues), new QueryExecutor.QueryParam[0]);
    }

    private QueryAssert.Row createRow(int rowNumber, Object ... data) {
        ArrayList<Object> rowData = new ArrayList<Object>(Arrays.asList(data));
        this.varcharPartitionColumns.forEach(partition -> rowData.add(partition + "_" + rowNumber));
        return new QueryAssert.Row(rowData);
    }

    private List<QueryAssert.Row> prepareShowColumnsResultRows(QueryAssert.Row ... rows) {
        ImmutableList.Builder rowsWithPartitionsBuilder = ImmutableList.builder();
        rowsWithPartitionsBuilder.add((Object[])rows);
        this.varcharPartitionColumns.stream().map(partition -> QueryAssert.Row.row((Object[])new Object[]{partition, "varchar", "partition key", ""})).forEach(arg_0 -> ((ImmutableList.Builder)rowsWithPartitionsBuilder).add(arg_0));
        return rowsWithPartitionsBuilder.build();
    }

    private String getPartitionsAsListString(Function<String, String> partitionMapper) {
        return this.varcharPartitionColumns.stream().map(partitionMapper).collect(Collectors.joining(", "));
    }
}

