/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.inject.Module;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.initialization.SuiteModuleProvider;
import io.trino.tests.product.hive.HiveVersion;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Optional;
import javax.inject.Singleton;

public class HiveVersionProvider {
    private Optional<HiveVersion> hiveVersion = Optional.empty();

    public synchronized HiveVersion getHiveVersion() {
        this.hiveVersion = this.hiveVersion.or(() -> Optional.of(HiveVersionProvider.detectHiveVersion()));
        return this.hiveVersion.get();
    }

    private static HiveVersion detectHiveVersion() {
        try {
            DatabaseMetaData metaData = QueryExecutors.onHive().getConnection().getMetaData();
            return HiveVersion.createFromString(metaData.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ModuleProvider
    implements SuiteModuleProvider {
        public Module getModule(Configuration configuration) {
            return binder -> binder.bind(HiveVersionProvider.class).in(Singleton.class);
        }
    }
}

