/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.ProductTest;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestComments
extends ProductTest {
    private static final String COMMENT_TABLE_NAME = "comment_test";
    private static final String COMMENT_VIEW_NAME = "comment_view_test";
    private static final String COMMENT_COLUMN_NAME = "comment_column_test";
    private static final String COMMENT_HIVE_VIEW_NAME = "comment_hive_view_test";

    @BeforeTestWithContext
    @AfterTestWithContext
    public void dropTestTable() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS comment_test", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS comment_view_test", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS comment_column_test", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("DROP VIEW IF EXISTS comment_hive_view_test", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"comment"})
    public void testCommentTable() {
        String createTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint\n)\nCOMMENT 'old comment'\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_TABLE_NAME);
        QueryExecutors.onTrino().executeQuery(createTableSql, new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_TABLE_NAME)).isEqualTo("old comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS 'new comment'", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_TABLE_NAME)).isEqualTo("new comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS ''", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_TABLE_NAME)).isEmpty();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON TABLE %s IS NULL", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_TABLE_NAME)).isNull();
    }

    @Test(groups={"comment"})
    public void testCommentView() {
        String createViewSql = String.format("CREATE VIEW hive.default.%s COMMENT 'old comment' AS SELECT 1 AS col", COMMENT_VIEW_NAME);
        QueryExecutors.onTrino().executeQuery(createViewSql, new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_VIEW_NAME)).isEqualTo("old comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON VIEW %s IS 'new comment'", COMMENT_VIEW_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_VIEW_NAME)).isEqualTo("new comment");
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON VIEW %s IS ''", COMMENT_VIEW_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_VIEW_NAME)).isEmpty();
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON VIEW %s IS NULL", COMMENT_VIEW_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)TestComments.getTableComment("hive", "default", COMMENT_VIEW_NAME)).isNull();
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE hive.default.%s (col int)", COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE VIEW default.%s AS SELECT * FROM default.%s", COMMENT_HIVE_VIEW_NAME, COMMENT_TABLE_NAME), new QueryExecutor.QueryParam[0]);
        Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON VIEW %s IS NULL", COMMENT_HIVE_VIEW_NAME), new QueryExecutor.QueryParam[0])).hasMessageContaining("Hive views are not supported");
    }

    private static String getTableComment(String catalogName, String schemaName, String tableName) {
        String sql = "SELECT comment FROM system.metadata.table_comments WHERE catalog_name = '" + catalogName + "' AND schema_name = '" + schemaName + "' AND table_name = '" + tableName + "'";
        QueryResult result = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        return (String)result.row(0).get(0);
    }

    @Test(groups={"comment"})
    public void testCommentColumn() {
        String createTableSql = String.format("CREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'test comment',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\nWITH (\n   format = 'RCBINARY'\n)", COMMENT_COLUMN_NAME);
        QueryExecutors.onTrino().executeQuery(createTableSql, new QueryExecutor.QueryParam[0]);
        String createTableSqlPattern = String.format("\\QCREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'test comment',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\\E(?s:.*)", COMMENT_COLUMN_NAME);
        QueryResult actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_column_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)createTableSqlPattern);
        createTableSqlPattern = String.format("\\QCREATE TABLE hive.default.%s (\n   c1 bigint COMMENT 'new comment',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\\E(?s:.*)", COMMENT_COLUMN_NAME);
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS 'new comment'", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_column_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)createTableSqlPattern);
        createTableSqlPattern = String.format("\\QCREATE TABLE hive.default.%s (\n   c1 bigint COMMENT '',\n   c2 bigint COMMENT '',\n   c3 bigint\n)\\E(?s:.*)", COMMENT_COLUMN_NAME);
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS ''", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_column_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)createTableSqlPattern);
        createTableSqlPattern = String.format("\\QCREATE TABLE hive.default.%s (\n   c1 bigint,\n   c2 bigint COMMENT '',\n   c3 bigint\n)\\E(?s:.*)", COMMENT_COLUMN_NAME);
        QueryExecutors.onTrino().executeQuery(String.format("COMMENT ON COLUMN %s.c1 IS NULL", COMMENT_COLUMN_NAME), new QueryExecutor.QueryParam[0]);
        actualResult = QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE comment_column_test", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat((String)((String)actualResult.row(0).get(0))).matches((CharSequence)createTableSqlPattern);
    }
}

