/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.Iterables;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.utils.QueryExecutors;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestHiveCompression
extends HiveProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)TpchTableDefinitions.ORDERS);
    }

    @Test(groups={"hive_compression"})
    public void testReadTextfileWithLzop() {
        this.testReadCompressedTextfileTable("STORED AS TEXTFILE", "com.hadoop.compression.lzo.LzopCodec", ".*\\.lzo");
    }

    @Test(groups={"hive_compression"})
    public void testReadSequencefileWithLzo() {
        this.testReadCompressedTextfileTable("STORED AS SEQUENCEFILE", "com.hadoop.compression.lzo.LzoCodec", "\\d+_0");
    }

    @Test(groups={"hive_compression"})
    public void testSnappyCompressedParquetTableCreatedInHive() {
        String tableName = "table_hive_parquet_snappy";
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (   c_bigint BIGINT,   c_varchar VARCHAR(255))STORED AS PARQUET TBLPROPERTIES(\"parquet.compression\"=\"SNAPPY\")", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s VALUES(1, 'test data')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test data"})});
        QueryExecutors.onHive().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_compression"})
    public void testSnappyCompressedParquetTableCreatedInTrino() {
        this.testSnappyCompressedParquetTableCreatedInTrino(false);
    }

    @Test(groups={"hive_compression"})
    public void testSnappyCompressedParquetTableCreatedInTrinoWithNativeWriter() {
        this.testSnappyCompressedParquetTableCreatedInTrino(true);
    }

    private void testSnappyCompressedParquetTableCreatedInTrino(boolean optimizedParquetWriter) {
        String tableName = "table_trino_parquet_snappy" + (optimizedParquetWriter ? "_native_writer" : "");
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (   c_bigint BIGINT,   c_varchar VARCHAR(255))WITH (format='PARQUET')", tableName), new QueryExecutor.QueryParam[0]);
        String catalog = (String)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)QueryExecutors.onTrino().executeQuery("SELECT CURRENT_CATALOG", new QueryExecutor.QueryParam[0]).rows())));
        QueryExecutors.onTrino().executeQuery("SET SESSION " + catalog + ".compression_codec = 'SNAPPY'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("SET SESSION " + catalog + ".experimental_parquet_optimized_writer_enabled = " + optimizedParquetWriter, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES(1, 'test data')", tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test data"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, "test data"})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadCompressedTextfileTable(String tableStorageDefinition, String compressionCodec, @Language(value="RegExp") String expectedFileNamePattern) {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_read_compressed", new QueryExecutor.QueryParam[0]);
        try {
            QueryExecutors.onHive().executeQuery("SET hive.exec.compress.output=true", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("SET mapreduce.output.fileoutputformat.compress=true", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("SET mapreduce.output.fileoutputformat.compress.codec=" + compressionCodec, new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("CREATE TABLE test_read_compressed " + tableStorageDefinition + " AS SELECT * FROM orders", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT count(*) FROM test_read_compressed", new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1500000})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT sum(o_orderkey) FROM test_read_compressed", new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{4499987250000L})});
            Assertions.assertThat((String)((String)QueryExecutors.onTrino().executeQuery("SELECT regexp_replace(\"$path\", '.*/') FROM test_read_compressed LIMIT 1", new QueryExecutor.QueryParam[0]).row(0).get(0))).matches((CharSequence)expectedFileNamePattern);
        }
        finally {
            QueryExecutors.onHive().executeQuery("RESET", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS test_read_compressed", new QueryExecutor.QueryParam[0]);
        }
    }
}

