/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveCreateTable
extends ProductTest {
    @Test(groups={"storage_formats"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testCreateTable() throws SQLException {
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_create_table(a bigint, b varchar, c smallint) WITH (format='ORC')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO test_create_table(a, b, c) VALUES (NULL, NULL, NULL), (-42, 'abc', SMALLINT '-127'), (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz', SMALLINT '32767')", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_create_table", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc", -127}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz", Short.MAX_VALUE})});
        Assertions.assertThat(TestHiveCreateTable.getTableProperty("test_create_table", "transactional")).isIn(new Object[]{Optional.empty(), Optional.of("false")});
        QueryExecutors.onTrino().executeQuery("DROP TABLE test_create_table", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testCreateTableAsSelect() throws SQLException {
        QueryExecutors.onTrino().executeQuery("CREATE TABLE test_create_table_as_select WITH (format='ORC') AS SELECT * FROM (VALUES   (NULL, NULL, NULL),   (-42, 'abc', SMALLINT '-127'),   (9223372036854775807, 'abcdefghijklmnopqrstuvwxyz', SMALLINT '32767')) t(a, b, c)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM test_create_table_as_select", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{null, null, null}), QueryAssert.Row.row((Object[])new Object[]{-42, "abc", -127}), QueryAssert.Row.row((Object[])new Object[]{Long.MAX_VALUE, "abcdefghijklmnopqrstuvwxyz", Short.MAX_VALUE})});
        Assertions.assertThat(TestHiveCreateTable.getTableProperty("test_create_table_as_select", "transactional")).isIn(new Object[]{Optional.empty(), Optional.of("false")});
        QueryExecutors.onTrino().executeQuery("DROP TABLE test_create_table_as_select", new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hdp3_only", "profile_specific_tests"})
    public void testVerifyEnvironmentHiveTransactionalByDefault() throws SQLException {
        QueryExecutors.onHive().executeQuery("CREATE TABLE test_hive_transactional_by_default(a bigint) STORED AS ORC", new QueryExecutor.QueryParam[0]);
        Assertions.assertThat(TestHiveCreateTable.getTableProperty("test_hive_transactional_by_default", "transactional")).contains((Object)"true");
        QueryExecutors.onHive().executeQuery("DROP TABLE test_hive_transactional_by_default", new QueryExecutor.QueryParam[0]);
    }

    private static Optional<String> getTableProperty(String tableName, String propertyName) throws SQLException {
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        try (Statement statement = QueryExecutors.onHive().getConnection().createStatement();
             ResultSet resultSet = statement.executeQuery("SHOW TBLPROPERTIES " + tableName);){
            while (resultSet.next()) {
                if (!propertyName.equals(resultSet.getString("prpt_name"))) continue;
                Optional<String> optional = Optional.of(resultSet.getString("prpt_value"));
                return optional;
            }
        }
        return Optional.empty();
    }
}

