/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveSparkCompatibility
extends ProductTest {
    private static final String TRINO_CATALOG = "hive";
    private static final String[] HIVE_TIMESTAMP_PRECISIONS = new String[]{"MILLISECONDS", "MICROSECONDS", "NANOSECONDS"};

    @Test(groups={"hive_spark", "profile_specific_tests"}, dataProvider="testReadSparkCreatedTableDataProvider")
    public void testReadSparkCreatedTable(String sparkTableFormat, String expectedTrinoTableFormat) {
        String sparkTableName = "spark_created_table_" + sparkTableFormat.replaceAll("[^a-zA-Z]", "").toLowerCase(Locale.ENGLISH) + "_" + TemporaryHiveTable.randomTableSuffix();
        String trinoTableName = String.format("%s.default.%s", TRINO_CATALOG, sparkTableName);
        QueryExecutors.onSpark().executeQuery("CREATE TABLE default." + sparkTableName + "(   a_boolean boolean,   a_tinyint tinyint,   a_smallint smallint,   an_integer int,   a_bigint bigint,   a_real float,   a_double double,   a_short_decimal decimal(11, 4),   a_long_decimal decimal(26, 7),   a_string string,   a_date date,   a_timestamp_seconds timestamp,   a_timestamp_millis timestamp,   a_timestamp_micros timestamp,   a_timestamp_nanos timestamp,   a_dummy string) " + sparkTableFormat + " TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery("INSERT INTO " + sparkTableName + " VALUES (" + String.join((CharSequence)",", Collections.nCopies(16, "NULL")) + ")", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery("INSERT INTO " + sparkTableName + " VALUES (true, 127, 32767, 1000000000, 1000000000000000, 10000000.123, 100000000000.123, CAST('1234567.8901' AS decimal(11, 4)), CAST('1234567890123456789.0123456' AS decimal(26, 7)), 'some string', DATE '2005-09-10', TIMESTAMP '2005-09-10 13:00:00', TIMESTAMP '2005-09-10 13:00:00.123', TIMESTAMP '2005-09-10 13:00:00.123456', TIMESTAMP '2005-09-10 13:00:00.123456789', 'dummy')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery("INSERT INTO " + sparkTableName + " VALUES (false, -128, -32768, -1000000012, -1000000000000012, -10000000.123, -100000000000.123, CAST('-1234567.8901' AS decimal(11, 4)), CAST('-1234567890123456789.0123456' AS decimal(26, 7)), '', DATE '1965-09-10', TIMESTAMP '1965-09-10 13:00:00', TIMESTAMP '1965-09-10 13:00:00.123', TIMESTAMP '1965-09-10 13:00:00.123456', TIMESTAMP '1965-09-10 13:00:00.123456789', 'dummy')", new QueryExecutor.QueryParam[0]);
        List<QueryAssert.Row> expected = List.of(QueryAssert.Row.row((Object[])Collections.nCopies(16, null).toArray()), QueryAssert.Row.row((Object[])new Object[]{true, (byte)127, (short)Short.MAX_VALUE, 1000000000, 1000000000000000L, Float.valueOf(1.0E7f), 1.00000000000123E11, new BigDecimal("1234567.8901"), new BigDecimal("1234567890123456789.0123456"), "some string", Date.valueOf(LocalDate.of(2005, 9, 10)), Timestamp.valueOf(LocalDateTime.of(2005, 9, 10, 13, 0, 0)), Timestamp.valueOf(LocalDateTime.of(2005, 9, 10, 13, 0, 0, 123000000)), Timestamp.valueOf(LocalDateTime.of(2005, 9, 10, 13, 0, 0, 123456000)), Timestamp.valueOf(LocalDateTime.of(2005, 9, 10, 13, 0, 0, 123456000)), "dummy"}), QueryAssert.Row.row((Object[])new Object[]{false, (byte)-128, (short)Short.MIN_VALUE, -1000000012, -1000000000000012L, Float.valueOf(-1.0E7f), -1.00000000000123E11, new BigDecimal("-1234567.8901"), new BigDecimal("-1234567890123456789.0123456"), "", Date.valueOf(LocalDate.of(1965, 9, 10)), Timestamp.valueOf(LocalDateTime.of(1965, 9, 10, 13, 0, 0)), Timestamp.valueOf(LocalDateTime.of(1965, 9, 10, 13, 0, 0, 123000000)), Timestamp.valueOf(LocalDateTime.of(1965, 9, 10, 13, 0, 0, 123456000)), Timestamp.valueOf(LocalDateTime.of(1965, 9, 10, 13, 0, 0, 123456000)), "dummy"}));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0])).containsOnly(expected);
        QueryExecutors.onTrino().executeQuery("SET SESSION hive.timestamp_precision = 'NANOSECONDS'", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(expected);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{String.format("CREATE TABLE %s (\n   a_boolean boolean,\n   a_tinyint tinyint,\n   a_smallint smallint,\n   an_integer integer,\n   a_bigint bigint,\n   a_real real,\n   a_double double,\n   a_short_decimal decimal(11, 4),\n   a_long_decimal decimal(26, 7),\n   a_string varchar,\n   a_date date,\n   a_timestamp_seconds timestamp(9),\n   a_timestamp_millis timestamp(9),\n   a_timestamp_micros timestamp(9),\n   a_timestamp_nanos timestamp(9),\n   a_dummy varchar\n)\nWITH (\n   format = '%s'\n)", trinoTableName, expectedTrinoTableFormat)})});
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + sparkTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_spark", "profile_specific_tests"}, dataProvider="sparkParquetTimestampFormats")
    public void testSparkParquetTimestampCompatibility(String sparkTimestampFormat, String sparkTimestamp, String[] expectedValues) {
        String sparkTableName = "test_spark_parquet_timestamp_compatibility_" + sparkTimestampFormat.toLowerCase(Locale.ENGLISH) + "_" + TemporaryHiveTable.randomTableSuffix();
        String trinoTableName = String.format("%s.default.%s", TRINO_CATALOG, sparkTableName);
        QueryExecutors.onSpark().executeQuery("SET spark.sql.parquet.outputTimestampType = " + sparkTimestampFormat, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery("CREATE TABLE default." + sparkTableName + "(a_timestamp timestamp) USING PARQUET TBLPROPERTIES ('transactional'='false')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery("INSERT INTO " + sparkTableName + " VALUES (TIMESTAMP '" + sparkTimestamp + "')", new QueryExecutor.QueryParam[0]);
        for (int i = 0; i < HIVE_TIMESTAMP_PRECISIONS.length; ++i) {
            String trinoTimestampPrecision = HIVE_TIMESTAMP_PRECISIONS[i];
            String expected = expectedValues[i];
            QueryExecutors.onTrino().executeQuery("SET SESSION hive.timestamp_precision = '" + trinoTimestampPrecision + "'", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{Timestamp.valueOf(expected)})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT count(*) FROM " + trinoTableName + " WHERE a_timestamp = TIMESTAMP '" + expected + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT count(*) FROM " + trinoTableName + " WHERE a_timestamp != TIMESTAMP '" + expected + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
        }
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + sparkTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testInsertFailsOnBucketedTableCreatedBySpark() {
        String hiveTableName = "spark_insert_bucketed_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onSpark().executeQuery("CREATE TABLE default." + hiveTableName + "(a_key integer, a_value integer) USING PARQUET CLUSTERED BY (a_key) INTO 3 BUCKETS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("INSERT INTO default." + hiveTableName + " VALUES (1, 100)", new QueryExecutor.QueryParam[0])).hasMessageContaining("Inserting into Spark bucketed tables is not supported");
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testUpdateFailsOnBucketedTableCreatedBySpark() {
        String hiveTableName = "spark_update_bucketed_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onSpark().executeQuery("CREATE TABLE default." + hiveTableName + "(a_key integer, a_value integer) USING ORC CLUSTERED BY (a_key) INTO 3 BUCKETS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE default." + hiveTableName + " SET a_value = 100 WHERE a_key = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Updating Spark bucketed tables is not supported");
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testDeleteFailsOnBucketedTableCreatedBySpark() {
        String hiveTableName = "spark_delete_bucketed_table_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onSpark().executeQuery("CREATE TABLE default." + hiveTableName + "(a_key integer, a_value integer) USING ORC CLUSTERED BY (a_key) INTO 3 BUCKETS", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("DELETE FROM default." + hiveTableName + " WHERE a_key = 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Deleting from Spark bucketed tables is not supported");
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + hiveTableName, new QueryExecutor.QueryParam[0]);
    }

    @DataProvider
    public static Object[][] sparkParquetTimestampFormats() {
        String millisTimestamp = "2005-09-10 13:00:00.123";
        String microsTimestamp = "2005-09-10 13:00:00.123456";
        String nanosTimestamp = "2005-09-10 13:00:00.123456789";
        return new Object[][]{{"TIMESTAMP_MILLIS", millisTimestamp, new String[]{millisTimestamp, millisTimestamp, millisTimestamp}}, {"TIMESTAMP_MICROS", microsTimestamp, new String[]{millisTimestamp, microsTimestamp, microsTimestamp}}, {"INT96", nanosTimestamp, new String[]{millisTimestamp, microsTimestamp, microsTimestamp}}};
    }

    @DataProvider
    public static Object[][] testReadSparkCreatedTableDataProvider() {
        return new Object[][]{{"USING ORC", "ORC"}, {"USING PARQUET", "PARQUET"}};
    }

    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testReadTrinoCreatedOrcTable() {
        this.testReadTrinoCreatedTable("using_orc", "ORC");
    }

    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testReadTrinoCreatedParquetTable() {
        this.testReadTrinoCreatedTable("using_parquet", "PARQUET");
    }

    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testReadTrinoCreatedParquetTableWithNativeWriter() {
        QueryExecutors.onTrino().executeQuery("SET SESSION hive.experimental_parquet_optimized_writer_enabled = true", new QueryExecutor.QueryParam[0]);
        this.testReadTrinoCreatedTable("using_native_parquet", "PARQUET");
    }

    private void testReadTrinoCreatedTable(String tableName, String tableFormat) {
        String sparkTableName = "trino_created_table_" + tableName + "_" + TemporaryHiveTable.randomTableSuffix();
        String trinoTableName = String.format("%s.default.%s", TRINO_CATALOG, sparkTableName);
        QueryExecutors.onTrino().executeQuery("SET SESSION hive.timestamp_precision = 'MICROSECONDS'", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (    a_boolean boolean,    a_tinyint tinyint,    a_smallint smallint,    an_integer integer,    a_bigint bigint,    a_real real,    a_double double,    a_short_decimal decimal(11, 4),    a_long_decimal decimal(26, 7),    a_string varchar,    a_date date,    a_timestamp_seconds timestamp(6),    a_timestamp_millis timestamp(6),    a_timestamp_micros timestamp(6),    a_dummy varchar ) WITH (    format = '%s' )", trinoTableName, tableFormat), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + trinoTableName + " VALUES (" + String.join((CharSequence)",", Collections.nCopies(15, "NULL")) + ")", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + trinoTableName + " VALUES (true, 127, 32767, 1000000000, 1000000000000000, 10000000.123, 100000000000.123, CAST('1234567.8901' AS decimal(11, 4)), CAST('1234567890123456789.0123456' AS decimal(26, 7)), 'some string', DATE '2005-09-10', TIMESTAMP '2005-09-10 13:00:00', TIMESTAMP '2005-09-10 13:00:00.123', TIMESTAMP '2005-09-10 13:00:00.123456', 'dummy')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + trinoTableName + " VALUES (false, -128, -32768, -1000000012, -1000000000000012, -10000000.123, -100000000000.123, CAST('-1234567.8901' AS decimal(11, 4)), CAST('-1234567890123456789.0123456' AS decimal(26, 7)), '', DATE '1965-09-10', TIMESTAMP '1965-09-10 13:00:00', TIMESTAMP '1965-09-10 13:00:00.123', TIMESTAMP '1965-09-10 13:00:00.123456', 'dummy')", new QueryExecutor.QueryParam[0]);
        List<QueryAssert.Row> expected = List.of(QueryAssert.Row.row((Object[])Collections.nCopies(15, null).toArray()), QueryAssert.Row.row((Object[])new Object[]{true, (byte)127, (short)Short.MAX_VALUE, 1000000000, 1000000000000000L, Float.valueOf(1.0E7f), 1.00000000000123E11, new BigDecimal("1234567.8901"), new BigDecimal("1234567890123456789.0123456"), "some string", Date.valueOf(LocalDate.of(2005, 9, 10)), Timestamp.valueOf(LocalDateTime.of(2005, 9, 10, 13, 0, 0)), Timestamp.valueOf(LocalDateTime.of(2005, 9, 10, 13, 0, 0, 123000000)), Timestamp.valueOf(LocalDateTime.of(2005, 9, 10, 13, 0, 0, 123456000)), "dummy"}), QueryAssert.Row.row((Object[])new Object[]{false, (byte)-128, (short)Short.MIN_VALUE, -1000000012, -1000000000000012L, Float.valueOf(-1.0E7f), -1.00000000000123E11, new BigDecimal("-1234567.8901"), new BigDecimal("-1234567890123456789.0123456"), "", Date.valueOf(LocalDate.of(1965, 9, 10)), Timestamp.valueOf(LocalDateTime.of(1965, 9, 10, 13, 0, 0)), Timestamp.valueOf(LocalDateTime.of(1965, 9, 10, 13, 0, 0, 123000000)), Timestamp.valueOf(LocalDateTime.of(1965, 9, 10, 13, 0, 0, 123456000)), "dummy"}));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onSpark().executeQuery("SELECT * FROM " + sparkTableName, new QueryExecutor.QueryParam[0])).containsOnly(expected);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(expected);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + trinoTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testReadSparkdDateAndTimePartitionName() {
        String sparkTableName = "test_trino_reading_spark_date_and_time_type_partitioned_" + TemporaryHiveTable.randomTableSuffix();
        String trinoTableName = String.format("%s.default.%s", TRINO_CATALOG, sparkTableName);
        QueryExecutors.onSpark().executeQuery(String.format("CREATE TABLE default.%s (value integer) PARTITIONED BY (dt date)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s PARTITION(dt='2022-04-13 00:00:00.000000000') VALUES (1)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s PARTITION(dt='2022-04-13 00:00:00') VALUES (2)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s PARTITION(dt='2022-04-13 00:00') VALUES (3)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s PARTITION(dt='12345-06-07') VALUES (4)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s PARTITION(dt='123-04-05') VALUES (5)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s PARTITION(dt='-0001-01-01') VALUES (6)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT \"$partition\" FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(List.of(QueryAssert.Row.row((Object[])new Object[]{"dt=2022-04-13 00%3A00%3A00.000000000"}), QueryAssert.Row.row((Object[])new Object[]{"dt=2022-04-13 00%3A00%3A00"}), QueryAssert.Row.row((Object[])new Object[]{"dt=2022-04-13 00%3A00"}), QueryAssert.Row.row((Object[])new Object[]{"dt=12345-06-07"}), QueryAssert.Row.row((Object[])new Object[]{"dt=123-04-05"}), QueryAssert.Row.row((Object[])new Object[]{"dt=-0001-01-01"})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onSpark().executeQuery("SELECT value, date_format(dt, 'yyyy-MM-dd') FROM " + sparkTableName, new QueryExecutor.QueryParam[0])).containsOnly(List.of(QueryAssert.Row.row((Object[])new Object[]{1, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{2, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{3, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{4, "+12345-06-07"}), QueryAssert.Row.row((Object[])new Object[]{5, null}), QueryAssert.Row.row((Object[])new Object[]{6, "-0001-01-01"})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT value, date_format(dt, 'yyyy-MM-dd') FROM " + sparkTableName, new QueryExecutor.QueryParam[0])).containsOnly(List.of(QueryAssert.Row.row((Object[])new Object[]{1, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{2, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{3, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{4, "12345-06-07"}), QueryAssert.Row.row((Object[])new Object[]{5, "0123-04-06"}), QueryAssert.Row.row((Object[])new Object[]{6, "0002-01-03"})));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT value, CAST(dt AS VARCHAR) FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(List.of(QueryAssert.Row.row((Object[])new Object[]{1, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{2, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{3, "2022-04-13"}), QueryAssert.Row.row((Object[])new Object[]{4, "12345-06-07"}), QueryAssert.Row.row((Object[])new Object[]{5, "0123-04-05"}), QueryAssert.Row.row((Object[])new Object[]{6, "-0001-01-01"})));
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + trinoTableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"hive_spark", "profile_specific_tests"}, dataProvider="unsupportedPartitionDates")
    public void testReadSparkInvalidDatePartitionName(String inputDate, Date outputDate) {
        String sparkTableName = "test_trino_reading_spark_invalid_date_type_partitioned_" + TemporaryHiveTable.randomTableSuffix();
        String trinoTableName = String.format("%s.default.%s", TRINO_CATALOG, sparkTableName);
        QueryExecutors.onSpark().executeQuery(String.format("CREATE TABLE default.%s (value integer) PARTITIONED BY (dt date)", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s PARTITION(dt='%s') VALUES (1)", sparkTableName, inputDate), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT value, dt FROM " + sparkTableName, new QueryExecutor.QueryParam[0])).containsOnly(List.of(QueryAssert.Row.row((Object[])new Object[]{1, outputDate})));
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT value, dt FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Invalid partition value");
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + trinoTableName, new QueryExecutor.QueryParam[0]);
    }

    @DataProvider
    public static Object[][] unsupportedPartitionDates() {
        return new Object[][]{{"1965-09-10 23:59:59.999999999", Date.valueOf(LocalDate.of(1965, 9, 10))}, {"1965-09-10 23:59:59", Date.valueOf(LocalDate.of(1965, 9, 10))}, {"1965-09-10 23:59", Date.valueOf(LocalDate.of(1965, 9, 10))}, {"1965-09-10 00", Date.valueOf(LocalDate.of(1965, 9, 10))}, {"2021-02-30", Date.valueOf(LocalDate.of(2021, 3, 2))}, {"1965-09-10 invalid", Date.valueOf(LocalDate.of(1965, 9, 10))}, {"invalid date", null}};
    }

    @Test(groups={"hive_spark", "profile_specific_tests"})
    public void testReadSparkBucketedTable() {
        String sparkTableName = "test_trino_reading_spark_native_buckets_" + TemporaryHiveTable.randomTableSuffix();
        String trinoTableName = String.format("%s.default.%s", TRINO_CATALOG, sparkTableName);
        QueryExecutors.onSpark().executeQuery(String.format("CREATE TABLE `default`.`%s` (\n  `a_string` STRING,\n  `a_bigint` BIGINT,\n  `an_integer` INT,\n  `a_real` FLOAT,\n  `a_double` DOUBLE,\n  `a_boolean` BOOLEAN)\nUSING ORC\nCLUSTERED BY (a_string)\nINTO 4 BUCKETS\nTBLPROPERTIES ('transactional'='false')", sparkTableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onSpark().executeQuery(String.format("INSERT INTO %s VALUES ('one', 1000000000000000, 1000000000, 10000000.123, 100000000000.123, true), ('two', -1000000000000000, -1000000000, -10000000.123, -100000000000.123, false), ('three', 2000000000000000, 2000000000, 20000000.123, 200000000000.123, true), ('four', -2000000000000000, -2000000000, -20000000.123, -200000000000.123, false)", sparkTableName), new QueryExecutor.QueryParam[0]);
        List<QueryAssert.Row> expected = List.of(QueryAssert.Row.row((Object[])new Object[]{"one", 1000000000000000L, 1000000000, Float.valueOf(1.0E7f), 1.00000000000123E11, true}), QueryAssert.Row.row((Object[])new Object[]{"two", -1000000000000000L, -1000000000, Float.valueOf(-1.0E7f), -1.00000000000123E11, false}), QueryAssert.Row.row((Object[])new Object[]{"three", 2000000000000000L, 2000000000, Float.valueOf(2.0E7f), 2.00000000000123E11, true}), QueryAssert.Row.row((Object[])new Object[]{"four", -2000000000000000L, -2000000000, Float.valueOf(-2.0E7f), -2.00000000000123E11, false}));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onSpark().executeQuery("SELECT a_string, a_bigint, an_integer, a_real, a_double, a_boolean FROM " + sparkTableName, new QueryExecutor.QueryParam[0])).containsOnly(expected);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT a_string, a_bigint, an_integer, a_real, a_double, a_boolean FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(expected);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW CREATE TABLE " + trinoTableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{String.format("CREATE TABLE %s (\n   a_string varchar,\n   a_bigint bigint,\n   an_integer integer,\n   a_real real,\n   a_double double,\n   a_boolean boolean\n)\nWITH (\n   format = 'ORC'\n)", trinoTableName)})});
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("SELECT a_string, a_bigint, an_integer, a_real, a_double, a_boolean, \"$bucket\" FROM " + trinoTableName, new QueryExecutor.QueryParam[0])).hasMessageContaining("Column '$bucket' cannot be resolved");
        QueryExecutors.onSpark().executeQuery("DROP TABLE " + sparkTableName, new QueryExecutor.QueryParam[0]);
    }
}

