/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksUpdates
extends BaseTestDeltaLakeS3Storage {
    @Test(groups={"delta-lake-databricks", "delta-lake-oss", "profile_specific_tests"})
    public void testUpdateOnAppendOnlyTableFails() {
        String tableName = "test_update_on_append_only_table_fails_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onDelta().executeQuery("CREATE TABLE default." + tableName + "         (a INT, b INT)         USING delta          LOCATION 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "'          TBLPROPERTIES ('delta.appendOnly' = true)", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1,11), (2, 12)", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onDelta().executeQuery("UPDATE default." + tableName + " SET a = a + 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("This table is configured to only allow appends");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("UPDATE default." + tableName + " SET a = a + 1", new QueryExecutor.QueryParam[0])).hasMessageContaining("Cannot update rows from a table with 'delta.appendOnly' set to true");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT * FROM default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1, 11}), QueryAssert.Row.row((Object[])new Object[]{2, 12})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testUpdatesFromDatabricks() {
        String tableName = "test_updates_" + TemporaryHiveTable.randomTableSuffix();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("CREATE TABLE delta.default.\"" + tableName + "\" (id, value) WITH (location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "') AS VALUES   (1, 'Poland'), (2, 'Germany'), (3, 'Romania')", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
        try {
            QueryResult databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryResult prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsExactly(TestDeltaLakeDatabricksUpdates.toRows(prestoResult));
            QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'France' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0]);
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsExactly(TestDeltaLakeDatabricksUpdates.toRows(prestoResult));
            QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'Spain' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0]);
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsExactly(TestDeltaLakeDatabricksUpdates.toRows(prestoResult));
            QueryExecutors.onDelta().executeQuery(String.format("UPDATE default.%s SET value = 'Portugal' WHERE id = 2", tableName), new QueryExecutor.QueryParam[0]);
            databricksResult = QueryExecutors.onDelta().executeQuery(String.format("SELECT * FROM default.%s ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            prestoResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM delta.default.\"%s\" ORDER BY id", tableName), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat((QueryResult)databricksResult).containsExactly(TestDeltaLakeDatabricksUpdates.toRows(prestoResult));
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    private static List<QueryAssert.Row> toRows(QueryResult result) {
        return (List)result.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList());
    }
}

