/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.testng.Assert;

public class TransactionLogAssertions {
    private TransactionLogAssertions() {
    }

    public static void assertLastEntryIsCheckpointed(AmazonS3 s3Client, String bucketName, String tableName) {
        Optional lastJsonEntry = TransactionLogAssertions.listJsonLogEntries(s3Client, bucketName, tableName).stream().max(String::compareTo);
        Assertions.assertThat(lastJsonEntry).isPresent();
        Optional lastCheckpointEntry = TransactionLogAssertions.listCheckpointEntries(s3Client, bucketName, tableName).stream().max(String::compareTo);
        Assertions.assertThat(lastCheckpointEntry).isPresent();
        Assert.assertEquals((String)((String)lastJsonEntry.get()).replace(".json", ""), (String)((String)lastCheckpointEntry.get()).replace(".checkpoint.parquet", ""));
    }

    public static void assertTransactionLogVersion(AmazonS3 s3Client, String bucketName, String tableName, int versionNumber) {
        Optional lastJsonEntry = TransactionLogAssertions.listJsonLogEntries(s3Client, bucketName, tableName).stream().max(String::compareTo);
        Assertions.assertThat(lastJsonEntry).isPresent();
        Assert.assertEquals((String)((String)lastJsonEntry.get()), (String)String.format("%020d.json", versionNumber));
    }

    public static void assertNewVersion(AmazonS3 s3Client, String bucketName, String tableName, Assert.ThrowingRunnable runnable) {
        long initialVersion = TransactionLogAssertions.getTransactionLogVersion(s3Client, bucketName, tableName);
        try {
            runnable.run();
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        Assertions.assertThat((long)TransactionLogAssertions.getTransactionLogVersion(s3Client, bucketName, tableName)).isGreaterThan(initialVersion);
    }

    public static void assertNoNewVersion(AmazonS3 s3Client, String bucketName, String tableName, Assert.ThrowingRunnable runnable) {
        long initialVersion = TransactionLogAssertions.getTransactionLogVersion(s3Client, bucketName, tableName);
        try {
            runnable.run();
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        Assertions.assertThat((long)TransactionLogAssertions.getTransactionLogVersion(s3Client, bucketName, tableName)).isEqualTo(initialVersion);
    }

    private static long getTransactionLogVersion(AmazonS3 s3Client, String bucketName, String tableName) {
        Optional lastJsonEntry = TransactionLogAssertions.listJsonLogEntries(s3Client, bucketName, tableName).stream().max(String::compareTo);
        if (lastJsonEntry.isEmpty()) {
            Assert.fail((String)("Cannot determine version for table " + tableName));
        }
        return Long.parseLong(((String)lastJsonEntry.get()).split("\\.")[0]);
    }

    private static List<String> listJsonLogEntries(AmazonS3 s3Client, String bucketName, String tableName) {
        return TransactionLogAssertions.listLogEntries(s3Client, bucketName, tableName, file -> file.endsWith(".json"));
    }

    private static List<String> listCheckpointEntries(AmazonS3 s3Client, String bucketName, String tableName) {
        return TransactionLogAssertions.listLogEntries(s3Client, bucketName, tableName, file -> file.endsWith(".checkpoint.parquet"));
    }

    private static List<String> listLogEntries(AmazonS3 s3Client, String bucketName, String tableName, Predicate<String> fileFilter) {
        String prefix = "databricks-compatibility-test-" + tableName + "/_delta_log/";
        ListObjectsV2Result listResult = s3Client.listObjectsV2(bucketName, prefix);
        return (List)listResult.getObjectSummaries().stream().map(s3Object -> {
            String[] path = s3Object.getKey().split("/");
            return path[path.length - 1];
        }).filter(fileFilter).collect(ImmutableList.toImmutableList());
    }
}

