/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.Verify;
import com.google.common.primitives.Longs;
import io.trino.tempto.ProductTest;
import io.trino.tempto.Requires;
import io.trino.tempto.fulfillment.table.hive.tpch.ImmutableTpchTablesRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.hive.util.TableLocationUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Requires(value={ImmutableTpchTablesRequirements.ImmutableNationTable.class})
public class TestHiveBasicTableStatistics
extends ProductTest {
    @Test
    public void testCreateUnpartitioned() {
        String tableName = "test_basic_statistics_unpartitioned_ctas_presto";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM nation", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics statistics = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsAreNonZero(statistics);
            Assertions.assertThat((long)statistics.getNumRows().getAsLong()).isEqualTo(25L);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateExternalUnpartitioned() {
        String tableName = "test_basic_statistics_external_unpartitioned_presto";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        try {
            String location = TableLocationUtils.getTableLocation("nation");
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (   n_nationkey bigint,    n_regionkey bigint,    n_name varchar(25),    n_comment varchar(152)) WITH (external_location = '%s', format = 'TEXTFILE', textfile_field_separator = '|')", tableName, location), new QueryExecutor.QueryParam[0]);
            BasicStatistics statistics = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsAreNotPresent(statistics);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test
    public void testCreateTableWithNoData() {
        String tableName = "test_basic_statistics_unpartitioned_ctas_presto_with_no_data";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s AS SELECT * FROM nation WITH NO DATA", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics statistics = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsAreZero(statistics);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertUnpartitioned() {
        String tableName = "test_basic_statistics_unpartitioned_insert_presto";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (   n_nationkey bigint,    n_regionkey bigint,    n_name varchar(25),    n_comment varchar(152))", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics statisticsEmpty = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsAreZero(statisticsEmpty);
            TestHiveBasicTableStatistics.insertNationData(QueryExecutors.onTrino(), tableName);
            BasicStatistics statisticsFirstInsert = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsAreNonZero(statisticsFirstInsert);
            Assertions.assertThat((long)statisticsFirstInsert.getNumRows().getAsLong()).isEqualTo(25L);
            TestHiveBasicTableStatistics.insertNationData(QueryExecutors.onTrino(), tableName);
            BasicStatistics statisticsSecondInsert = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsAreNonZero(statisticsSecondInsert);
            TestHiveBasicTableStatistics.assertThatStatisticsValuesHaveIncreased(statisticsFirstInsert, statisticsSecondInsert);
            Assertions.assertThat((long)statisticsSecondInsert.getNumRows().getAsLong()).isEqualTo(50L);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreatePartitioned() {
        String tableName = "test_basic_statistics_partitioned_ctas_presto";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s WITH (   partitioned_by = ARRAY['n_regionkey'] ) AS SELECT n_nationkey, n_name, n_comment, n_regionkey FROM nation WHERE n_nationkey <> 23", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics tableStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            if (tableStatistics.getNumRows().isEmpty()) {
                TestHiveBasicTableStatistics.assertThatStatisticsAreNotPresent(tableStatistics);
            }
            BasicStatistics firstPartitionStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=1");
            TestHiveBasicTableStatistics.assertThatStatisticsAreNonZero(firstPartitionStatistics);
            Assertions.assertThat((long)firstPartitionStatistics.getNumRows().getAsLong()).isEqualTo(5L);
            BasicStatistics secondPartitionStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=3");
            TestHiveBasicTableStatistics.assertThatStatisticsAreNonZero(secondPartitionStatistics);
            Assertions.assertThat((long)secondPartitionStatistics.getNumRows().getAsLong()).isEqualTo(4L);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnalyzePartitioned() {
        String tableName = "test_basic_statistics_analyze_partitioned";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s WITH (    partitioned_by = ARRAY['n_regionkey'],    bucketed_by = ARRAY['n_nationkey'],    bucket_count = 10 ) AS SELECT n_nationkey, n_name, n_comment, n_regionkey FROM nation WHERE n_regionkey = 1", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics tableStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            if (tableStatistics.getNumRows().isEmpty()) {
                TestHiveBasicTableStatistics.assertThatStatisticsAreNotPresent(tableStatistics);
            }
            BasicStatistics partitionStatisticsBefore = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=1");
            TestHiveBasicTableStatistics.assertThatStatisticsArePresent(partitionStatisticsBefore);
            QueryExecutors.onTrino().executeQuery(String.format("ANALYZE %s", tableName), new QueryExecutor.QueryParam[0]);
            BasicStatistics partitionStatisticsAfter = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=1");
            TestHiveBasicTableStatistics.assertThatStatisticsArePresent(partitionStatisticsAfter);
            Assertions.assertThat((long)partitionStatisticsBefore.getNumRows().getAsLong()).isEqualTo(partitionStatisticsAfter.getNumRows().getAsLong());
            Assertions.assertThat((long)partitionStatisticsBefore.getNumFiles().getAsLong()).isEqualTo(partitionStatisticsAfter.getNumFiles().getAsLong());
            Assertions.assertThat((long)partitionStatisticsBefore.getRawDataSize().getAsLong()).isEqualTo(partitionStatisticsAfter.getRawDataSize().getAsLong());
            Assertions.assertThat((long)partitionStatisticsBefore.getTotalSize().getAsLong()).isEqualTo(partitionStatisticsAfter.getTotalSize().getAsLong());
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnalyzeUnpartitioned() {
        String tableName = "test_basic_statistics_analyze_unpartitioned";
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s AS SELECT n_nationkey, n_name, n_comment, n_regionkey FROM nation WHERE n_regionkey = 1", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics tableStatisticsBefore = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsArePresent(tableStatisticsBefore);
            QueryExecutors.onTrino().executeQuery(String.format("ANALYZE %s", tableName), new QueryExecutor.QueryParam[0]);
            BasicStatistics tableStatisticsAfter = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsArePresent(tableStatisticsAfter);
            Assertions.assertThat((OptionalLong)tableStatisticsBefore.getNumRows()).isEqualTo((Object)tableStatisticsAfter.getNumRows());
            Assertions.assertThat((OptionalLong)tableStatisticsBefore.getNumFiles()).isEqualTo((Object)tableStatisticsAfter.getNumFiles());
            Assertions.assertThat((OptionalLong)tableStatisticsBefore.getRawDataSize()).isEqualTo((Object)tableStatisticsAfter.getRawDataSize());
            Assertions.assertThat((OptionalLong)tableStatisticsBefore.getTotalSize()).isEqualTo((Object)tableStatisticsAfter.getTotalSize());
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertPartitioned() {
        String tableName = "test_basic_statistics_partitioned_insert_presto";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (   n_nationkey bigint,    n_name varchar(25),    n_comment varchar(152),    n_regionkey bigint )WITH (   partitioned_by = ARRAY['n_regionkey'] ) ", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics tableStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            if (tableStatistics.getNumRows().isEmpty()) {
                TestHiveBasicTableStatistics.assertThatStatisticsAreNotPresent(tableStatistics);
            }
            TestHiveBasicTableStatistics.insertNationData(QueryExecutors.onTrino(), tableName);
            BasicStatistics partitionStatisticsFirstInsert = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=3");
            TestHiveBasicTableStatistics.assertThatStatisticsAreNonZero(partitionStatisticsFirstInsert);
            Assertions.assertThat((long)partitionStatisticsFirstInsert.getNumRows().getAsLong()).isEqualTo(5L);
            TestHiveBasicTableStatistics.insertNationData(QueryExecutors.onTrino(), tableName);
            BasicStatistics statisticsSecondInsert = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=3");
            Assertions.assertThat((long)statisticsSecondInsert.getNumRows().getAsLong()).isEqualTo(10L);
            TestHiveBasicTableStatistics.assertThatStatisticsValuesHaveIncreased(partitionStatisticsFirstInsert, statisticsSecondInsert);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testInsertBucketed() {
        String tableName = "test_basic_statistics_bucketed_insert_presto";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s WITH (    bucketed_by = ARRAY['n_nationkey'],    bucket_count = 50 ) AS SELECT n_nationkey, n_name, n_comment, n_regionkey FROM nation", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics statisticsAfterCreate = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            TestHiveBasicTableStatistics.assertThatStatisticsAreNonZero(statisticsAfterCreate);
            Assertions.assertThat((long)statisticsAfterCreate.getNumRows().getAsLong()).isEqualTo(25L);
            Assertions.assertThat((long)statisticsAfterCreate.getNumFiles().getAsLong()).isEqualTo(25L);
            TestHiveBasicTableStatistics.insertNationData(QueryExecutors.onTrino(), tableName);
            BasicStatistics statisticsAfterInsert = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            Assertions.assertThat((long)statisticsAfterInsert.getNumRows().getAsLong()).isEqualTo(50L);
            Assertions.assertThat((long)statisticsAfterInsert.getNumFiles().getAsLong()).isEqualTo(50L);
            TestHiveBasicTableStatistics.insertNationData(QueryExecutors.onTrino(), tableName);
            BasicStatistics statisticsAfterInsert2 = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            Assertions.assertThat((long)statisticsAfterInsert2.getNumRows().getAsLong()).isEqualTo(75L);
            Assertions.assertThat((long)statisticsAfterInsert2.getNumFiles().getAsLong()).isEqualTo(75L);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertBucketedPartitioned() {
        String tableName = "test_basic_statistics_bucketed_partitioned_insert_presto";
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s WITH (    partitioned_by = ARRAY['n_regionkey'],    bucketed_by = ARRAY['n_nationkey'],    bucket_count = 10 ) AS SELECT n_nationkey, n_name, n_comment, n_regionkey FROM nation WHERE n_regionkey = 1", tableName), new QueryExecutor.QueryParam[0]);
        try {
            BasicStatistics tableStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForTable(QueryExecutors.onHive(), tableName);
            if (tableStatistics.getNumRows().isEmpty()) {
                TestHiveBasicTableStatistics.assertThatStatisticsAreNotPresent(tableStatistics);
            }
            BasicStatistics firstPartitionStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=1");
            TestHiveBasicTableStatistics.assertThatStatisticsAreNonZero(firstPartitionStatistics);
            Assertions.assertThat((long)firstPartitionStatistics.getNumRows().getAsLong()).isEqualTo(5L);
            Assertions.assertThat((long)firstPartitionStatistics.getNumFiles().getAsLong()).isEqualTo(5L);
            String insert = String.format("INSERT INTO %s (n_nationkey, n_regionkey, n_name, n_comment) SELECT n_nationkey, n_regionkey, n_name, n_comment FROM nation WHERE n_regionkey = 2", tableName);
            QueryExecutors.onTrino().executeQuery(insert, new QueryExecutor.QueryParam[0]);
            BasicStatistics secondPartitionStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=2");
            Assertions.assertThat((long)secondPartitionStatistics.getNumRows().getAsLong()).isEqualTo(5L);
            Assertions.assertThat((long)secondPartitionStatistics.getNumFiles().getAsLong()).isEqualTo(4L);
            QueryExecutors.onTrino().executeQuery(insert, new QueryExecutor.QueryParam[0]);
            BasicStatistics secondPartitionUpdatedStatistics = TestHiveBasicTableStatistics.getBasicStatisticsForPartition(QueryExecutors.onHive(), tableName, "n_regionkey=2");
            Assertions.assertThat((long)secondPartitionUpdatedStatistics.getNumRows().getAsLong()).isEqualTo(10L);
            Assertions.assertThat((long)secondPartitionUpdatedStatistics.getNumFiles().getAsLong()).isEqualTo(8L);
        }
        catch (Throwable throwable) {
            QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
            throw throwable;
        }
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    private static void insertNationData(QueryExecutor executor, String tableName) {
        executor.executeQuery(String.format("INSERT INTO %s (n_nationkey, n_regionkey, n_name, n_comment) SELECT n_nationkey, n_regionkey, n_name, n_comment FROM nation", tableName), new QueryExecutor.QueryParam[0]);
    }

    private static void assertThatStatisticsAreNonZero(BasicStatistics statistics) {
        TestHiveBasicTableStatistics.assertThatStatisticsArePresent(statistics);
        Assertions.assertThat((long)statistics.getNumRows().getAsLong()).isGreaterThan(0L);
        Assertions.assertThat((long)statistics.getNumFiles().getAsLong()).isGreaterThan(0L);
        Assertions.assertThat((long)statistics.getRawDataSize().getAsLong()).isGreaterThan(0L);
        Assertions.assertThat((long)statistics.getTotalSize().getAsLong()).isGreaterThan(0L);
    }

    private static void assertThatStatisticsAreZero(BasicStatistics statistics) {
        TestHiveBasicTableStatistics.assertThatStatisticsArePresent(statistics);
        Assertions.assertThat((long)statistics.getNumRows().getAsLong()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getNumFiles().getAsLong()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getRawDataSize().getAsLong()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getTotalSize().getAsLong()).isEqualTo(0L);
    }

    private static void assertThatStatisticsArePresent(BasicStatistics statistics) {
        Assertions.assertThat((OptionalLong)statistics.getNumRows()).isPresent();
        Assertions.assertThat((OptionalLong)statistics.getNumFiles()).isPresent();
        Assertions.assertThat((OptionalLong)statistics.getRawDataSize()).isPresent();
        Assertions.assertThat((OptionalLong)statistics.getTotalSize()).isPresent();
    }

    private static void assertThatStatisticsAreNotPresent(BasicStatistics statistics) {
        Assertions.assertThat((OptionalLong)statistics.getNumRows()).isNotPresent();
        Assertions.assertThat((OptionalLong)statistics.getNumFiles()).isNotPresent();
        Assertions.assertThat((OptionalLong)statistics.getRawDataSize()).isNotPresent();
        Assertions.assertThat((OptionalLong)statistics.getTotalSize()).isNotPresent();
    }

    private static void assertThatStatisticsValuesHaveIncreased(BasicStatistics first, BasicStatistics second) {
        Assertions.assertThat((long)second.getNumRows().getAsLong()).isGreaterThan(first.getNumRows().getAsLong());
        Assertions.assertThat((long)second.getNumFiles().getAsLong()).isGreaterThan(first.getNumFiles().getAsLong());
        Assertions.assertThat((long)second.getTotalSize().getAsLong()).isGreaterThan(first.getTotalSize().getAsLong());
        Assertions.assertThat((long)second.getRawDataSize().getAsLong()).isGreaterThan(first.getRawDataSize().getAsLong());
    }

    private static BasicStatistics getBasicStatisticsForTable(QueryExecutor executor, String table) {
        QueryResult result = executor.executeQuery(String.format("DESCRIBE FORMATTED %s", table), new QueryExecutor.QueryParam[0]);
        return TestHiveBasicTableStatistics.basicStatisticsFromDescribeResult(result);
    }

    private static BasicStatistics getBasicStatisticsForPartition(QueryExecutor executor, String table, String partition) {
        QueryResult result = executor.executeQuery(String.format("DESCRIBE FORMATTED %s partition (%s)", table, partition), new QueryExecutor.QueryParam[0]);
        return TestHiveBasicTableStatistics.basicStatisticsFromDescribeResult(result);
    }

    private static BasicStatistics basicStatisticsFromDescribeResult(QueryResult result) {
        OptionalLong numFiles = TestHiveBasicTableStatistics.getTableParameterValue(result, "numFiles");
        OptionalLong numRows = TestHiveBasicTableStatistics.getTableParameterValue(result, "numRows");
        OptionalLong rawDataSize = TestHiveBasicTableStatistics.getTableParameterValue(result, "rawDataSize");
        OptionalLong totalSize = TestHiveBasicTableStatistics.getTableParameterValue(result, "totalSize");
        return new BasicStatistics(numFiles, numRows, rawDataSize, totalSize);
    }

    private static OptionalLong getTableParameterValue(QueryResult describeResult, String key) {
        Verify.verify((describeResult.getColumnsCount() == 3 ? 1 : 0) != 0, (String)"describe result is expected to have 3 columns", (Object[])new Object[0]);
        for (List row : describeResult.rows()) {
            Optional<String> parameterKey = Optional.ofNullable(row.get(1)).map(Object::toString).map(String::trim);
            if (!parameterKey.isPresent() || !key.equals(parameterKey.get())) continue;
            return Optional.ofNullable(row.get(2)).map(Object::toString).map(String::trim).map(TestHiveBasicTableStatistics::tryParse).get();
        }
        return OptionalLong.empty();
    }

    private static OptionalLong tryParse(String value) {
        Long number = Longs.tryParse((String)value);
        if (number != null) {
            return OptionalLong.of(number);
        }
        return OptionalLong.empty();
    }

    private static class BasicStatistics {
        private final OptionalLong numFiles;
        private final OptionalLong numRows;
        private final OptionalLong rawDataSize;
        private final OptionalLong totalSize;

        public BasicStatistics(OptionalLong numFiles, OptionalLong numRows, OptionalLong rawDataSize, OptionalLong totalSize) {
            this.numFiles = Objects.requireNonNull(numFiles, "numFiles is null");
            this.numRows = Objects.requireNonNull(numRows, "numRows is null");
            this.rawDataSize = Objects.requireNonNull(rawDataSize, "rawDataSize is null");
            this.totalSize = Objects.requireNonNull(totalSize, "totalSize is null");
        }

        public OptionalLong getNumFiles() {
            return this.numFiles;
        }

        public OptionalLong getNumRows() {
            return this.numRows;
        }

        public OptionalLong getRawDataSize() {
            return this.rawDataSize;
        }

        public OptionalLong getTotalSize() {
            return this.totalSize;
        }
    }
}

