/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.iceberg;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestIcebergHiveViewsCompatibility
extends ProductTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"iceberg", "storage_formats", "hms_only"})
    public void testIcebergHiveViewsCompatibility() {
        try {
            this.cleanup();
            List hivePreexistingTables = QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM hive.default", new QueryExecutor.QueryParam[0]).rows().stream().map(list -> QueryAssert.Row.row((Object[])list.toArray())).collect(Collectors.toList());
            List icebergPreexistingTables = QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM iceberg.default", new QueryExecutor.QueryParam[0]).rows().stream().map(list -> QueryAssert.Row.row((Object[])list.toArray())).collect(Collectors.toList());
            QueryExecutors.onTrino().executeQuery("CREATE TABLE hive.default.hive_table AS SELECT 1 bee", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CREATE TABLE iceberg.default.iceberg_table AS SELECT 2 snow", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("USE hive.default", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CREATE VIEW hive.default.hive_view_qualified_hive AS SELECT * FROM hive.default.hive_table", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CREATE VIEW hive.default.hive_view_unqualified_hive AS SELECT * FROM hive_table", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CREATE VIEW hive.default.hive_view_qualified_iceberg AS SELECT * FROM iceberg.default.iceberg_table", new QueryExecutor.QueryParam[0]);
            QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery("CREATE VIEW hive.default.hive_view_unqualified_iceberg AS SELECT * FROM iceberg_table", new QueryExecutor.QueryParam[0])).hasMessageMatching("Query failed \\(#\\w+\\):\\Q Cannot query Iceberg table 'default.iceberg_table'");
            QueryExecutors.onTrino().executeQuery("USE iceberg.default", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CREATE VIEW iceberg.default.iceberg_view_qualified_hive AS SELECT * FROM hive.default.hive_table", new QueryExecutor.QueryParam[0]);
            Assertions.assertThatThrownBy(() -> QueryExecutors.onTrino().executeQuery("CREATE VIEW iceberg.default.iceberg_view_unqualified_hive AS SELECT * FROM hive_table", new QueryExecutor.QueryParam[0])).hasMessageContaining("Not an Iceberg table: default.hive_table");
            QueryExecutors.onTrino().executeQuery("CREATE VIEW iceberg.default.iceberg_view_qualified_iceberg AS SELECT * FROM iceberg.default.iceberg_table", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("CREATE VIEW iceberg.default.iceberg_view_unqualified_iceberg AS SELECT * FROM iceberg_table", new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery("USE tpch.tiny", new QueryExecutor.QueryParam[0]);
            ImmutableList newlyCreated = ImmutableList.builder().add((Object)QueryAssert.Row.row((Object[])new Object[]{"hive_table"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_table"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"hive_view_qualified_hive"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"hive_view_unqualified_hive"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"hive_view_qualified_iceberg"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_view_qualified_hive"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_view_qualified_iceberg"})).add((Object)QueryAssert.Row.row((Object[])new Object[]{"iceberg_view_unqualified_iceberg"})).build();
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM hive.default", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.builder().addAll(hivePreexistingTables).addAll((Iterable)newlyCreated).build());
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SHOW TABLES FROM iceberg.default", new QueryExecutor.QueryParam[0])).containsOnly((List)ImmutableList.builder().addAll(icebergPreexistingTables).addAll((Iterable)newlyCreated).build());
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.hive_view_qualified_hive", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.hive_view_unqualified_hive", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.hive_view_qualified_iceberg", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.iceberg_view_qualified_hive", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.iceberg_view_qualified_iceberg", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM hive.default.iceberg_view_unqualified_iceberg", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default.hive_view_qualified_hive", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default.hive_view_unqualified_hive", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default.hive_view_qualified_iceberg", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default.iceberg_view_qualified_hive", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{1})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default.iceberg_view_qualified_iceberg", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM iceberg.default.iceberg_view_unqualified_iceberg", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{2})});
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS hive.default.hive_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS iceberg.default.iceberg_table", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS hive.default.hive_view_qualified_hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS hive.default.hive_view_unqualified_hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS hive.default.hive_view_qualified_iceberg", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS hive.default.hive_view_unqualified_iceberg", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS iceberg.default.iceberg_view_qualified_hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS iceberg.default.iceberg_view_unqualified_hive", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS iceberg.default.iceberg_view_qualified_iceberg", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("DROP VIEW IF EXISTS iceberg.default.iceberg_view_unqualified_iceberg", new QueryExecutor.QueryParam[0]);
    }
}

