/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.utils.QueryExecutors;
import java.sql.JDBCType;
import java.util.List;
import java.util.stream.Collectors;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class TestConfiguredFeatures
extends ProductTest {
    @Inject
    @Named(value="databases.presto.configured_connectors")
    private List<String> configuredConnectors;

    @Test(groups={"configured_features"})
    public void selectConfiguredConnectors() {
        if (this.configuredConnectors.size() == 0) {
            throw new SkipException("Skip checking configured connectors since none were set in Tempto configuration");
        }
        String sql = "select distinct connector_name from system.metadata.catalogs";
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0])).hasColumns(new JDBCType[]{JDBCType.VARCHAR}).containsOnly(this.configuredConnectors.stream().map(xva$0 -> QueryAssert.Row.row((Object[])new Object[]{xva$0})).collect(Collectors.toList()));
    }
}

