/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.cassandra;

import io.trino.tempto.ProductTest;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.TableRequirements;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tests.product.cassandra.CassandraTpchTableDefinitions;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestInvalidSelect
extends ProductTest
implements RequirementsProvider {
    public Requirement getRequirements(Configuration configuration) {
        return TableRequirements.immutableTable((TableDefinition)CassandraTpchTableDefinitions.CASSANDRA_NATION);
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidTable() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", "bogus");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidSchema() {
        String tableName = String.format("%s.%s.%s", "cassandra", "does_not_exist", "bogus");
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Schema 'does_not_exist' does not exist");
    }

    @Test(groups={"cassandra", "profile_specific_tests"})
    public void testInvalidColumn() {
        String tableName = String.format("%s.%s.%s", "cassandra", "test", CassandraTpchTableDefinitions.CASSANDRA_NATION.getName());
        QueryAssert.assertQueryFailure(() -> QueryExecutors.onTrino().executeQuery(String.format("SELECT bogus FROM %s", tableName), new QueryExecutor.QueryParam[0])).hasMessageContaining("Column 'bogus' cannot be resolved");
    }
}

