/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.cli;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.airlift.testing.TempFile;
import io.trino.tempto.AfterTestWithContext;
import io.trino.tempto.Requirement;
import io.trino.tempto.RequirementsProvider;
import io.trino.tempto.configuration.Configuration;
import io.trino.tempto.fulfillment.table.ImmutableTableRequirement;
import io.trino.tempto.fulfillment.table.TableDefinition;
import io.trino.tempto.fulfillment.table.hive.tpch.TpchTableDefinitions;
import io.trino.tempto.process.CliProcess;
import io.trino.tests.product.cli.TrinoCliLauncher;
import io.trino.tests.product.cli.TrinoCliProcess;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTrinoCli
extends TrinoCliLauncher
implements RequirementsProvider {
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_authentication")
    private boolean kerberosAuthentication;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_principal")
    private String kerberosPrincipal;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_keytab")
    private String kerberosKeytab;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_config_path")
    private String kerberosConfigPath;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_service_name")
    private String kerberosServiceName;
    @Inject(optional=true)
    @Named(value="databases.presto.https_keystore_path")
    private String keystorePath;
    @Inject(optional=true)
    @Named(value="databases.presto.https_keystore_password")
    private String keystorePassword;
    @Inject(optional=true)
    @Named(value="databases.presto.cli_kerberos_use_canonical_hostname")
    private boolean kerberosUseCanonicalHostname;
    @Inject
    @Named(value="databases.presto.jdbc_user")
    private String jdbcUser;

    @Override
    @AfterTestWithContext
    public void stopPresto() throws InterruptedException {
        super.stopPresto();
    }

    public Requirement getRequirements(Configuration configuration) {
        return new ImmutableTableRequirement((TableDefinition)TpchTableDefinitions.NATION);
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldDisplayVersion() throws IOException {
        this.launchTrinoCli("--version");
        Assertions.assertThat((List)this.trino.readRemainingOutputLines()).containsExactly((Object[])new String[]{"Trino CLI " + TestTrinoCli.readPrestoCliVersion()});
    }

    private static String readPrestoCliVersion() {
        try {
            String version = Resources.toString((URL)Resources.getResource((String)"trino-cli-version.txt"), (Charset)StandardCharsets.UTF_8).trim();
            Preconditions.checkState((!version.isEmpty() ? 1 : 0) != 0, (Object)"version is empty");
            return version;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldRunQuery() throws IOException {
        this.launchTrinoCliWithServerArgument(new String[0]);
        this.trino.waitForPrompt();
        this.trino.getProcessInput().println("select * from hive.default.nation;");
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldRunBatchQuery() throws Exception {
        this.launchTrinoCliWithServerArgument("--execute", "select * from hive.default.nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
        this.trino.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldRunBatchQueryWithStdinRedirect() throws Exception {
        try (TempFile file = new TempFile();){
            Files.writeString(file.path(), (CharSequence)"select * from hive.default.nation;", new OpenOption[0]);
            this.launchTrinoCliWithRedirectedStdin(file.file());
            Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
            this.trino.waitForWithTimeoutAndKill();
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldRunMultipleBatchQueriesWithStdinRedirect() throws Exception {
        try (TempFile file = new TempFile();){
            Files.writeString(file.path(), (CharSequence)"select * from hive.default.nation;select 1;select 2", new OpenOption[0]);
            this.launchTrinoCliWithRedirectedStdin(file.file());
            ImmutableList expectedLines = ImmutableList.builder().addAll((Iterable)this.nationTableBatchLines).add((Object)"\"1\"").add((Object)"\"2\"").build();
            Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)expectedLines);
            this.trino.waitForWithTimeoutAndKill();
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldExecuteEmptyListOfStatements() throws Exception {
        this.launchTrinoCliWithServerArgument("--execute", "");
        Assert.assertTrue((boolean)CliProcess.trimLines((List)this.trino.readRemainingOutputLines()).isEmpty());
        this.trino.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldPassSessionUser() throws Exception {
        this.launchTrinoCliWithServerArgument("--session-user", "other-user", "--execute", "SELECT current_user;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).contains((Object[])new String[]{"\"other-user\""});
        this.trino.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldUseCatalogAndSchemaOptions() throws Exception {
        this.launchTrinoCliWithServerArgument("--catalog", "hive", "--schema", "default", "--execute", "select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
        this.trino.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldUseCatalogAndSchemaOptionsFromConfigFile() throws Exception {
        this.launchTrinoCliWithConfigurationFile((List<String>)ImmutableList.of((Object)"catalog", (Object)"hive", (Object)"schema", (Object)"default"), "--execute", "SELECT * FROM nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
        this.trino.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldPreferCommandLineArgumentOverConfigDefault() throws Exception {
        this.launchTrinoCliWithConfigurationFile((List<String>)ImmutableList.of((Object)"catalog", (Object)"some-other-catalog", (Object)"schema", (Object)"default"), "--catalog", "hive", "--execute", "SELECT * FROM nation;");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
        this.trino.waitForWithTimeoutAndKill();
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldExitWithErrorOnUnknownPropertiesInConfigFile() throws Exception {
        String configPath = this.launchTrinoCliWithConfigurationFile((List<String>)ImmutableList.of((Object)"unknown", (Object)"property", (Object)"catalog", (Object)"hive"), new String[0]);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingErrorLines())).containsExactly((Object[])new String[]{String.format("Configuration file %s contains unknown properties [unknown]", configPath)});
        Assertions.assertThatThrownBy(() -> this.trino.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldRunQueryFromFile() throws Exception {
        try (TempFile file = new TempFile();){
            Files.writeString(file.path(), (CharSequence)"select * from hive.default.nation;\n", new OpenOption[0]);
            this.launchTrinoCliWithServerArgument("--file", file.file().getAbsolutePath());
            Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
            this.trino.waitForWithTimeoutAndKill();
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldExitOnErrorFromExecute() throws IOException {
        String sql = "select * from hive.default.nations; select * from hive.default.nation;";
        this.launchTrinoCliWithServerArgument("--execute", sql);
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).isEmpty();
        Assertions.assertThatThrownBy(() -> this.trino.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldExitOnErrorFromFile() throws IOException {
        try (TempFile file = new TempFile();){
            Files.writeString(file.path(), (CharSequence)"select * from hive.default.nations;\nselect * from hive.default.nation;\n", new OpenOption[0]);
            this.launchTrinoCliWithServerArgument("--file", file.file().getAbsolutePath());
            Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).isEmpty();
            Assertions.assertThatThrownBy(() -> this.trino.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldNotExitOnErrorFromExecute() throws IOException {
        String sql = "select * from hive.default.nations; select * from hive.default.nation;";
        this.launchTrinoCliWithServerArgument("--execute", sql, "--ignore-errors", "true");
        Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
        Assertions.assertThatThrownBy(() -> this.trino.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldNotExitOnErrorFromFile() throws IOException {
        try (TempFile file = new TempFile();){
            Files.writeString(file.path(), (CharSequence)"select * from hive.default.nations;\nselect * from hive.default.nation;\n", new OpenOption[0]);
            this.launchTrinoCliWithServerArgument("--file", file.file().getAbsolutePath(), "--ignore-errors", "true");
            Assertions.assertThat((List)CliProcess.trimLines((List)this.trino.readRemainingOutputLines())).containsAll((Iterable)this.nationTableBatchLines);
            Assertions.assertThatThrownBy(() -> this.trino.waitForWithTimeoutAndKill()).hasMessage("Child process exited with non-zero code: 1");
        }
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldHandleSession() throws IOException {
        this.launchTrinoCliWithServerArgument(new String[0]);
        this.trino.waitForPrompt();
        this.trino.getProcessInput().println("use hive.default;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"USE"});
        this.trino.getProcessInput().println("select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).containsAll((Iterable)this.nationTableInteractiveLines);
        this.trino.getProcessInput().println("show session;");
        Assertions.assertThat(TestTrinoCli.squeezeLines(this.trino.readLinesUntilPrompt())).contains((Object[])new String[]{"join_distribution_type|AUTOMATIC|AUTOMATIC|varchar|Join distribution type. Possible values: [BROADCAST, PARTITIONED, AUTOMATIC]"});
        this.trino.getProcessInput().println("set session join_distribution_type = 'BROADCAST';");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"SET SESSION"});
        this.trino.getProcessInput().println("show session;");
        Assertions.assertThat(TestTrinoCli.squeezeLines(this.trino.readLinesUntilPrompt())).contains((Object[])new String[]{"join_distribution_type|BROADCAST|AUTOMATIC|varchar|Join distribution type. Possible values: [BROADCAST, PARTITIONED, AUTOMATIC]"});
    }

    @Test(groups={"cli"}, timeOut=300000L)
    public void shouldHandleTransaction() throws IOException {
        this.launchTrinoCliWithServerArgument(new String[0]);
        this.trino.waitForPrompt();
        this.trino.getProcessInput().println("use hive.default;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"USE"});
        this.trino.getProcessInput().println("start transaction;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"START TRANSACTION"});
        this.trino.getProcessInput().println("create table txn_test (x bigint);");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"CREATE TABLE"});
        this.trino.getProcessInput().println("select foo;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).extracting(TestTrinoCli::removePrefix).contains((Object[])new String[]{"line 1:8: Column 'foo' cannot be resolved"});
        this.trino.getProcessInput().println("select * from nation;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).extracting(TestTrinoCli::removePrefix).contains((Object[])new String[]{"Current transaction is aborted, commands ignored until end of transaction block"});
        this.trino.getProcessInput().println("rollback;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"ROLLBACK"});
        this.trino.getProcessInput().println("select * from nation;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).containsAll((Iterable)this.nationTableInteractiveLines);
        this.trino.getProcessInput().println("show tables;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).doesNotContain((Object[])new String[]{"txn_test"});
        this.trino.getProcessInput().println("start transaction;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"START TRANSACTION"});
        this.trino.getProcessInput().println("create table txn_test1 (x bigint);");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"CREATE TABLE"});
        this.trino.getProcessInput().println("create table txn_test2 (x bigint);");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"CREATE TABLE"});
        this.trino.getProcessInput().println("commit;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"COMMIT"});
        this.trino.getProcessInput().println("show tables;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).contains((Object[])new String[]{"txn_test1", "txn_test2"});
    }

    @Test(groups={"authorization", "profile_specific_tests"}, timeOut=300000L)
    public void testSetRole() throws IOException {
        this.launchTrinoCliWithServerArgument(new String[0]);
        this.trino.waitForPrompt();
        this.trino.getProcessInput().println("use hive.default;");
        Assertions.assertThat(this.trino.readLinesUntilPrompt()).contains((Object[])new String[]{"USE"});
        this.trino.getProcessInput().println("show current roles from hive;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).contains((Object[])new String[]{"public"});
        this.trino.getProcessInput().println("set role admin in hive;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).contains((Object[])new String[]{"SET ROLE"});
        this.trino.getProcessInput().println("show current roles from hive;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).contains((Object[])new String[]{"public", "admin"});
        this.trino.getProcessInput().println("set role none in hive;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).contains((Object[])new String[]{"SET ROLE"});
        this.trino.getProcessInput().println("show current roles from hive;");
        Assertions.assertThat((List)CliProcess.trimLines(this.trino.readLinesUntilPrompt())).doesNotContain((Object[])new String[]{"admin"});
    }

    private void launchTrinoCliWithServerArgument(String ... arguments) throws IOException {
        this.launchTrinoCli(this.getTrinoCliArguments(arguments));
    }

    private String launchTrinoCliWithConfigurationFile(List<String> configuration, String ... arguments) throws IOException {
        CharMatcher matcher = CharMatcher.is((char)'-');
        ProcessBuilder processBuilder = this.getProcessBuilder((List<String>)ImmutableList.copyOf((Object[])arguments));
        String fileContent = this.getTrinoCliArguments(configuration.toArray(new String[0])).stream().map(arg_0 -> ((CharMatcher)matcher).trimLeadingFrom(arg_0)).collect(Collectors.joining("\n"));
        File tempFile = File.createTempFile(".trino_config", "");
        tempFile.deleteOnExit();
        Files.writeString(tempFile.toPath(), (CharSequence)fileContent, new OpenOption[0]);
        processBuilder.environment().put("TRINO_CONFIG", tempFile.getAbsolutePath());
        this.trino = new TrinoCliProcess(processBuilder.start());
        return tempFile.getPath();
    }

    private void launchTrinoCliWithRedirectedStdin(File inputFile) throws IOException {
        ProcessBuilder processBuilder = this.getProcessBuilder(this.getTrinoCliArguments(new String[0]));
        processBuilder.redirectInput(inputFile);
        this.trino = new TrinoCliProcess(processBuilder.start());
    }

    private List<String> getTrinoCliArguments(String ... arguments) {
        Verify.verify((arguments.length % 2 == 0 ? 1 : 0) != 0, (String)"arguments.length should be divisible by 2", (Object[])new Object[0]);
        ImmutableList.Builder trinoClientOptions = ImmutableList.builder();
        trinoClientOptions.add((Object[])new String[]{"--server", this.serverAddress});
        trinoClientOptions.add((Object[])new String[]{"--user", this.jdbcUser});
        if (this.keystorePath != null) {
            trinoClientOptions.add((Object[])new String[]{"--keystore-path", this.keystorePath});
        }
        if (this.keystorePassword != null) {
            trinoClientOptions.add((Object[])new String[]{"--keystore-password", this.keystorePassword});
        }
        if (this.kerberosAuthentication) {
            Objects.requireNonNull(this.kerberosPrincipal, "kerberosPrincipal is null");
            Objects.requireNonNull(this.kerberosKeytab, "kerberosKeytab is null");
            Objects.requireNonNull(this.kerberosServiceName, "kerberosServiceName is null");
            Objects.requireNonNull(this.kerberosConfigPath, "kerberosConfigPath is null");
            trinoClientOptions.add((Object[])new String[]{"--krb5-principal", this.kerberosPrincipal});
            trinoClientOptions.add((Object[])new String[]{"--krb5-keytab-path", this.kerberosKeytab});
            trinoClientOptions.add((Object[])new String[]{"--krb5-remote-service-name", this.kerberosServiceName});
            trinoClientOptions.add((Object[])new String[]{"--krb5-config-path", this.kerberosConfigPath});
            if (!this.kerberosUseCanonicalHostname) {
                trinoClientOptions.add((Object[])new String[]{"--krb5-disable-remote-service-hostname-canonicalization", "true"});
            }
        }
        trinoClientOptions.add((Object[])arguments);
        return (List)Lists.partition((List)trinoClientOptions.build(), (int)2).stream().map(argument -> String.format("%s=%s", argument.get(0), argument.get(1))).collect(ImmutableList.toImmutableList());
    }

    private static String removePrefix(String line) {
        int i = line.indexOf(58);
        return i >= 0 ? line.substring(i + 1).trim() : line;
    }

    public static List<String> squeezeLines(List<String> lines) {
        return lines.stream().map(line -> line.replaceAll(" +\\| +", "|").trim()).collect(Collectors.toList());
    }
}

