/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.BeforeTestWithContext;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.deltalake.BaseTestDeltaLakeS3Storage;
import io.trino.tests.product.deltalake.util.DeltaLakeTestUtils;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeltaLakeDatabricksCreateTableCompatibility
extends BaseTestDeltaLakeS3Storage {
    private String databricksRuntimeVersion;

    @BeforeTestWithContext
    public void setup() {
        super.setUp();
        this.databricksRuntimeVersion = DeltaLakeTestUtils.getDatabricksRuntimeVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testDatabricksCanReadInitialCreateTable() {
        String tableName = "test_dl_create_table_compat_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (integer int, string varchar, timetz timestamp with time zone) with (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW TABLES FROM default LIKE '" + tableName + "'", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", tableName, false})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT count(*) FROM default." + tableName, new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
            String showCreateTable = this.databricksRuntimeVersion.equals("10.4") ? String.format("CREATE TABLE spark_catalog.default.%s (\n  integer INT,\n  string STRING,\n  timetz TIMESTAMP)\nUSING delta\nLOCATION 's3://%s/%s'\n%s", tableName, this.bucketName, tableDirectory, this.getDatabricks104DefaultTableProperties()) : String.format("CREATE TABLE `default`.`%s` (\n  `integer` INT,\n  `string` STRING,\n  `timetz` TIMESTAMP)\nUSING DELTA\nLOCATION 's3://%s/%s'\n", tableName, this.bucketName, tableDirectory);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{showCreateTable})});
            this.testInsert(tableName, (List<QueryAssert.Row>)ImmutableList.of());
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testDatabricksCanReadInitialCreatePartitionedTable() {
        String tableName = "test_dl_create_table_compat_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (integer int, string varchar, timetz timestamp with time zone) with (location = 's3://%s/%s', partitioned_by = ARRAY['string'])", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW TABLES LIKE '" + tableName + "'", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", tableName, false})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT count(*) FROM " + tableName, new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{0})});
            String showCreateTable = this.databricksRuntimeVersion.equals("10.4") ? String.format("CREATE TABLE spark_catalog.default.%s (\n  integer INT,\n  string STRING,\n  timetz TIMESTAMP)\nUSING delta\nPARTITIONED BY (string)\nLOCATION 's3://%s/%s'\n%s", tableName, this.bucketName, tableDirectory, this.getDatabricks104DefaultTableProperties()) : String.format("CREATE TABLE `default`.`%s` (\n  `integer` INT,\n  `string` STRING,\n  `timetz` TIMESTAMP)\nUSING DELTA\nPARTITIONED BY (string)\nLOCATION 's3://%s/%s'\n", tableName, this.bucketName, tableDirectory);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE " + tableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{showCreateTable})});
            this.testInsert(tableName, (List<QueryAssert.Row>)ImmutableList.of());
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testDatabricksCanReadInitialCreateTableAs() {
        String tableName = "test_dl_create_table_as_compat_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (integer, string, timetz) with (location = 's3://%s/%s') AS VALUES (4, 'four', TIMESTAMP '2020-01-01 01:00:00.000 UTC'), (5, 'five', TIMESTAMP '2025-01-01 01:00:00.000 UTC'), (null, null, null)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW TABLES FROM default LIKE '" + tableName + "'", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", tableName, false})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT count(*) FROM default." + tableName, new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
            String showCreateTable = this.databricksRuntimeVersion.equals("10.4") ? String.format("CREATE TABLE spark_catalog.default.%s (\n  integer INT,\n  string STRING,\n  timetz TIMESTAMP)\nUSING delta\nLOCATION 's3://%s/%s'\n%s", tableName, this.bucketName, tableDirectory, this.getDatabricks104DefaultTableProperties()) : String.format("CREATE TABLE `default`.`%s` (\n  `integer` INT,\n  `string` STRING,\n  `timetz` TIMESTAMP)\nUSING DELTA\nLOCATION 's3://%s/%s'\n", tableName, this.bucketName, tableDirectory);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE default." + tableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{showCreateTable})});
            this.testInsert(tableName, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "2020-01-01T01:00:00.000Z"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "five", "2025-01-01T01:00:00.000Z"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null})));
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testDatabricksCanReadInitialCreatePartitionedTableAs() {
        String tableName = "test_dl_create_table_compat_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (integer, string, timetz) with (location = 's3://%s/%s', partitioned_by = ARRAY['string']) AS VALUES (4, 'four', TIMESTAMP '2020-01-01 01:00:00.000 UTC'), (5, 'five', TIMESTAMP '2025-01-01 01:00:00.000 UTC'), (null, null, null)", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW TABLES LIKE '" + tableName + "'", new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"default", tableName, false})});
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SELECT count(*) FROM " + tableName, new QueryExecutor.QueryParam[0])).contains(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{3})});
            String showCreateTable = this.databricksRuntimeVersion.equals("10.4") ? String.format("CREATE TABLE spark_catalog.default.%s (\n  integer INT,\n  string STRING,\n  timetz TIMESTAMP)\nUSING delta\nPARTITIONED BY (string)\nLOCATION 's3://%s/%s'\n%s", tableName, this.bucketName, tableDirectory, this.getDatabricks104DefaultTableProperties()) : String.format("CREATE TABLE `default`.`%s` (\n  `integer` INT,\n  `string` STRING,\n  `timetz` TIMESTAMP)\nUSING DELTA\nPARTITIONED BY (string)\nLOCATION 's3://%s/%s'\n", tableName, this.bucketName, tableDirectory);
            QueryAssert.assertThat((QueryResult)QueryExecutors.onDelta().executeQuery("SHOW CREATE TABLE " + tableName, new QueryExecutor.QueryParam[0])).containsExactlyInOrder(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{showCreateTable})});
            this.testInsert(tableName, (List<QueryAssert.Row>)ImmutableList.of((Object)QueryAssert.Row.row((Object[])new Object[]{4, "four", "2020-01-01T01:00:00.000Z"}), (Object)QueryAssert.Row.row((Object[])new Object[]{5, "five", "2025-01-01T01:00:00.000Z"}), (Object)QueryAssert.Row.row((Object[])new Object[]{null, null, null})));
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    private void testInsert(String tableName, List<QueryAssert.Row> existingRows) {
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (1, 'one', TIMESTAMP '2960-10-31 01:00:00')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (2, 'two', TIMESTAMP '2020-10-31 01:00:00')", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onDelta().executeQuery("INSERT INTO default." + tableName + " VALUES (3, 'three', TIMESTAMP '1900-10-31 01:00:00')", new QueryExecutor.QueryParam[0]);
        ImmutableList.Builder expected = ImmutableList.builder();
        expected.addAll(existingRows);
        expected.add((Object)QueryAssert.Row.row((Object[])new Object[]{1, "one", "2960-10-31T01:00:00.000Z"}));
        expected.add((Object)QueryAssert.Row.row((Object[])new Object[]{2, "two", "2020-10-31T01:00:00.000Z"}));
        expected.add((Object)QueryAssert.Row.row((Object[])new Object[]{3, "three", "1900-10-31T01:00:00.000Z"}));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT integer, string, to_iso8601(timetz) FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly((List)expected.build());
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testCreateTableWithTableComment() {
        String tableName = "test_dl_create_table_comment_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT) COMMENT 'test comment' WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT comment FROM system.metadata.table_comments WHERE catalog_name = 'delta' AND schema_name = 'default' AND table_name = '" + tableName + "'", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"test comment"})});
            Assert.assertEquals((String)DeltaLakeTestUtils.getTableCommentOnDelta("default", tableName), (String)"test comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testCreateTableWithColumnCommentOnTrino() {
        String tableName = "test_dl_create_column_comment_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%s (col INT COMMENT 'test comment') WITH (location = 's3://%s/%s')", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test comment");
            QueryExecutors.onTrino().executeQuery("ALTER TABLE delta.default." + tableName + " ADD COLUMN new_col INT", new QueryExecutor.QueryParam[0]);
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test comment");
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnDelta("default", tableName, "col"), (String)"test comment");
        }
        finally {
            QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    @Test(groups={"delta-lake-databricks", "profile_specific_tests"})
    public void testCreateTableWithColumnCommentOnDelta() {
        String tableName = "test_dl_create_column_comment_" + TemporaryHiveTable.randomTableSuffix();
        String tableDirectory = "databricks-compatibility-test-" + tableName;
        QueryExecutors.onDelta().executeQuery(String.format("CREATE TABLE default.%s (col INT COMMENT 'test comment') USING DELTA LOCATION 's3://%s/%s'", tableName, this.bucketName, tableDirectory), new QueryExecutor.QueryParam[0]);
        try {
            Assert.assertEquals((String)DeltaLakeTestUtils.getColumnCommentOnTrino("default", tableName, "col"), (String)"test comment");
        }
        finally {
            QueryExecutors.onDelta().executeQuery("DROP TABLE default." + tableName, new QueryExecutor.QueryParam[0]);
        }
    }

    private String getDatabricks104DefaultTableProperties() {
        return "TBLPROPERTIES (\n  'Type' = 'EXTERNAL',\n  'delta.minReaderVersion' = '1',\n  'delta.minWriterVersion' = '2')\n";
    }
}

