/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.deltalake;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import org.testng.annotations.Test;

public class TestDeltaLakeGcs
extends ProductTest {
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;

    @Test(groups={"delta-lake-gcs", "profile_specific_tests"})
    public void testCreateAndSelectNationTable() {
        String tableName = "nation_" + TemporaryHiveTable.randomTableSuffix();
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE delta.default.%1$s WITH (location = '%2$s/%1$s') AS SELECT * FROM tpch.tiny.nation", tableName, this.warehouseDirectory), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT count(*) FROM delta.default." + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{25})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE delta.default." + tableName, new QueryExecutor.QueryParam[0]);
    }
}

