/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.collect.ImmutableList;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.tests.product.hive.BucketingType;
import io.trino.tests.product.hive.Engine;
import io.trino.tests.product.hive.HiveProductTest;
import io.trino.tests.product.hive.TestHiveTransactionalTable;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.QueryExecutors;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveMerge
extends HiveProductTest {
    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeSimpleSelect() {
        this.withTemporaryTable("merge_simple_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("merge_simple_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), new QueryExecutor.QueryParam[0]);
                String sql = String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
                QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeSimpleSelectPartitioned() {
        this.withTemporaryTable("merge_simple_target", true, true, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true, partitioned_by = ARRAY['address'])", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("merge_simple_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), new QueryExecutor.QueryParam[0]);
                String sql = String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
                QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L, dataProvider="partitionedAndBucketedProvider")
    public void testMergeUpdateWithVariousLayouts(boolean partitioned, String bucketing) {
        BucketingType bucketingType = bucketing.isEmpty() ? BucketingType.NONE : BucketingType.BUCKETED_V2;
        this.withTemporaryTable("merge_with_various_formats", true, partitioned, bucketingType, targetTable -> {
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE ").append((String)targetTable).append("(customer STRING");
            builder.append(partitioned ? ") PARTITIONED BY (" : ", ").append("purchase STRING) ");
            if (!bucketing.isEmpty()) {
                builder.append(bucketing);
            }
            builder.append(" STORED AS ORC TBLPROPERTIES ('transactional' = 'true')");
            QueryExecutors.onHive().executeQuery(builder.toString(), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES ('Dave', 'dates'), ('Lou', 'limes'), ('Carol', 'candles')", targetTable), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Dave", "dates"}), QueryAssert.Row.row((Object[])new Object[]{"Lou", "limes"}), QueryAssert.Row.row((Object[])new Object[]{"Carol", "candles"}));
            this.withTemporaryTable("merge_simple_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES ('Craig', 'candles'), ('Len', 'limes'), ('Joe', 'jellybeans')", sourceTable), new QueryExecutor.QueryParam[0]);
                String sql = String.format("MERGE INTO %s t USING %s s ON (t.purchase = s.purchase)", targetTable, sourceTable) + "    WHEN MATCHED AND s.purchase = 'limes' THEN DELETE    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_', s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchase) VALUES(s.customer, s.purchase)";
                QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Dave", "dates"}), QueryAssert.Row.row((Object[])new Object[]{"Carol_Craig", "candles"}), QueryAssert.Row.row((Object[])new Object[]{"Joe", "jellybeans"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testMergeUnBucketedUnPartitionedFailure() {
        this.withTemporaryTable("merge_with_various_formats", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES ('Dave', 'dates'), ('Lou', 'limes'), ('Carol', 'candles')", targetTable), new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Dave", "dates"}), QueryAssert.Row.row((Object[])new Object[]{"Lou", "limes"}), QueryAssert.Row.row((Object[])new Object[]{"Carol", "candles"}));
            this.withTemporaryTable("merge_simple_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchase) VALUES ('Craig', 'candles'), ('Len', 'limes'), ('Joe', 'jellybeans')", sourceTable), new QueryExecutor.QueryParam[0]);
                String sql = String.format("MERGE INTO %s t USING %s s ON (t.purchase = s.purchase)", targetTable, sourceTable) + "    WHEN MATCHED AND s.purchase = 'limes' THEN DELETE    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_', s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchase) VALUES(s.customer, s.purchase)";
                QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Dave", "dates"}), QueryAssert.Row.row((Object[])new Object[]{"Carol_Craig", "candles"}), QueryAssert.Row.row((Object[])new Object[]{"Joe", "jellybeans"}));
            });
        });
    }

    @DataProvider
    public Object[][] partitionedAndBucketedProvider() {
        return new Object[][]{{false, "CLUSTERED BY (customer) INTO 3 BUCKETS"}, {false, "CLUSTERED BY (purchase) INTO 4 BUCKETS"}, {true, ""}, {true, "CLUSTERED BY (customer) INTO 3 BUCKETS"}};
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeMultipleOperationsUnbucketedUnpartitioned() {
        this.withTemporaryTable("merge_multiple", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, zipcode INT, spouse VARCHAR, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            this.testMergeMultipleOperationsInternal((String)targetTable, 32);
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeMultipleOperationsUnbucketedPartitioned() {
        this.withTemporaryTable("merge_multiple", true, true, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (purchases INT, zipcode INT, spouse VARCHAR, address VARCHAR, customer VARCHAR) WITH (transactional = true, partitioned_by = ARRAY['address', 'customer'])", targetTable), new QueryExecutor.QueryParam[0]);
            this.testMergeMultipleOperationsInternal((String)targetTable, 32);
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeMultipleOperationsBucketedUnpartitioned() {
        this.withTemporaryTable("merge_multiple", true, false, BucketingType.BUCKETED_V2, targetTable -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (customer STRING, purchases INT, zipcode INT, spouse STRING, address STRING)   CLUSTERED BY(customer, zipcode, address) INTO 4 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')", targetTable), new QueryExecutor.QueryParam[0]);
            this.testMergeMultipleOperationsInternal((String)targetTable, 32);
        });
    }

    private void testMergeMultipleOperationsInternal(String targetTable, int targetCustomerCount) {
        String originalInsertFirstHalf = IntStream.range(1, targetCustomerCount / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 1000, 91000, intValue, intValue)).collect(Collectors.joining(", "));
        String originalInsertSecondHalf = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 2000, 92000, intValue, intValue)).collect(Collectors.joining(", "));
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, zipcode, spouse, address) VALUES %s, %s", targetTable, originalInsertFirstHalf, originalInsertSecondHalf), new QueryExecutor.QueryParam[0]);
        String firstMergeSource = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 83000, intValue, intValue)).collect(Collectors.joining(", "));
        QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING (SELECT * FROM (VALUES %s)) AS s(customer, purchases, zipcode, spouse, address)", targetTable, firstMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED THEN UPDATE SET purchases = s.purchases, zipcode = s.zipcode, spouse = s.spouse, address = s.address", new QueryExecutor.QueryParam[0]);
        QueryResult expectedResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM (VALUES %s, %s) AS v(customer, purchases, zipcode, spouse, address)", originalInsertFirstHalf, firstMergeSource), new QueryExecutor.QueryParam[0]);
        this.verifyOnTrinoAndHiveFromQueryResults("SELECT customer, purchases, zipcode, spouse, address FROM " + targetTable, expectedResult);
        String nextInsert = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, zipcode, spouse, address) VALUES %s", targetTable, nextInsert), new QueryExecutor.QueryParam[0]);
        String secondMergeSource = IntStream.range(1, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING (SELECT * FROM (VALUES %s)) AS s(customer, purchases, zipcode, spouse, address)", targetTable, secondMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED AND t.zipcode = 91000 THEN DELETE    WHEN MATCHED AND s.zipcode = 85000 THEN UPDATE SET zipcode = 60000    WHEN MATCHED THEN UPDATE SET zipcode = s.zipcode, spouse = s.spouse, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, zipcode, spouse, address) VALUES(s.customer, s.purchases, s.zipcode, s.spouse, s.address)", new QueryExecutor.QueryParam[0]);
        String updatedBeginning = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 60000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedMiddle = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedEnd = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        expectedResult = QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM (VALUES %s, %s, %s) AS v(customer, purchases, zipcode, spouse, address)", updatedBeginning, updatedMiddle, updatedEnd), new QueryExecutor.QueryParam[0]);
        this.verifyOnTrinoAndHiveFromQueryResults("SELECT customer, purchases, zipcode, spouse, address FROM " + targetTable, expectedResult);
    }

    private void verifyOnTrinoAndHiveFromQueryResults(String sql, QueryResult expectedResult) {
        QueryResult trinoResult = QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)trinoResult).contains(this.getRowsFromQueryResult(expectedResult));
        QueryResult hiveResult = QueryExecutors.onHive().executeQuery(sql, new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)hiveResult).contains(this.getRowsFromQueryResult(expectedResult));
    }

    private List<QueryAssert.Row> getRowsFromQueryResult(QueryResult result) {
        return (List)result.rows().stream().map(QueryAssert.Row::new).collect(ImmutableList.toImmutableList());
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeSimpleQuery() {
        this.withTemporaryTable("merge_simple_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING ", targetTable) + "(SELECT * FROM (VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville'))) AS s(customer, purchases, address)    ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeAllInserts() {
        this.withTemporaryTable("merge_all_inserts", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 11, 'Antioch'), ('Bill', 7, 'Buena')", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING ", targetTable) + "(SELECT * FROM (VALUES ('Carol', 9, 'Centreville'), ('Dave', 22, 'Darbyshire'))) AS s(customer, purchases, address)    ON (t.customer = s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Antioch"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Carol", 9, "Centreville"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeSimpleQueryPartitioned() {
        this.withTemporaryTable("merge_simple_target", true, true, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true, partitioned_by = ARRAY['address'])", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            String query = String.format("MERGE INTO %s t USING ", targetTable) + "(SELECT * FROM (VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville'))) AS s(customer, purchases, address)    ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
            QueryExecutors.onTrino().executeQuery(query, new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeAllColumnsUpdated() {
        this.withTemporaryTable("merge_all_columns_updated_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Devon'), ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("merge_all_columns_updated_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Darbyshire'), ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Ed', 7, 'Etherville')", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_updated'), purchases = s.purchases + t.purchases, address = s.address", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Dave_updated", 22, "Darbyshire"}), QueryAssert.Row.row((Object[])new Object[]{"Aaron_updated", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Carol_updated", 12, "Centreville"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeAllMatchesDeleted() {
        this.withTemporaryTable("merge_all_matches_deleted_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("merge_all_matches_deleted_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville')", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN DELETE", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L, dataProvider="partitionedBucketedFailure")
    public void testMergeMultipleRowsMatchFails(String createTableSql) {
        this.withTemporaryTable("merge_all_matches_deleted_target", true, true, BucketingType.NONE, targetTable -> {
            QueryExecutors.onHive().executeQuery(String.format(createTableSql, targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Antioch')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("merge_all_matches_deleted_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Adelphi'), ('Aaron', 8, 'Ashland')", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryAssert.assertThat(() -> QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN UPDATE SET address = s.address", new QueryExecutor.QueryParam[0])).failsWithMessage("One MERGE target table row matched more than one source row");
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Adelphi' THEN UPDATE SET address = s.address", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT customer, purchases, address FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 5, "Adelphi"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Antioch"}));
            });
        });
    }

    @DataProvider
    public Object[][] partitionedBucketedFailure() {
        return new Object[][]{{"CREATE TABLE %s (customer STRING, purchases INT, address STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"CREATE TABLE %s (customer STRING, purchases INT, address STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"CREATE TABLE %s (purchases INT, address STRING) PARTITIONED BY (customer STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"CREATE TABLE %s (customer STRING, purchases INT) PARTITIONED BY (address STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"CREATE TABLE %s (purchases INT, address STRING) PARTITIONED BY (customer STRING) CLUSTERED BY (address) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')"}};
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeFailingPartitioning() {
        String testDescription = "failing_merge";
        this.withTemporaryTable(String.format("%s_target", testDescription), true, true, BucketingType.NONE, targetTable -> {
            QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (customer STRING, purchases INT, address STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable(String.format("%s_source", testDescription), true, true, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (purchases INT, address STRING) PARTITIONED BY (customer STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), new QueryExecutor.QueryParam[0]);
                String sql = String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
                QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT customer, purchases, address FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeFailureWithDifferentPartitioning() {
        this.testMergeWithDifferentPartitioningInternal("target_partitioned_source_partitioned_and_bucketed", "CREATE TABLE %s (purchases INT, address STRING) PARTITIONED BY (customer STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')", "CREATE TABLE %s (customer STRING, purchases INT) PARTITIONED BY (address STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')");
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L, dataProvider="targetAndSourceWithDifferentPartitioning")
    public void testMergeWithDifferentPartitioning(String testDescription, String createTargetTableSql, String createSourceTableSql) {
        this.testMergeWithDifferentPartitioningInternal(testDescription, createTargetTableSql, createSourceTableSql);
    }

    private void testMergeWithDifferentPartitioningInternal(String testDescription, String createTargetTableSql, String createSourceTableSql) {
        this.withTemporaryTable(String.format("%s_target", testDescription), true, true, BucketingType.NONE, targetTable -> {
            QueryExecutors.onHive().executeQuery(String.format(createTargetTableSql, targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable(String.format("%s_source", testDescription), true, true, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onHive().executeQuery(String.format(createSourceTableSql, sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), new QueryExecutor.QueryParam[0]);
                String sql = String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
                QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT customer, purchases, address FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}));
            });
        });
    }

    @DataProvider
    public Object[][] targetAndSourceWithDifferentPartitioning() {
        return new Object[][]{{"target_partitioned_source_and_target_partitioned_and_bucketed", "CREATE TABLE %s (customer STRING, purchases INT) PARTITIONED BY (address STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')", "CREATE TABLE %s (customer STRING, purchases INT) PARTITIONED BY (address STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"target_flat_source_partitioned_by_customer", "CREATE TABLE %s (customer STRING, purchases INT, address STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')", "CREATE TABLE %s (purchases INT, address STRING) PARTITIONED BY (customer STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"target_partitioned_by_customer_source_flat", "CREATE TABLE %s (purchases INT, address STRING) PARTITIONED BY (customer STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')", "CREATE TABLE %s (customer STRING, purchases INT, address STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"target_bucketed_by_customer_source_flat", "CREATE TABLE %s (customer STRING, purchases INT, address STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')", "CREATE TABLE %s (customer STRING, purchases INT, address STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"target_partitioned_source_partitioned_and_bucketed", "CREATE TABLE %s (purchases INT, address STRING) PARTITIONED BY (customer STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')", "CREATE TABLE %s (customer STRING, purchases INT) PARTITIONED BY (address STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')"}, {"target_partitioned_target_partitioned_and_bucketed", "CREATE TABLE %s (customer STRING, purchases INT) PARTITIONED BY (address STRING) CLUSTERED BY (customer) INTO 3 BUCKETS STORED AS ORC TBLPROPERTIES ('transactional'='true')", "CREATE TABLE %s (purchases INT, address STRING) PARTITIONED BY (customer STRING) STORED AS ORC TBLPROPERTIES ('transactional'='true')"}};
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeQueryWithStrangeCapitalization() {
        this.withTemporaryTable("test_without_aliases_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING ", targetTable.toUpperCase(Locale.ENGLISH)) + "(SELECT * FROM (VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville'))) AS s(customer, purchases, address)ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purCHases = s.PurchaseS + t.pUrchases, aDDress = s.addrESs    WHEN NOT MATCHED THEN INSERT (CUSTOMER, purchases, addRESS) VALUES(s.custoMer, s.Purchases, s.ADDress)", new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeWithoutTablesAliases() {
        this.withTemporaryTable("test_without_aliases_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (cusTomer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("test_without_aliases_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s USING %s", targetTable, sourceTable) + String.format(" ON (%s.customer = %s.customer)", targetTable, sourceTable) + String.format("    WHEN MATCHED AND %s.address = 'Centreville' THEN DELETE", sourceTable) + String.format("    WHEN MATCHED THEN UPDATE SET purchases = %s.pURCHases + %s.pUrchases, aDDress = %s.addrESs", sourceTable, targetTable, sourceTable) + String.format("    WHEN NOT MATCHED THEN INSERT (cusTomer, purchases, addRESS) VALUES(%s.custoMer, %s.Purchases, %s.ADDress)", sourceTable, sourceTable, sourceTable), new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeWithUnpredictablePredicates() {
        this.withTemporaryTable("test_without_aliases_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (cusTomer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("test_without_aliases_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville')", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer AND s.purchases < 10.2    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 11, "Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 11, "Darbyshire"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 11, "Devon"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 7, "Etherville"}));
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer    WHEN MATCHED AND t.address <> 'Darbyshire' AND s.purchases * 2 > 20        THEN DELETE    WHEN MATCHED        THEN UPDATE SET purchases = s.purchases + t.purchases, address = concat(t.address, '/', s.address)    WHEN NOT MATCHED        THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 17, "Arches/Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Carol", 9, "Centreville"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire/Darbyshire"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 14, "Etherville/Etherville"}));
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES('Fred', 30, 'Franklin')", targetTable), new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Aaron", 17, "Arches/Arches"}), QueryAssert.Row.row((Object[])new Object[]{"Bill", 7, "Buena"}), QueryAssert.Row.row((Object[])new Object[]{"Carol", 9, "Centreville"}), QueryAssert.Row.row((Object[])new Object[]{"Dave", 22, "Darbyshire/Darbyshire"}), QueryAssert.Row.row((Object[])new Object[]{"Ed", 14, "Etherville/Etherville"}), QueryAssert.Row.row((Object[])new Object[]{"Fred", 30, "Franklin"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeWithSimplifiedUnpredictablePredicates() {
        this.withTemporaryTable("test_without_aliases_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Devon'), ('Dave', 11, 'Darbyshire')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("test_without_aliases_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Dave', 11, 'Darbyshire')", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + " ON t.customer = s.customer    WHEN MATCHED AND t.address <> 'Darbyshire' AND s.purchases * 2 > 20        THEN DELETE", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"Dave", 11, "Darbyshire"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeCasts() {
        this.withTemporaryTable("merge_cast_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (col1 TINYINT, col2 SMALLINT, col3 INT, col4 BIGINT, col5 REAL, col6 DOUBLE) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (1, 2, 3, 4, 5, 6)", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("test_without_aliases_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (col1 DOUBLE, col2 REAL, col3 BIGINT, col4 INT, col5 SMALLINT, col6 TINYINT) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (2, 3, 4, 5, 6, 7)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + "    ON (t.col1 + 1 = s.col1)    WHEN MATCHED THEN UPDATE SET col1 = s.col1, col2 = s.col2, col3 = s.col3, col4 = s.col4, col5 = s.col5, col6 = s.col6", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{2, 3, 4, 5, 6.0, 7.0}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeSubqueries() {
        this.withTemporaryTable("merge_nation_target", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s (nation_name, region_name) VALUES ('FRANCE', 'EUROPE'), ('ALGERIA', 'AFRICA'), ('GERMANY', 'EUROPE')", targetTable), new QueryExecutor.QueryParam[0]);
            this.withTemporaryTable("merge_nation_source", true, false, BucketingType.NONE, sourceTable -> {
                QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR) WITH (transactional = true)", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES ('ALGERIA', 'AFRICA'), ('FRANCE', 'EUROPE'), ('EGYPT', 'MIDDLE EAST'), ('RUSSIA', 'EUROPE')", sourceTable), new QueryExecutor.QueryParam[0]);
                QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + "    ON (t.nation_name = s.nation_name)    WHEN MATCHED AND t.nation_name > (SELECT name FROM tpch.tiny.region WHERE name = t.region_name AND name LIKE ('A%'))        THEN DELETE    WHEN NOT MATCHED AND s.region_name = 'EUROPE'        THEN INSERT VALUES(s.nation_name, (SELECT 'EUROPE'))", new QueryExecutor.QueryParam[0]);
                TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT * FROM " + targetTable, "TRUE", QueryAssert.Row.row((Object[])new Object[]{"FRANCE", "EUROPE"}), QueryAssert.Row.row((Object[])new Object[]{"GERMANY", "EUROPE"}), QueryAssert.Row.row((Object[])new Object[]{"RUSSIA", "EUROPE"}));
            });
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=3600000L)
    public void testMergeOriginalFilesTarget() {
        this.withTemporaryTable("region", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s WITH (transactional=true) AS TABLE tpch.tiny.region", targetTable), new QueryExecutor.QueryParam[0]);
            QueryAssert.assertThat(() -> QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s r USING tpch.tiny.nation n", targetTable) + "    ON r.regionkey = n.regionkey    WHEN MATCHED        THEN UPDATE SET comment = n.comment", new QueryExecutor.QueryParam[0])).failsWithMessage("One MERGE target table row matched more than one source row");
            QueryExecutors.onTrino().executeQuery(String.format("MERGE INTO %s r USING tpch.tiny.nation n", targetTable) + "    ON r.regionkey = n.regionkey AND n.name = 'FRANCE'    WHEN MATCHED        THEN UPDATE SET name = 'EUROPEAN'", new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.verifySelectForTrinoAndHive("SELECT name  FROM " + targetTable, "name LIKE('EU%')", QueryAssert.Row.row((Object[])new Object[]{"EUROPEAN"}));
        });
    }

    @Test(groups={"hive_transactional"}, timeOut=900000L)
    public void testMergeOverManySplits() {
        this.withTemporaryTable("delete_select", true, false, BucketingType.NONE, targetTable -> {
            QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (orderkey bigint, custkey bigint, orderstatus varchar(1), totalprice double, orderdate date, orderpriority varchar(15), clerk varchar(15), shippriority integer, comment varchar(79)) WITH (transactional = true)", targetTable), new QueryExecutor.QueryParam[0]);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s SELECT * FROM tpch.\"sf0.1\".orders", targetTable), new QueryExecutor.QueryParam[0]);
            String sql = String.format("MERGE INTO %s t USING (SELECT * FROM tpch.\"sf0.1\".orders) s ON (t.orderkey = s.orderkey)", targetTable) + " WHEN MATCHED AND mod(s.orderkey, 3) = 0 THEN UPDATE SET totalprice = t.totalprice + s.totalprice WHEN MATCHED AND mod(s.orderkey, 3) = 1 THEN DELETE";
            QueryExecutors.onTrino().executeQuery(sql, new QueryExecutor.QueryParam[0]);
            TestHiveTransactionalTable.verifySelectForTrinoAndHive(String.format("SELECT count(*) FROM %s t", targetTable), "mod(t.orderkey, 3) = 1", QueryAssert.Row.row((Object[])new Object[]{0}));
        });
    }

    @DataProvider
    public Object[][] insertersProvider() {
        return new Object[][]{{false, Engine.HIVE, Engine.TRINO}, {false, Engine.TRINO, Engine.TRINO}, {true, Engine.HIVE, Engine.TRINO}, {true, Engine.TRINO, Engine.TRINO}};
    }

    private static QueryResult execute(Engine engine, String sql, QueryExecutor.QueryParam ... params) {
        return engine.queryExecutor().executeQuery(sql, params);
    }

    @DataProvider
    public Object[][] inserterAndDeleterProvider() {
        return new Object[][]{{Engine.HIVE, Engine.TRINO}, {Engine.TRINO, Engine.TRINO}, {Engine.TRINO, Engine.HIVE}};
    }

    void withTemporaryTable(String rootName, boolean transactional, boolean isPartitioned, BucketingType bucketingType, Consumer<String> testRunner) {
        if (transactional) {
            this.ensureTransactionalHive();
        }
        try (TemporaryHiveTable table = TemporaryHiveTable.temporaryHiveTable(TestHiveTransactionalTable.tableName(rootName, isPartitioned, bucketingType));){
            testRunner.accept(table.getName());
        }
    }

    private void ensureTransactionalHive() {
        if (this.getHiveVersionMajor() < 3) {
            throw new SkipException("Hive transactional tables are supported with Hive version 3 or above");
        }
    }
}

