/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests.product.hive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.trino.jdbc.Row;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.tempto.ProductTest;
import io.trino.tempto.assertions.QueryAssert;
import io.trino.tempto.hadoop.hdfs.HdfsClient;
import io.trino.tempto.query.QueryExecutionException;
import io.trino.tempto.query.QueryExecutor;
import io.trino.tempto.query.QueryResult;
import io.trino.testng.services.Flaky;
import io.trino.tests.product.hive.Engine;
import io.trino.tests.product.hive.util.TemporaryHiveTable;
import io.trino.tests.product.utils.JdbcDriverUtils;
import io.trino.tests.product.utils.QueryExecutors;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveStorageFormats
extends ProductTest {
    private static final String TPCH_SCHEMA = "tiny";
    @Inject(optional=true)
    @Named(value="databases.presto.admin_role_enabled")
    private boolean adminRoleEnabled;
    @Inject
    private HdfsClient hdfsClient;
    @Inject
    @Named(value="databases.hive.warehouse_directory_path")
    private String warehouseDirectory;
    private static final List<TimestampAndPrecision> TIMESTAMPS_FROM_HIVE = List.of(TestHiveStorageFormats.timestampAndPrecision("1967-01-02 12:01:00.111", HiveTimestampPrecision.NANOSECONDS, "1967-01-02 12:01:00.111", "1967-01-02 12:01:00.111000", "1967-01-02 12:01:00.111000000"), TestHiveStorageFormats.timestampAndPrecision("1967-01-02 12:01:00.1114", HiveTimestampPrecision.NANOSECONDS, "1967-01-02 12:01:00.111", "1967-01-02 12:01:00.111400", "1967-01-02 12:01:00.111400000"), TestHiveStorageFormats.timestampAndPrecision("1967-01-02 12:01:00.1115", HiveTimestampPrecision.NANOSECONDS, "1967-01-02 12:01:00.112", "1967-01-02 12:01:00.111500", "1967-01-02 12:01:00.111500000"), TestHiveStorageFormats.timestampAndPrecision("1967-01-02 12:01:00.111499", HiveTimestampPrecision.NANOSECONDS, "1967-01-02 12:01:00.111", "1967-01-02 12:01:00.111499", "1967-01-02 12:01:00.111499000"), TestHiveStorageFormats.timestampAndPrecision("1967-01-02 12:01:00.1113334", HiveTimestampPrecision.NANOSECONDS, "1967-01-02 12:01:00.111", "1967-01-02 12:01:00.111333", "1967-01-02 12:01:00.111333400"), TestHiveStorageFormats.timestampAndPrecision("1967-01-02 23:59:59.999999999", HiveTimestampPrecision.NANOSECONDS, "1967-01-03 00:00:00.000", "1967-01-03 00:00:00.000000", "1967-01-02 23:59:59.999999999"), TestHiveStorageFormats.timestampAndPrecision("1967-01-02 12:01:00.1110019", HiveTimestampPrecision.NANOSECONDS, "1967-01-02 12:01:00.111", "1967-01-02 12:01:00.111002", "1967-01-02 12:01:00.111001900"), TestHiveStorageFormats.timestampAndPrecision("1967-01-02 12:01:00.111901001", HiveTimestampPrecision.NANOSECONDS, "1967-01-02 12:01:00.112", "1967-01-02 12:01:00.111901", "1967-01-02 12:01:00.111901001"), TestHiveStorageFormats.timestampAndPrecision("1967-12-31 23:59:59.999999499", HiveTimestampPrecision.NANOSECONDS, "1968-01-01 00:00:00.000", "1967-12-31 23:59:59.999999", "1967-12-31 23:59:59.999999499"), TestHiveStorageFormats.timestampAndPrecision("2027-01-02 12:01:00.1110019", HiveTimestampPrecision.NANOSECONDS, "2027-01-02 12:01:00.111", "2027-01-02 12:01:00.111002", "2027-01-02 12:01:00.111001900"), TestHiveStorageFormats.timestampAndPrecision("2027-01-02 12:01:00.111901001", HiveTimestampPrecision.NANOSECONDS, "2027-01-02 12:01:00.112", "2027-01-02 12:01:00.111901", "2027-01-02 12:01:00.111901001"), TestHiveStorageFormats.timestampAndPrecision("2027-12-31 23:59:59.999999499", HiveTimestampPrecision.NANOSECONDS, "2028-01-01 00:00:00.000", "2027-12-31 23:59:59.999999", "2027-12-31 23:59:59.999999499"));
    private static final List<TimestampAndPrecision> TIMESTAMPS_FROM_TRINO = List.of(TestHiveStorageFormats.timestampAndPrecision("2020-01-02 12:01:00.999", HiveTimestampPrecision.MILLISECONDS, "2020-01-02 12:01:00.999", "2020-01-02 12:01:00.999000", "2020-01-02 12:01:00.999000000"), TestHiveStorageFormats.timestampAndPrecision("2020-01-02 12:01:00.111499999", HiveTimestampPrecision.MILLISECONDS, "2020-01-02 12:01:00.111", "2020-01-02 12:01:00.111000", "2020-01-02 12:01:00.111000000"), TestHiveStorageFormats.timestampAndPrecision("2020-01-02 12:01:00.1115", HiveTimestampPrecision.MILLISECONDS, "2020-01-02 12:01:00.112", "2020-01-02 12:01:00.112000", "2020-01-02 12:01:00.112000000"), TestHiveStorageFormats.timestampAndPrecision("2020-01-02 12:01:00.111333", HiveTimestampPrecision.MICROSECONDS, "2020-01-02 12:01:00.111", "2020-01-02 12:01:00.111333", "2020-01-02 12:01:00.111333000"), TestHiveStorageFormats.timestampAndPrecision("2020-01-02 12:01:00.1113334", HiveTimestampPrecision.MICROSECONDS, "2020-01-02 12:01:00.111", "2020-01-02 12:01:00.111333", "2020-01-02 12:01:00.111333000"), TestHiveStorageFormats.timestampAndPrecision("2020-01-02 12:01:00.111333777", HiveTimestampPrecision.MICROSECONDS, "2020-01-02 12:01:00.111", "2020-01-02 12:01:00.111334", "2020-01-02 12:01:00.111334000"), TestHiveStorageFormats.timestampAndPrecision("2020-01-02 12:01:00.111333444", HiveTimestampPrecision.NANOSECONDS, "2020-01-02 12:01:00.111", "2020-01-02 12:01:00.111333", "2020-01-02 12:01:00.111333444"), TestHiveStorageFormats.timestampAndPrecision("2020-01-02 23:59:59.999911333", HiveTimestampPrecision.MILLISECONDS, "2020-01-03 00:00:00.000", "2020-01-03 00:00:00.000000", "2020-01-03 00:00:00.000000000"), TestHiveStorageFormats.timestampAndPrecision("2020-12-31 23:59:59.99999", HiveTimestampPrecision.MILLISECONDS, "2021-01-01 00:00:00.000", "2021-01-01 00:00:00.000000", "2021-01-01 00:00:00.000000000"));

    @DataProvider
    public static String[] storageFormats() {
        return (String[])Stream.of(TestHiveStorageFormats.storageFormatsWithConfiguration()).map(StorageFormat::getName).distinct().toArray(String[]::new);
    }

    @DataProvider
    public static StorageFormat[] storageFormatsWithConfiguration() {
        return new StorageFormat[]{TestHiveStorageFormats.storageFormat("ORC", (Map<String, String>)ImmutableMap.of((Object)"hive.orc_optimized_writer_validate", (Object)"true")), TestHiveStorageFormats.storageFormat("PARQUET"), TestHiveStorageFormats.storageFormat("PARQUET", (Map<String, String>)ImmutableMap.of((Object)"hive.experimental_parquet_optimized_writer_enabled", (Object)"true")), TestHiveStorageFormats.storageFormat("RCBINARY", (Map<String, String>)ImmutableMap.of((Object)"hive.rcfile_optimized_writer_validate", (Object)"true")), TestHiveStorageFormats.storageFormat("RCTEXT", (Map<String, String>)ImmutableMap.of((Object)"hive.rcfile_optimized_writer_validate", (Object)"true")), TestHiveStorageFormats.storageFormat("SEQUENCEFILE"), TestHiveStorageFormats.storageFormat("TEXTFILE"), TestHiveStorageFormats.storageFormat("TEXTFILE", (Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of((Object)"textfile_field_separator", (Object)"F", (Object)"textfile_field_separator_escape", (Object)"E")), TestHiveStorageFormats.storageFormat("AVRO")};
    }

    @DataProvider
    public static StorageFormat[] storageFormatsWithNullFormat() {
        return new StorageFormat[]{TestHiveStorageFormats.storageFormat("TEXTFILE"), TestHiveStorageFormats.storageFormat("RCTEXT"), TestHiveStorageFormats.storageFormat("SEQUENCEFILE")};
    }

    @DataProvider
    public static StorageFormat[] storageFormatsWithZeroByteFile() {
        return new StorageFormat[]{TestHiveStorageFormats.storageFormat("ORC"), TestHiveStorageFormats.storageFormat("PARQUET"), TestHiveStorageFormats.storageFormat("RCBINARY"), TestHiveStorageFormats.storageFormat("RCTEXT"), TestHiveStorageFormats.storageFormat("SEQUENCEFILE"), TestHiveStorageFormats.storageFormat("TEXTFILE"), TestHiveStorageFormats.storageFormat("AVRO"), TestHiveStorageFormats.storageFormat("CSV")};
    }

    @DataProvider
    public static Iterator<StorageFormat> storageFormatsWithNanosecondPrecision() {
        return Stream.of(TestHiveStorageFormats.storageFormatsWithConfiguration()).filter(format -> !"AVRO".equals(format.getName())).iterator();
    }

    @Test
    public void verifyDataProviderCompleteness() {
        String formatsDescription = (String)Iterables.getOnlyElement((Iterable)((Iterable)Iterables.getOnlyElement((Iterable)QueryExecutors.onTrino().executeQuery("SELECT description FROM system.metadata.table_properties WHERE catalog_name = CURRENT_CATALOG AND property_name = 'format'", new QueryExecutor.QueryParam[0]).rows())));
        Pattern pattern = Pattern.compile("Hive storage format for the table. Possible values: \\[([A-Z]+(, [A-z]+)+)]");
        Assertions.assertThat((String)formatsDescription).matches(pattern);
        Matcher matcher = pattern.matcher(formatsDescription);
        Verify.verify((boolean)matcher.matches());
        List allFormats = Splitter.on((String)",").trimResults().splitToList((CharSequence)matcher.group(1));
        Set allFormatsToTest = (Set)allFormats.stream().filter(format -> !"CSV".equals(format)).filter(format -> !"JSON".equals(format)).collect(ImmutableSet.toImmutableSet());
        Assertions.assertThat((Iterable)ImmutableSet.copyOf((Object[])TestHiveStorageFormats.storageFormats())).isEqualTo((Object)allFormatsToTest);
    }

    @Test(dataProvider="storageFormatsWithConfiguration", groups={"storage_formats", "hms_only"})
    public void testInsertIntoTable(StorageFormat storageFormat) {
        this.setAdminRole();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_insert_into_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        String createTable = String.format("CREATE TABLE %s(   orderkey      BIGINT,   partkey       BIGINT,   suppkey       BIGINT,   linenumber    INTEGER,   quantity      DOUBLE,   extendedprice DOUBLE,   discount      DOUBLE,   tax           DOUBLE,   linestatus    VARCHAR,   shipinstruct  VARCHAR,   shipmode      VARCHAR,   comment       VARCHAR,   returnflag    VARCHAR) WITH (%s)", tableName, storageFormat.getStoragePropertiesAsSql());
        QueryExecutors.onTrino().executeQuery(createTable, new QueryExecutor.QueryParam[0]);
        String insertInto = String.format("INSERT INTO %s SELECT orderkey, partkey, suppkey, linenumber, quantity, extendedprice, discount, tax, linestatus, shipinstruct, shipmode, comment, returnflag FROM tpch.%s.lineitem", tableName, TPCH_SCHEMA);
        QueryExecutors.onTrino().executeQuery(insertInto, new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertResultEqualForLineitemTable("select sum(tax), sum(discount), sum(linenumber) from %s", tableName);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithConfiguration", groups={"storage_formats", "hms_only"})
    public void testCreateTableAs(StorageFormat storageFormat) {
        this.setAdminRole();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_create_table_as_select_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        String createTableAsSelect = String.format("CREATE TABLE %s WITH (%s) AS SELECT partkey, suppkey, extendedprice FROM tpch.%s.lineitem", tableName, storageFormat.getStoragePropertiesAsSql(), TPCH_SCHEMA);
        QueryExecutors.onTrino().executeQuery(createTableAsSelect, new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertResultEqualForLineitemTable("select sum(extendedprice), sum(suppkey), count(partkey) from %s", tableName);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithConfiguration", groups={"storage_formats", "hms_only"})
    public void testInsertIntoPartitionedTable(StorageFormat storageFormat) {
        this.setAdminRole();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_insert_into_partitioned_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        String createTable = String.format("CREATE TABLE %s(   orderkey      BIGINT,   partkey       BIGINT,   suppkey       BIGINT,   linenumber    INTEGER,   quantity      DOUBLE,   extendedprice DOUBLE,   discount      DOUBLE,   tax           DOUBLE,   linestatus    VARCHAR,   shipinstruct  VARCHAR,   shipmode      VARCHAR,   comment       VARCHAR,   returnflag    VARCHAR) WITH (format='%s', partitioned_by = ARRAY['returnflag'])", tableName, storageFormat.getName());
        QueryExecutors.onTrino().executeQuery(createTable, new QueryExecutor.QueryParam[0]);
        String insertInto = String.format("INSERT INTO %s SELECT orderkey, partkey, suppkey, linenumber, quantity, extendedprice, discount, tax, linestatus, shipinstruct, shipmode, comment, returnflag FROM tpch.%s.lineitem", tableName, TPCH_SCHEMA);
        QueryExecutors.onTrino().executeQuery(insertInto, new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertResultEqualForLineitemTable("select sum(tax), sum(discount), sum(length(returnflag)) from %s", tableName);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithNullFormat", groups={"storage_formats_detailed", "hms_only"})
    public void testInsertAndSelectWithNullFormat(StorageFormat storageFormat) {
        String nullFormat = "null_value";
        String tableName = String.format("test_storage_format_%s_insert_and_select_with_null_format", storageFormat.getName());
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (value VARCHAR) WITH (format = '%s', null_format = '%s')", tableName, storageFormat.getName(), nullFormat), new QueryExecutor.QueryParam[0]);
        String[] values = new String[]{nullFormat, null, "non-null", "", "\\N"};
        QueryAssert.Row[] storedValues = (QueryAssert.Row[])Arrays.stream(values).map(xva$0 -> QueryAssert.Row.row((Object[])new Object[]{xva$0})).toArray(QueryAssert.Row[]::new);
        storedValues[0] = QueryAssert.Row.row((Object[])new Object[]{null});
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(values.length, "(?)"));
        QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES %s", tableName, placeholders), (QueryExecutor.QueryParam[])Arrays.stream(values).map(value -> QueryExecutor.param((JDBCType)JDBCType.VARCHAR, (Object)value)).toArray(QueryExecutor.QueryParam[]::new));
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0])).containsOnly(storedValues);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithZeroByteFile", groups={"storage_formats_detailed"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testSelectFromZeroByteFile(StorageFormat storageFormat) {
        String tableName = String.format("test_storage_format_%s_zero_byte_file", storageFormat.getName());
        this.hdfsClient.saveFile(String.format("%s/%s/zero_byte", this.warehouseDirectory, tableName), InputStream.nullInputStream());
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (name varchar) WITH (    format = '%s')", tableName, storageFormat.getName()), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).hasNoRows();
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithNullFormat", groups={"storage_formats_detailed"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testSelectWithNullFormat(StorageFormat storageFormat) {
        String nullFormat = "null_value";
        String tableName = String.format("test_storage_format_%s_select_with_null_format", storageFormat.getName());
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s (value VARCHAR) WITH (format = '%s', null_format = '%s')", tableName, storageFormat.getName(), nullFormat), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s VALUES ('non-null'), (NULL), ('%s')", tableName, nullFormat), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT * FROM %s", tableName), new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"non-null"}), QueryAssert.Row.row((Object[])new Object[]{null}), QueryAssert.Row.row((Object[])new Object[]{null})});
        QueryExecutors.onHive().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithConfiguration", groups={"storage_formats", "hms_only"})
    public void testCreatePartitionedTableAs(StorageFormat storageFormat) {
        this.setAdminRole();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        String tableName = "storage_formats_test_create_table_as_select_partitioned_" + storageFormat.getName().toLowerCase(Locale.ENGLISH);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE IF EXISTS %s", tableName), new QueryExecutor.QueryParam[0]);
        String createTableAsSelect = String.format("CREATE TABLE %s WITH (%s, partitioned_by = ARRAY['returnflag']) AS SELECT tax, discount, returnflag FROM tpch.%s.lineitem", tableName, storageFormat.getStoragePropertiesAsSql(), TPCH_SCHEMA);
        QueryExecutors.onTrino().executeQuery(createTableAsSelect, new QueryExecutor.QueryParam[0]);
        TestHiveStorageFormats.assertResultEqualForLineitemTable("select sum(tax), sum(discount), sum(length(returnflag)) from %s", tableName);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats"})
    public void testOrcTableCreatedInTrino() {
        QueryExecutors.onTrino().executeQuery("CREATE TABLE orc_table_created_in_trino WITH (format='ORC') AS SELECT 42 a", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM orc_table_created_in_trino", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM orc_table_created_in_trino", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onHive().executeQuery("SELECT * FROM orc_table_created_in_trino WHERE a < 43", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE orc_table_created_in_trino", new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormats", groups={"storage_formats_detailed"})
    public void testNestedFieldsWrittenByHive(String format) {
        this.testNestedFields(format, Engine.HIVE);
    }

    @Test(dataProvider="storageFormats", groups={"storage_formats_detailed"})
    public void testNestedFieldsWrittenByTrino(String format) {
        this.testNestedFields(format, Engine.TRINO);
    }

    private void testNestedFields(String format, Engine writer) {
        String tableName = "test_nested_fields_written_by_" + writer.name().toLowerCase(Locale.ENGLISH);
        QueryExecutors.onTrino().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " (  r row(a int),   rr row(r row(a int)),   ra row(a array(int)),   dummy varchar) WITH (format='" + format + "')", new QueryExecutor.QueryParam[0]);
        switch (writer) {
            case HIVE: {
                this.ensureDummyExists();
                writer.queryExecutor().executeQuery("INSERT INTO " + tableName + " SELECT named_struct('a', 42), named_struct('r', named_struct('a', 43)), named_struct('a', array(11, 22, 33)), 'dummy value' FROM dummy", new QueryExecutor.QueryParam[0]);
                break;
            }
            case TRINO: {
                writer.queryExecutor().executeQuery("INSERT INTO " + tableName + " VALUES (row(42), row(row(43)), row(ARRAY[11, 22, 33]), 'dummy value')", new QueryExecutor.QueryParam[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported writer: " + writer);
            }
        }
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{TestHiveStorageFormats.rowBuilder().addField("a", (Object)42).build(), TestHiveStorageFormats.rowBuilder().addField("r", (Object)TestHiveStorageFormats.rowBuilder().addField("a", (Object)43).build()).build(), TestHiveStorageFormats.rowBuilder().addField("a", List.of(Integer.valueOf(11), Integer.valueOf(22), Integer.valueOf(33))).build(), "dummy value"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT r.a, rr.r.a, ra.a[2] FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{42, 43, 22})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT dummy FROM " + tableName + " WHERE r.a = 42 AND rr.r.a = 43 AND ra.a[2] = 22", new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"dummy value"})});
        if (writer != Engine.HIVE) {
            QueryResult queryResult = null;
            try {
                queryResult = QueryExecutors.onHive().executeQuery("SELECT * FROM " + tableName, new QueryExecutor.QueryParam[0]);
                Verify.verify((queryResult != null ? 1 : 0) != 0);
            }
            catch (QueryExecutionException e) {
                if ("AVRO".equals(format)) {
                    Assertions.assertThat((Throwable)e.getCause()).hasToString("java.sql.SQLException: java.io.IOException: org.apache.avro.AvroTypeException: Found default.record_1, expecting union");
                }
                throw e;
            }
            if (queryResult != null) {
                QueryAssert.assertThat((QueryResult)queryResult).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"{\"a\":42}", "{\"r\":{\"a\":43}}", "{\"a\":[11,22,33]}", "dummy value"})});
            }
        }
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats_detailed"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testOrcStructsWithNonLowercaseFields() throws SQLException {
        String tableName = "orc_structs_with_non_lowercase";
        this.ensureDummyExists();
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS " + tableName, new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("CREATE TABLE %s (   c_bigint BIGINT,   c_struct struct<testCustId:string, requestDate:string>)STORED AS ORC ", tableName), new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s SELECT   1,   named_struct('testCustId', '1234', 'requestDate', 'some day') FROM dummy", tableName), new QueryExecutor.QueryParam[0]);
        JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.projection_pushdown_enabled", "true");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT c_struct.testCustId FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1234"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT c_struct.testcustid FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1234"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT c_struct.requestDate FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some day"})});
        JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.projection_pushdown_enabled", "false");
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT c_struct.testCustId FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1234"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT c_struct.testcustid FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"1234"})});
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT c_struct.requestDate FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{"some day"})});
    }

    @Test(dataProvider="storageFormatsWithNanosecondPrecision", groups={"storage_formats_detailed"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testTimestampCreatedFromHive(StorageFormat storageFormat) {
        String tableName = this.createSimpleTimestampTable("timestamps_from_hive", storageFormat);
        for (TimestampAndPrecision entry : TIMESTAMPS_FROM_HIVE) {
            QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %s VALUES (%s, '%s')", tableName, entry.getId(), entry.getWriteValue()), new QueryExecutor.QueryParam[0]);
        }
        TestHiveStorageFormats.assertSimpleTimestamps(tableName, TIMESTAMPS_FROM_HIVE);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithNanosecondPrecision", groups={"storage_formats_detailed", "hms_only"})
    public void testTimestampCreatedFromTrino(StorageFormat storageFormat) {
        String tableName = this.createSimpleTimestampTable("timestamps_from_trino", storageFormat);
        for (TimestampAndPrecision entry : TIMESTAMPS_FROM_TRINO) {
            TestHiveStorageFormats.setTimestampPrecision(entry.getPrecision());
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (%s, TIMESTAMP '%s')", tableName, entry.getId(), entry.getWriteValue()), new QueryExecutor.QueryParam[0]);
        }
        TestHiveStorageFormats.assertSimpleTimestamps(tableName, TIMESTAMPS_FROM_TRINO);
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithNanosecondPrecision", groups={"storage_formats_detailed"})
    @Flaky(issue="https://github.com/trinodb/trino/issues/4936", match="(could only be replicated to 0 nodes instead of minReplication|could only be written to 0 of the 1 minReplication)")
    public void testStructTimestampsFromHive(StorageFormat format) {
        String tableName = this.createStructTimestampTable("hive_struct_timestamp", format);
        this.setAdminRole(QueryExecutors.onTrino().getConnection());
        this.ensureDummyExists();
        for (TimestampAndPrecision entry : TIMESTAMPS_FROM_HIVE) {
            QueryExecutors.onHive().executeQuery(String.format("INSERT INTO %1$s SELECT   %3$s,   array(%2$s),   map(%2$s, %2$s),   named_struct('col', %2$s),   array(map(%2$s, named_struct('col', array(%2$s)))) FROM dummy", tableName, String.format("TIMESTAMP '%s'", entry.getWriteValue()), entry.getId()), new QueryExecutor.QueryParam[0]);
        }
        this.assertStructTimestamps(tableName, TIMESTAMPS_FROM_HIVE);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(dataProvider="storageFormatsWithNanosecondPrecision", groups={"storage_formats_detailed", "hms_only"})
    public void testStructTimestampsFromTrino(StorageFormat format) {
        String tableName = this.createStructTimestampTable("trino_struct_timestamp", format);
        this.setAdminRole(QueryExecutors.onTrino().getConnection());
        TIMESTAMPS_FROM_TRINO.stream().collect(Collectors.groupingBy(TimestampAndPrecision::getPrecision)).forEach((precision, data) -> {
            TestHiveStorageFormats.setTimestampPrecision(precision);
            QueryExecutors.onTrino().executeQuery(String.format("INSERT INTO %s VALUES (%s)", tableName, data.stream().map(entry -> String.format("%s, array[%2$s], map(array[%2$s], array[%2$s]), row(%2$s), array[map(array[%2$s], array[row(array[%2$s])])]", entry.getId(), String.format("TIMESTAMP '%s'", entry.getWriteValue()))).collect(Collectors.joining("), ("))), new QueryExecutor.QueryParam[0]);
        });
        this.assertStructTimestamps(tableName, TIMESTAMPS_FROM_TRINO);
        QueryExecutors.onTrino().executeQuery(String.format("DROP TABLE %s", tableName), new QueryExecutor.QueryParam[0]);
    }

    @Test(groups={"storage_formats_detailed"})
    public void testLargeParquetInsert() {
        DataSize reducedRowGroupSize = DataSize.ofBytes((long)262144L);
        this.runLargeInsert(TestHiveStorageFormats.storageFormat("PARQUET", (Map<String, String>)ImmutableMap.of((Object)"hive.parquet_writer_page_size", (Object)reducedRowGroupSize.toBytesValueString(), (Object)"task_scale_writers_enabled", (Object)"false", (Object)"task_writer_count", (Object)"1")));
    }

    @Test(groups={"storage_formats_detailed"})
    public void testLargeParquetInsertWithNativeWriter() {
        DataSize reducedRowGroupSize = DataSize.ofBytes((long)262144L);
        this.runLargeInsert(TestHiveStorageFormats.storageFormat("PARQUET", (Map<String, String>)ImmutableMap.of((Object)"hive.experimental_parquet_optimized_writer_enabled", (Object)"true", (Object)"hive.parquet_writer_page_size", (Object)reducedRowGroupSize.toBytesValueString(), (Object)"task_scale_writers_enabled", (Object)"false", (Object)"task_writer_count", (Object)"1")));
    }

    @Test(groups={"storage_formats_detailed"})
    public void testLargeOrcInsert() {
        this.runLargeInsert(TestHiveStorageFormats.storageFormat("ORC", (Map<String, String>)ImmutableMap.of((Object)"hive.orc_optimized_writer_validate", (Object)"true")));
    }

    private void runLargeInsert(StorageFormat storageFormat) {
        String tableName = "test_large_insert_" + storageFormat.getName() + TemporaryHiveTable.randomTableSuffix();
        TestHiveStorageFormats.setSessionProperties(storageFormat);
        QueryExecutors.onTrino().executeQuery("CREATE TABLE " + tableName + " WITH (" + storageFormat.getStoragePropertiesAsSql() + ") AS SELECT * FROM tpch.sf1.lineitem WHERE false", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onTrino().executeQuery("INSERT INTO " + tableName + " SELECT * FROM tpch.sf1.lineitem", new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery("SELECT count(*) FROM " + tableName, new QueryExecutor.QueryParam[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{6001215L})});
        QueryExecutors.onTrino().executeQuery("DROP TABLE " + tableName, new QueryExecutor.QueryParam[0]);
    }

    private String createSimpleTimestampTable(String tableNamePrefix, StorageFormat format) {
        return this.createTestTable(tableNamePrefix, format, "(id BIGINT, ts TIMESTAMP)");
    }

    private static void assertSimpleTimestamps(String tableName, List<TimestampAndPrecision> data) {
        SoftAssertions softly = new SoftAssertions();
        for (TimestampAndPrecision entry : data) {
            for (HiveTimestampPrecision precision : HiveTimestampPrecision.values()) {
                TestHiveStorageFormats.setTimestampPrecision(precision);
                softly.check(() -> ((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT id, typeof(ts), CAST(ts AS varchar), ts FROM %s WHERE id = %s", tableName, entry.getId()), new QueryExecutor.QueryParam[0])).as("timestamp(%d)", new Object[]{precision.getPrecision()})).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{entry.getId(), entry.getReadType(precision), entry.getReadValue(precision), Timestamp.valueOf(entry.getReadValue(precision))})}));
            }
        }
        softly.assertAll();
    }

    private String createStructTimestampTable(String tableNamePrefix, StorageFormat format) {
        return this.createTestTable(tableNamePrefix, format, "(   id INTEGER,   arr ARRAY(TIMESTAMP),   map MAP(TIMESTAMP, TIMESTAMP),   row ROW(col TIMESTAMP),   nested ARRAY(MAP(TIMESTAMP, ROW(col ARRAY(TIMESTAMP)))))");
    }

    private void assertStructTimestamps(String tableName, Collection<TimestampAndPrecision> data) {
        SoftAssertions softly = new SoftAssertions();
        for (HiveTimestampPrecision precision : HiveTimestampPrecision.values()) {
            TestHiveStorageFormats.setTimestampPrecision(precision);
            String type = String.format("timestamp(%d)", precision.getPrecision());
            softly.check(() -> ((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT   typeof(arr),   typeof(map),   typeof(row),   typeof(nested) FROM %s LIMIT 1", tableName), new QueryExecutor.QueryParam[0])).as("timestamp container types", new Object[0])).containsOnly(new QueryAssert.Row[]{QueryAssert.Row.row((Object[])new Object[]{String.format("array(%s)", type), String.format("map(%1$s, %1$s)", type), String.format("row(col %s)", type), String.format("array(map(%1$s, row(col array(%1$s))))", type)})}));
            softly.check(() -> ((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT   id,   CAST(arr[1] AS VARCHAR),   CAST(map_entries(map)[1][1] AS VARCHAR),   CAST(map_entries(map)[1][2] AS VARCHAR),   CAST(row.col AS VARCHAR),   CAST(map_entries(nested[1])[1][1] AS VARCHAR),   CAST(map_entries(nested[1])[1][2].col[1] AS VARCHAR) FROM %s ORDER BY id", tableName), new QueryExecutor.QueryParam[0])).as("timestamp containers as varchar", new Object[0])).containsExactlyInOrder(data.stream().sorted(Comparator.comparingInt(TimestampAndPrecision::getId)).map(e -> new QueryAssert.Row(Lists.asList((Object)e.getId(), (Object[])Collections.nCopies(6, e.getReadValue(precision)).toArray()))).collect(Collectors.toList())));
            softly.check(() -> ((QueryAssert)QueryAssert.assertThat((QueryResult)QueryExecutors.onTrino().executeQuery(String.format("SELECT   id,   arr[1],   map_entries(map)[1][1],   map_entries(map)[1][2],   row.col,   map_entries(nested[1])[1][1],   map_entries(nested[1])[1][2].col[1] FROM %s ORDER BY id", tableName), new QueryExecutor.QueryParam[0])).as("timestamp containers", new Object[0])).containsExactlyInOrder(data.stream().sorted(Comparator.comparingInt(TimestampAndPrecision::getId)).map(e -> new QueryAssert.Row(Lists.asList((Object)e.getId(), (Object[])Collections.nCopies(6, Timestamp.valueOf(e.getReadValue(precision))).toArray()))).collect(Collectors.toList())));
        }
        softly.assertAll();
    }

    private String createTestTable(String tableNamePrefix, StorageFormat format, String sql) {
        this.setAdminRole(QueryExecutors.onTrino().getConnection());
        TestHiveStorageFormats.setSessionProperties(QueryExecutors.onTrino().getConnection(), format);
        String formatName = format.getName().toLowerCase(Locale.ENGLISH);
        String tableName = String.format("%s_%s_%s", tableNamePrefix, formatName, TemporaryHiveTable.randomTableSuffix());
        QueryExecutors.onTrino().executeQuery(String.format("CREATE TABLE %s %s WITH (%s)", tableName, sql, format.getStoragePropertiesAsSql()), new QueryExecutor.QueryParam[0]);
        return tableName;
    }

    private static void assertResultEqualForLineitemTable(String query, String tableName) {
        QueryResult expected = QueryExecutors.onTrino().executeQuery(String.format(query, "tpch.tiny.lineitem"), new QueryExecutor.QueryParam[0]);
        List expectedRows = (List)expected.rows().stream().map(columns -> QueryAssert.Row.row((Object[])columns.toArray())).collect(ImmutableList.toImmutableList());
        QueryResult actual = QueryExecutors.onTrino().executeQuery(String.format(query, tableName), new QueryExecutor.QueryParam[0]);
        QueryAssert.assertThat((QueryResult)actual).hasColumns(expected.getColumnTypes()).containsExactlyInOrder(expectedRows);
    }

    private void setAdminRole() {
        this.setAdminRole(QueryExecutors.onTrino().getConnection());
    }

    private void setAdminRole(Connection connection) {
        if (this.adminRoleEnabled) {
            return;
        }
        try {
            JdbcDriverUtils.setRole(connection, "admin");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ensureDummyExists() {
        QueryExecutors.onHive().executeQuery("DROP TABLE IF EXISTS dummy", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("CREATE TABLE dummy (dummy varchar(1))", new QueryExecutor.QueryParam[0]);
        QueryExecutors.onHive().executeQuery("INSERT INTO dummy VALUES ('x')", new QueryExecutor.QueryParam[0]);
    }

    private static void setTimestampPrecision(HiveTimestampPrecision readPrecision) {
        try {
            JdbcDriverUtils.setSessionProperty(QueryExecutors.onTrino().getConnection(), "hive.timestamp_precision", readPrecision.name());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setSessionProperties(StorageFormat storageFormat) {
        TestHiveStorageFormats.setSessionProperties(QueryExecutors.onTrino().getConnection(), storageFormat);
    }

    private static void setSessionProperties(Connection connection, StorageFormat storageFormat) {
        TestHiveStorageFormats.setSessionProperties(connection, storageFormat.getSessionProperties());
    }

    private static void setSessionProperties(Connection connection, Map<String, String> sessionProperties) {
        try {
            JdbcDriverUtils.setSessionProperty(connection, "task_writer_count", "4");
            JdbcDriverUtils.setSessionProperty(connection, "task_scale_writers_enabled", "false");
            JdbcDriverUtils.setSessionProperty(connection, "redistribute_writes", "false");
            for (Map.Entry<String, String> sessionProperty : sessionProperties.entrySet()) {
                JdbcDriverUtils.setSessionProperty(connection, sessionProperty.getKey(), sessionProperty.getValue());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static StorageFormat storageFormat(String name) {
        return TestHiveStorageFormats.storageFormat(name, (Map<String, String>)ImmutableMap.of());
    }

    private static StorageFormat storageFormat(String name, Map<String, String> sessionProperties) {
        return new StorageFormat(name, sessionProperties, (Map<String, String>)ImmutableMap.of());
    }

    private static StorageFormat storageFormat(String name, Map<String, String> sessionProperties, Map<String, String> properties) {
        return new StorageFormat(name, sessionProperties, properties);
    }

    private static TimestampAndPrecision timestampAndPrecision(String writeValue, HiveTimestampPrecision precision, String milliReadValue, String microReadValue, String nanoReadValue) {
        Map<HiveTimestampPrecision, String> readValues = Map.of(HiveTimestampPrecision.MILLISECONDS, milliReadValue, HiveTimestampPrecision.MICROSECONDS, microReadValue, HiveTimestampPrecision.NANOSECONDS, nanoReadValue);
        return new TimestampAndPrecision(precision, writeValue, readValues);
    }

    private static Row.Builder rowBuilder() {
        return Row.builder();
    }

    public static class StorageFormat {
        private final String name;
        private final Map<String, String> properties;
        private final Map<String, String> sessionProperties;

        private StorageFormat(String name, Map<String, String> sessionProperties, Map<String, String> properties) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.properties = Objects.requireNonNull(properties, "properties is null");
            this.sessionProperties = Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        }

        public String getName() {
            return this.name;
        }

        public String getStoragePropertiesAsSql() {
            return Stream.concat(Stream.of(Maps.immutableEntry((Object)"format", (Object)this.name)), this.properties.entrySet().stream()).map(entry -> String.format("%s = '%s'", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        }

        public Map<String, String> getSessionProperties() {
            return this.sessionProperties;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("properties", this.properties).add("sessionProperties", this.sessionProperties).toString();
        }
    }

    private static class TimestampAndPrecision {
        private static int counter;
        private final int id = counter++;
        private final HiveTimestampPrecision precision;
        private final String writeValue;
        private final Map<HiveTimestampPrecision, String> readValues;

        public TimestampAndPrecision(HiveTimestampPrecision precision, String writeValue, Map<HiveTimestampPrecision, String> readValues) {
            this.precision = precision;
            this.writeValue = writeValue;
            this.readValues = readValues;
        }

        public int getId() {
            return this.id;
        }

        public HiveTimestampPrecision getPrecision() {
            return this.precision;
        }

        public String getWriteValue() {
            return this.writeValue;
        }

        public String getReadValue(HiveTimestampPrecision precision) {
            return Objects.requireNonNull(this.readValues.get(precision), () -> "no read value for " + precision);
        }

        public String getReadType(HiveTimestampPrecision precision) {
            return String.format("timestamp(%s)", precision.getPrecision());
        }
    }
}

